---
name: Bug report
about: Create a report to help us improve
title: "\U0001F41B [BUG]"
labels: bug
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Minimal code to reproduce the behavior. Please be try to isolate the code producing the error code from code specific to your task but not necessarily relevant to the error (e.g. replacing input data with random inputs instead of data from files). 

**Expected behavior**
A clear and concise description of what you expected to happen.

**Environment (please complete the following information):**
 - OS: [e.g. iOS, Ubuntu, Windows]
 - python version (`python --version`)
 - python environment (commands are given for python interpreter):
   - e3nn version (`import e3nn; e3nn.__version__`)
   - pytorch version (`import torch; torch.__version__`)
   - pytorch_geometric version (`import torch_geometric; torch_geometric.__version__`)
 - (if relevant) GPU support with CUDA
   -  cuda Version according to nvcc (`nvcc --version`)
   -  cuda version according to pyTorch (`import torch; torch.version.cuda`)

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Additional context**
Add any other context about the problem here.
