// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package defaults

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetDefaultsSectionsOKCode is the HTTP code returned for type GetDefaultsSectionsOK
const GetDefaultsSectionsOKCode int = 200

/*
GetDefaultsSectionsOK Successful operation

swagger:response getDefaultsSectionsOK
*/
type GetDefaultsSectionsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.DefaultsSections `json:"body,omitempty"`
}

// NewGetDefaultsSectionsOK creates GetDefaultsSectionsOK with default headers values
func NewGetDefaultsSectionsOK() *GetDefaultsSectionsOK {

	return &GetDefaultsSectionsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get defaults sections o k response
func (o *GetDefaultsSectionsOK) WithConfigurationVersion(configurationVersion string) *GetDefaultsSectionsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get defaults sections o k response
func (o *GetDefaultsSectionsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get defaults sections o k response
func (o *GetDefaultsSectionsOK) WithPayload(payload models.DefaultsSections) *GetDefaultsSectionsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get defaults sections o k response
func (o *GetDefaultsSectionsOK) SetPayload(payload models.DefaultsSections) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetDefaultsSectionsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.DefaultsSections{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetDefaultsSectionsDefault General Error

swagger:response getDefaultsSectionsDefault
*/
type GetDefaultsSectionsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetDefaultsSectionsDefault creates GetDefaultsSectionsDefault with default headers values
func NewGetDefaultsSectionsDefault(code int) *GetDefaultsSectionsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetDefaultsSectionsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get defaults sections default response
func (o *GetDefaultsSectionsDefault) WithStatusCode(code int) *GetDefaultsSectionsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get defaults sections default response
func (o *GetDefaultsSectionsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get defaults sections default response
func (o *GetDefaultsSectionsDefault) WithConfigurationVersion(configurationVersion string) *GetDefaultsSectionsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get defaults sections default response
func (o *GetDefaultsSectionsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get defaults sections default response
func (o *GetDefaultsSectionsDefault) WithPayload(payload *models.Error) *GetDefaultsSectionsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get defaults sections default response
func (o *GetDefaultsSectionsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetDefaultsSectionsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
