// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateTCPResponseRuleBackendCreatedCode is the HTTP code returned for type CreateTCPResponseRuleBackendCreated
const CreateTCPResponseRuleBackendCreatedCode int = 201

/*
CreateTCPResponseRuleBackendCreated TCP Response Rule created

swagger:response createTcpResponseRuleBackendCreated
*/
type CreateTCPResponseRuleBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.TCPResponseRule `json:"body,omitempty"`
}

// NewCreateTCPResponseRuleBackendCreated creates CreateTCPResponseRuleBackendCreated with default headers values
func NewCreateTCPResponseRuleBackendCreated() *CreateTCPResponseRuleBackendCreated {

	return &CreateTCPResponseRuleBackendCreated{}
}

// WithPayload adds the payload to the create Tcp response rule backend created response
func (o *CreateTCPResponseRuleBackendCreated) WithPayload(payload *models.TCPResponseRule) *CreateTCPResponseRuleBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp response rule backend created response
func (o *CreateTCPResponseRuleBackendCreated) SetPayload(payload *models.TCPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPResponseRuleBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPResponseRuleBackendAcceptedCode is the HTTP code returned for type CreateTCPResponseRuleBackendAccepted
const CreateTCPResponseRuleBackendAcceptedCode int = 202

/*
CreateTCPResponseRuleBackendAccepted Configuration change accepted and reload requested

swagger:response createTcpResponseRuleBackendAccepted
*/
type CreateTCPResponseRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.TCPResponseRule `json:"body,omitempty"`
}

// NewCreateTCPResponseRuleBackendAccepted creates CreateTCPResponseRuleBackendAccepted with default headers values
func NewCreateTCPResponseRuleBackendAccepted() *CreateTCPResponseRuleBackendAccepted {

	return &CreateTCPResponseRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the create Tcp response rule backend accepted response
func (o *CreateTCPResponseRuleBackendAccepted) WithReloadID(reloadID string) *CreateTCPResponseRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Tcp response rule backend accepted response
func (o *CreateTCPResponseRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Tcp response rule backend accepted response
func (o *CreateTCPResponseRuleBackendAccepted) WithPayload(payload *models.TCPResponseRule) *CreateTCPResponseRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp response rule backend accepted response
func (o *CreateTCPResponseRuleBackendAccepted) SetPayload(payload *models.TCPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPResponseRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPResponseRuleBackendBadRequestCode is the HTTP code returned for type CreateTCPResponseRuleBackendBadRequest
const CreateTCPResponseRuleBackendBadRequestCode int = 400

/*
CreateTCPResponseRuleBackendBadRequest Bad request

swagger:response createTcpResponseRuleBackendBadRequest
*/
type CreateTCPResponseRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPResponseRuleBackendBadRequest creates CreateTCPResponseRuleBackendBadRequest with default headers values
func NewCreateTCPResponseRuleBackendBadRequest() *CreateTCPResponseRuleBackendBadRequest {

	return &CreateTCPResponseRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Tcp response rule backend bad request response
func (o *CreateTCPResponseRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateTCPResponseRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Tcp response rule backend bad request response
func (o *CreateTCPResponseRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Tcp response rule backend bad request response
func (o *CreateTCPResponseRuleBackendBadRequest) WithPayload(payload *models.Error) *CreateTCPResponseRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp response rule backend bad request response
func (o *CreateTCPResponseRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPResponseRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTCPResponseRuleBackendConflictCode is the HTTP code returned for type CreateTCPResponseRuleBackendConflict
const CreateTCPResponseRuleBackendConflictCode int = 409

/*
CreateTCPResponseRuleBackendConflict The specified resource already exists

swagger:response createTcpResponseRuleBackendConflict
*/
type CreateTCPResponseRuleBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPResponseRuleBackendConflict creates CreateTCPResponseRuleBackendConflict with default headers values
func NewCreateTCPResponseRuleBackendConflict() *CreateTCPResponseRuleBackendConflict {

	return &CreateTCPResponseRuleBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Tcp response rule backend conflict response
func (o *CreateTCPResponseRuleBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateTCPResponseRuleBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Tcp response rule backend conflict response
func (o *CreateTCPResponseRuleBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Tcp response rule backend conflict response
func (o *CreateTCPResponseRuleBackendConflict) WithPayload(payload *models.Error) *CreateTCPResponseRuleBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Tcp response rule backend conflict response
func (o *CreateTCPResponseRuleBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPResponseRuleBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateTCPResponseRuleBackendDefault General Error

swagger:response createTcpResponseRuleBackendDefault
*/
type CreateTCPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTCPResponseRuleBackendDefault creates CreateTCPResponseRuleBackendDefault with default headers values
func NewCreateTCPResponseRuleBackendDefault(code int) *CreateTCPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateTCPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create TCP response rule backend default response
func (o *CreateTCPResponseRuleBackendDefault) WithStatusCode(code int) *CreateTCPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create TCP response rule backend default response
func (o *CreateTCPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create TCP response rule backend default response
func (o *CreateTCPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateTCPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create TCP response rule backend default response
func (o *CreateTCPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create TCP response rule backend default response
func (o *CreateTCPResponseRuleBackendDefault) WithPayload(payload *models.Error) *CreateTCPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create TCP response rule backend default response
func (o *CreateTCPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTCPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
