/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.StdOutWriter;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public final class Out
implements ErrorMessages {
    public static final String NL = System.getProperty("line.separator");
    public static boolean VERBOSE = true;
    public static boolean TIME = false;
    public static boolean DUMP = false;
    public static boolean DOT = false;
    public static final boolean DEBUG = false;
    public static int warnings;
    public static int errors;
    private static StdOutWriter out;

    public static void setGUIMode(TextArea textArea) {
        out.setGUIMode(textArea);
    }

    public static void time(String string) {
        if (TIME) {
            out.println(string);
        }
    }

    public static void println(String string) {
        if (VERBOSE) {
            out.println(string);
        }
    }

    public static void print(String string) {
        if (VERBOSE) {
            out.print(string);
        }
    }

    public static void debug(String string) {
    }

    public static void dump(String string) {
        if (DUMP) {
            out.println(string);
        }
    }

    private static void err(String string) {
        out.println(string);
    }

    public static void checkErrors() {
        if (errors > 0) {
            throw new GeneratorException();
        }
    }

    public static void statistics() {
        StringBuffer stringBuffer = new StringBuffer(errors + " error");
        if (errors != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(", " + warnings + " warning");
        if (warnings != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(".");
        Out.err(stringBuffer.toString());
    }

    public static void resetCounters() {
        errors = 0;
        warnings = 0;
    }

    public static void warning(String string) {
        ++warnings;
        Out.err(NL + "Warning : " + string);
    }

    public static void warning(int n, int n2) {
        ++warnings;
        String string = NL + "Warning";
        if (n2 > 0) {
            string = string + " in line " + (n2 + 1);
        }
        Out.err(string + ": " + ErrorMessages.messages[n]);
    }

    public static void warning(File file, int n, int n2, int n3) {
        String string = NL + "Warning";
        if (file != null) {
            string = string + " in file \"" + file + "\"";
        }
        if (n2 >= 0) {
            string = string + " (line " + (n2 + 1) + ")";
        }
        try {
            Out.err(string + ": " + NL + ErrorMessages.messages[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Out.err(string);
        }
        ++warnings;
        if (n2 >= 0) {
            if (n3 >= 0) {
                Out.showPosition(file, n2, n3);
            } else {
                Out.showPosition(file, n2);
            }
        }
    }

    public static void error(String string) {
        ++errors;
        Out.err(NL + string);
    }

    public static void error(int n) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.messages[n]);
    }

    public static void error(int n, File file) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.messages[n] + " (" + file + ")");
    }

    public static void error(File file, int n, int n2, int n3) {
        String string = NL + "Error";
        if (file != null) {
            string = string + " in file \"" + file + "\"";
        }
        if (n2 >= 0) {
            string = string + " (line " + (n2 + 1) + ")";
        }
        try {
            Out.err(string + ": " + NL + ErrorMessages.messages[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Out.err(string);
        }
        ++errors;
        if (n2 >= 0) {
            if (n3 >= 0) {
                Out.showPosition(file, n2, n3);
            } else {
                Out.showPosition(file, n2);
            }
        }
    }

    public static void showPosition(File file, int n, int n2) {
        try {
            String string = Out.getLine(file, n);
            if (string != null) {
                Out.err(string);
                if (n2 < 0) {
                    return;
                }
                String string2 = "^";
                int n3 = 0;
                while (n3 < n2) {
                    string2 = " " + string2;
                    ++n3;
                }
                Out.err(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void showPosition(File file, int n) {
        try {
            String string = Out.getLine(file, n);
            if (string != null) {
                Out.err(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getLine(File file, int n) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        int n2 = 0;
        while (n2 <= n) {
            string = bufferedReader.readLine();
            ++n2;
        }
        bufferedReader.close();
        return string;
    }

    public static void printSystemInfo() {
        Out.err("Java version:  " + System.getProperty("java.version"));
        Out.err("Runtime name:  " + System.getProperty("java.runtime.name"));
        Out.err("Vendor:        " + System.getProperty("java.vendor"));
        Out.err("VM version:    " + System.getProperty("java.vm.version"));
        Out.err("VM vendor:     " + System.getProperty("java.vm.vendor"));
        Out.err("VM name:       " + System.getProperty("java.vm.name"));
        Out.err("VM info:       " + System.getProperty("java.vm.info"));
        Out.err("OS name:       " + System.getProperty("os.name"));
        Out.err("OS arch:       " + System.getProperty("os.arch"));
        Out.err("OS version:    " + System.getProperty("os.version"));
        Out.err("Encoding:      " + System.getProperty("file.encoding"));
        Out.err("JFlex version: 1.3.5");
    }

    public static void requestBugReport(Error error) {
        Out.err("An unexpected error occurred. Please send a report of this to");
        Out.err("<bugs@jflex.de> and include the following information:");
        Out.err("");
        Out.printSystemInfo();
        Out.err("Exception:");
        error.printStackTrace(out);
        Out.err("");
        Out.err("Please also include a specification (as small as possible)");
        Out.err("that triggered this error. You may also want to check at");
        Out.err("http://www.jflex.de if there is a newer version available");
        Out.err("that doesn't have this problem");
        Out.err("");
        Out.err("Thanks for your support.");
    }

    static {
        out = new StdOutWriter();
    }
}

