# Helper tools to generate certain markdown files

The CI scripts and Dockerfiles are more complex than what most users care about,
they install development tools, such as code formatters, and drivers for the
integration tests. The instructions in our user-facing documentation are
intended to be minimal and to the point.

Verifying these instructions manually is very tedious, instead, we use Docker as
a scripting language to execute these instructions, and then automatically
reformat the "script" as markdown.

## HOWTO: Generate the markdown files

The markdown files are automatically generated by the `checker-pr` build. For
example, if you change docker files or build instructions, the markdown files
can be generated with the following command:

```bash
ci/cloudbuild/build.sh -t checkers-pr --docker
git status # should show the edited files
```

NOTE: You can manually run individual generator scripts as shown here:

```bash
ci/generate-markdown/generate-packaging.sh >doc/packaging.md
```
