// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/generator.proto

#include "google/cloud/dialogflow_cx/internal/generators_auth_decorator.h"
#include <google/cloud/dialogflow/cx/v3/generator.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GeneratorsAuth::GeneratorsAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<GeneratorsStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::dialogflow::cx::v3::ListGeneratorsResponse>
GeneratorsAuth::ListGenerators(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::ListGeneratorsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListGenerators(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsAuth::GetGenerator(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::GetGeneratorRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetGenerator(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsAuth::CreateGenerator(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::CreateGeneratorRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateGenerator(context, options, request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsAuth::UpdateGenerator(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateGenerator(context, options, request);
}

Status GeneratorsAuth::DeleteGenerator(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteGenerator(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
