// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey_admin.proto

#include "google/cloud/kms/v1/internal/autokey_admin_auth_decorator.h"
#include <google/cloud/kms/v1/autokey_admin.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AutokeyAdminAuth::AutokeyAdminAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<AutokeyAdminStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminAuth::UpdateAutokeyConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::UpdateAutokeyConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateAutokeyConfig(context, options, request);
}

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminAuth::GetAutokeyConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::GetAutokeyConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetAutokeyConfig(context, options, request);
}

StatusOr<google::cloud::kms::v1::ShowEffectiveAutokeyConfigResponse>
AutokeyAdminAuth::ShowEffectiveAutokeyConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::ShowEffectiveAutokeyConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ShowEffectiveAutokeyConfig(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1_internal
}  // namespace cloud
}  // namespace google
