// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/query_service.proto

#include "google/cloud/monitoring/v3/internal/query_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

QueryServiceTracingConnection::QueryServiceTracingConnection(
    std::shared_ptr<monitoring_v3::QueryServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::monitoring::v3::TimeSeriesData>
QueryServiceTracingConnection::QueryTimeSeries(
    google::monitoring::v3::QueryTimeSeriesRequest request) {
  auto span = internal::MakeSpan(
      "monitoring_v3::QueryServiceConnection::QueryTimeSeries");
  internal::OTelScope scope(span);
  auto sr = child_->QueryTimeSeries(std::move(request));
  return internal::MakeTracedStreamRange<
      google::monitoring::v3::TimeSeriesData>(std::move(span), std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<monitoring_v3::QueryServiceConnection>
MakeQueryServiceTracingConnection(
    std::shared_ptr<monitoring_v3::QueryServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<QueryServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
