// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/networkconnectivity/v1/policy_based_routing.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkconnectivity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PolicyBasedRoutingServiceStub::~PolicyBasedRoutingServiceStub() = default;

StatusOr<google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesResponse>
DefaultPolicyBasedRoutingServiceStub::ListPolicyBasedRoutes(
    grpc::ClientContext& context, Options const&,
    google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesRequest const&
        request) {
  google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesResponse
      response;
  auto status = grpc_stub_->ListPolicyBasedRoutes(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
DefaultPolicyBasedRoutingServiceStub::GetPolicyBasedRoute(
    grpc::ClientContext& context, Options const&,
    google::cloud::networkconnectivity::v1::GetPolicyBasedRouteRequest const&
        request) {
  google::cloud::networkconnectivity::v1::PolicyBasedRoute response;
  auto status = grpc_stub_->GetPolicyBasedRoute(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPolicyBasedRoutingServiceStub::AsyncCreatePolicyBasedRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::networkconnectivity::v1::CreatePolicyBasedRouteRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::networkconnectivity::v1::CreatePolicyBasedRouteRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::networkconnectivity::v1::
                 CreatePolicyBasedRouteRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreatePolicyBasedRoute(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultPolicyBasedRoutingServiceStub::CreatePolicyBasedRoute(
    grpc::ClientContext& context, Options,
    google::cloud::networkconnectivity::v1::CreatePolicyBasedRouteRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->CreatePolicyBasedRoute(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPolicyBasedRoutingServiceStub::AsyncDeletePolicyBasedRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::networkconnectivity::v1::DeletePolicyBasedRouteRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::networkconnectivity::v1::DeletePolicyBasedRouteRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::networkconnectivity::v1::
                 DeletePolicyBasedRouteRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeletePolicyBasedRoute(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultPolicyBasedRoutingServiceStub::DeletePolicyBasedRoute(
    grpc::ClientContext& context, Options,
    google::cloud::networkconnectivity::v1::DeletePolicyBasedRouteRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->DeletePolicyBasedRoute(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPolicyBasedRoutingServiceStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultPolicyBasedRoutingServiceStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1_internal
}  // namespace cloud
}  // namespace google
