// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#include "google/cloud/privilegedaccessmanager/v1/internal/privileged_access_manager_auth_decorator.h"
#include <google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PrivilegedAccessManagerAuth::PrivilegedAccessManagerAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<PrivilegedAccessManagerStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<
    google::cloud::privilegedaccessmanager::v1::CheckOnboardingStatusResponse>
PrivilegedAccessManagerAuth::CheckOnboardingStatus(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::
        CheckOnboardingStatusRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CheckOnboardingStatus(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::ListEntitlementsResponse>
PrivilegedAccessManagerAuth::ListEntitlements(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::ListEntitlementsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListEntitlements(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::SearchEntitlementsResponse>
PrivilegedAccessManagerAuth::SearchEntitlements(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::SearchEntitlementsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchEntitlements(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerAuth::GetEntitlement(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetEntitlement(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerAuth::AsyncCreateEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateEntitlement(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerAuth::CreateEntitlement(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateEntitlement(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerAuth::AsyncDeleteEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteEntitlement(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerAuth::DeleteEntitlement(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteEntitlement(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerAuth::AsyncUpdateEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateEntitlement(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerAuth::UpdateEntitlement(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateEntitlement(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::ListGrantsResponse>
PrivilegedAccessManagerAuth::ListGrants(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::ListGrantsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListGrants(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::SearchGrantsResponse>
PrivilegedAccessManagerAuth::SearchGrants(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchGrants(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerAuth::GetGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetGrant(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerAuth::CreateGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateGrant(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerAuth::ApproveGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ApproveGrant(context, options, request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerAuth::DenyGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DenyGrant(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerAuth::AsyncRevokeGrant(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncRevokeGrant(cq, *std::move(context),
                                       std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerAuth::RevokeGrant(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RevokeGrant(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context),
                                        std::move(options), request);
      });
}

future<Status> PrivilegedAccessManagerAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context),
                                           std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1_internal
}  // namespace cloud
}  // namespace google
