// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_SECURE_SOURCE_MANAGER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_SECURE_SOURCE_MANAGER_CONNECTION_H

#include "google/cloud/securesourcemanager/v1/internal/secure_source_manager_retry_traits.h"
#include "google/cloud/securesourcemanager/v1/secure_source_manager_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/securesourcemanager/v1/secure_source_manager.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace securesourcemanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `SecureSourceManagerConnection`.
class SecureSourceManagerRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<SecureSourceManagerRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `SecureSourceManagerConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class SecureSourceManagerLimitedErrorCountRetryPolicy
    : public SecureSourceManagerRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit SecureSourceManagerLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  SecureSourceManagerLimitedErrorCountRetryPolicy(
      SecureSourceManagerLimitedErrorCountRetryPolicy&& rhs) noexcept
      : SecureSourceManagerLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  SecureSourceManagerLimitedErrorCountRetryPolicy(
      SecureSourceManagerLimitedErrorCountRetryPolicy const& rhs) noexcept
      : SecureSourceManagerLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<SecureSourceManagerRetryPolicy> clone() const override {
    return std::make_unique<SecureSourceManagerLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = SecureSourceManagerRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      securesourcemanager_v1_internal::SecureSourceManagerRetryTraits>
      impl_;
};

/**
 * A retry policy for `SecureSourceManagerConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class SecureSourceManagerLimitedTimeRetryPolicy
    : public SecureSourceManagerRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit SecureSourceManagerLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  SecureSourceManagerLimitedTimeRetryPolicy(
      SecureSourceManagerLimitedTimeRetryPolicy&& rhs) noexcept
      : SecureSourceManagerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  SecureSourceManagerLimitedTimeRetryPolicy(
      SecureSourceManagerLimitedTimeRetryPolicy const& rhs) noexcept
      : SecureSourceManagerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<SecureSourceManagerRetryPolicy> clone() const override {
    return std::make_unique<SecureSourceManagerLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = SecureSourceManagerRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      securesourcemanager_v1_internal::SecureSourceManagerRetryTraits>
      impl_;
};

/**
 * The `SecureSourceManagerConnection` object for `SecureSourceManagerClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `SecureSourceManagerClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `SecureSourceManagerClient`.
 *
 * To create a concrete instance, see `MakeSecureSourceManagerConnection()`.
 *
 * For mocking, see
 * `securesourcemanager_v1_mocks::MockSecureSourceManagerConnection`.
 */
class SecureSourceManagerConnection {
 public:
  virtual ~SecureSourceManagerConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::securesourcemanager::v1::Instance>
  ListInstances(
      google::cloud::securesourcemanager::v1::ListInstancesRequest request);

  virtual StatusOr<google::cloud::securesourcemanager::v1::Instance>
  GetInstance(google::cloud::securesourcemanager::v1::GetInstanceRequest const&
                  request);

  virtual future<StatusOr<google::cloud::securesourcemanager::v1::Instance>>
  CreateInstance(
      google::cloud::securesourcemanager::v1::CreateInstanceRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateInstance(
      NoAwaitTag,
      google::cloud::securesourcemanager::v1::CreateInstanceRequest const&
          request);

  virtual future<StatusOr<google::cloud::securesourcemanager::v1::Instance>>
  CreateInstance(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::securesourcemanager::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::securesourcemanager::v1::DeleteInstanceRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag,
      google::cloud::securesourcemanager::v1::DeleteInstanceRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::securesourcemanager::v1::OperationMetadata>>
  DeleteInstance(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::securesourcemanager::v1::Repository>
  ListRepositories(
      google::cloud::securesourcemanager::v1::ListRepositoriesRequest request);

  virtual StatusOr<google::cloud::securesourcemanager::v1::Repository>
  GetRepository(
      google::cloud::securesourcemanager::v1::GetRepositoryRequest const&
          request);

  virtual future<StatusOr<google::cloud::securesourcemanager::v1::Repository>>
  CreateRepository(
      google::cloud::securesourcemanager::v1::CreateRepositoryRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateRepository(
      NoAwaitTag,
      google::cloud::securesourcemanager::v1::CreateRepositoryRequest const&
          request);

  virtual future<StatusOr<google::cloud::securesourcemanager::v1::Repository>>
  CreateRepository(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::securesourcemanager::v1::OperationMetadata>>
  DeleteRepository(
      google::cloud::securesourcemanager::v1::DeleteRepositoryRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteRepository(
      NoAwaitTag,
      google::cloud::securesourcemanager::v1::DeleteRepositoryRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::securesourcemanager::v1::OperationMetadata>>
  DeleteRepository(google::longrunning::Operation const& operation);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicyRepo(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicyRepo(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissionsRepo(
      google::iam::v1::TestIamPermissionsRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `SecureSourceManagerConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * SecureSourceManagerClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `SecureSourceManagerConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * -
 * `google::cloud::securesourcemanager_v1::SecureSourceManagerPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `SecureSourceManagerConnection`
 * created by this function.
 */
std::shared_ptr<SecureSourceManagerConnection>
MakeSecureSourceManagerConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securesourcemanager_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_SECURE_SOURCE_MANAGER_CONNECTION_H
