/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.util.IoUtil;

public class StandardPluginClassLoader
extends PluginClassLoader {
    static Log log = LogFactory.getLog(class$org$java$plugin$standard$StandardPluginClassLoader == null ? (class$org$java$plugin$standard$StandardPluginClassLoader = StandardPluginClassLoader.class$("org.java.plugin.standard.StandardPluginClassLoader")) : class$org$java$plugin$standard$StandardPluginClassLoader);
    private static File libCacheFolder;
    private static boolean libCacheFolderInitialized;
    private PluginDescriptor[] publicImports;
    private PluginDescriptor[] privateImports;
    private PluginResourceLoader resourceLoader;
    private Map resourceFilters;
    private Map libraryCache;
    static /* synthetic */ Class class$org$java$plugin$standard$StandardPluginClassLoader;
    static /* synthetic */ Class class$org$java$plugin$standard$StandardPluginClassLoader$PluginResourceLoader;

    private static URL getClassBaseUrl(Class clazz) {
        CodeSource codeSource;
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
            return codeSource.getLocation();
        }
        return null;
    }

    private static URL[] getUrls(PluginManager pluginManager, PluginDescriptor pluginDescriptor) {
        Object object;
        LinkedList<URL> linkedList = new LinkedList<URL>();
        Object object2 = pluginDescriptor.getLibraries().iterator();
        while (object2.hasNext()) {
            object = (Library)object2.next();
            if (!object.isCodeLibrary()) continue;
            linkedList.add(pluginManager.getPathResolver().resolvePath((Identity)object, object.getPath()));
        }
        if (log.isDebugEnabled()) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("Code URL's populated for plug-in " + pluginDescriptor + ":\r\n");
            object = linkedList.iterator();
            while (object.hasNext()) {
                ((StringBuffer)object2).append("\t");
                ((StringBuffer)object2).append(object.next());
                ((StringBuffer)object2).append("\r\n");
            }
            log.trace(((StringBuffer)object2).toString());
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    private static URL[] getUrls(PluginManager pluginManager, PluginDescriptor pluginDescriptor, URL[] uRLArray) {
        List<URL> list = Arrays.asList(uRLArray);
        LinkedList<URL> linkedList = new LinkedList<URL>();
        Iterator iterator = pluginDescriptor.getLibraries().iterator();
        while (iterator.hasNext()) {
            URL uRL;
            Library library = (Library)iterator.next();
            if (!library.isCodeLibrary() || list.contains(uRL = pluginManager.getPathResolver().resolvePath(library, library.getPath()))) continue;
            linkedList.add(uRL);
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getLibCacheFolder() {
        if (libCacheFolder != null) {
            return libCacheFolderInitialized ? libCacheFolder : null;
        }
        Class clazz = class$org$java$plugin$standard$StandardPluginClassLoader == null ? (class$org$java$plugin$standard$StandardPluginClassLoader = StandardPluginClassLoader.class$("org.java.plugin.standard.StandardPluginClassLoader")) : class$org$java$plugin$standard$StandardPluginClassLoader;
        synchronized (clazz) {
            libCacheFolder = new File(System.getProperty("java.io.tmpdir"), System.currentTimeMillis() + ".jpf-lib-cache");
            log.debug("libraries cache folder is " + libCacheFolder);
            File file = new File(libCacheFolder, "lock");
            if (file.exists()) {
                log.error("can't initialize libraries cache folder " + libCacheFolder + " as lock file indicates that it" + " is owned by another JPF instance");
                return null;
            }
            if (libCacheFolder.exists()) {
                IoUtil.emptyFolder(libCacheFolder);
            } else {
                libCacheFolder.mkdirs();
            }
            try {
                if (!file.createNewFile()) {
                    log.error("can't create lock file in JPF libraries cache folder " + libCacheFolder);
                    return null;
                }
            }
            catch (IOException iOException) {
                log.error("can't create lock file in JPF libraries cache folder " + libCacheFolder, iOException);
                return null;
            }
            file.deleteOnExit();
            libCacheFolder.deleteOnExit();
            libCacheFolderInitialized = true;
        }
        return libCacheFolder;
    }

    public StandardPluginClassLoader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader classLoader) {
        super(pluginManager, pluginDescriptor, StandardPluginClassLoader.getUrls(pluginManager, pluginDescriptor), classLoader);
        this.collectImports();
        this.resourceLoader = PluginResourceLoader.get(pluginManager, pluginDescriptor);
        this.collectFilters();
        this.libraryCache = new HashMap();
    }

    private void collectImports() {
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        HashMap<String, PluginDescriptor> hashMap2 = new HashMap<String, PluginDescriptor>();
        Iterator iterator = this.getPluginDescriptor().getPrerequisites().iterator();
        while (iterator.hasNext()) {
            PluginPrerequisite pluginPrerequisite = (PluginPrerequisite)iterator.next();
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor().getRegistry().getPluginDescriptor(pluginPrerequisite.getPluginId());
            if (pluginPrerequisite.isExported()) {
                hashMap.put(pluginDescriptor.getId(), pluginDescriptor);
                continue;
            }
            hashMap2.put(pluginDescriptor.getId(), pluginDescriptor);
        }
        this.publicImports = hashMap.values().toArray(new PluginDescriptor[hashMap.size()]);
        this.privateImports = hashMap2.values().toArray(new PluginDescriptor[hashMap2.size()]);
    }

    private void collectFilters() {
        if (this.resourceFilters == null) {
            this.resourceFilters = new HashMap();
        } else {
            this.resourceFilters.clear();
        }
        Iterator iterator = this.getPluginDescriptor().getLibraries().iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            this.resourceFilters.put(this.getPluginManager().getPathResolver().resolvePath(library, library.getPath()), new ResourceFilter(library));
        }
    }

    protected void pluginsSetChanged() {
        URL[] uRLArray = StandardPluginClassLoader.getUrls(this.getPluginManager(), this.getPluginDescriptor(), this.getURLs());
        for (int i = 0; i < uRLArray.length; ++i) {
            this.addURL(uRLArray[i]);
        }
        if (log.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("New code URL's populated for plug-in " + this.getPluginDescriptor() + ":\r\n");
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append("\t");
                stringBuffer.append(uRLArray[i]);
                stringBuffer.append("\r\n");
            }
            log.trace(stringBuffer.toString());
        }
        this.collectImports();
        this.resourceLoader = PluginResourceLoader.get(this.getPluginManager(), this.getPluginDescriptor());
        this.collectFilters();
        Iterator iterator = this.libraryCache.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != null) continue;
            iterator.remove();
        }
    }

    protected void dispose() {
        Iterator iterator = this.libraryCache.values().iterator();
        while (iterator.hasNext()) {
            ((File)iterator.next()).delete();
        }
        this.libraryCache.clear();
        this.resourceFilters.clear();
        this.privateImports = null;
        this.publicImports = null;
        this.resourceLoader = null;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            return this.getParent().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = this.loadClass(string, bl, this, null);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(String string, boolean bl, StandardPluginClassLoader standardPluginClassLoader, Set hashSet) throws ClassNotFoundException {
        if (hashSet != null && hashSet.contains(this.getPluginDescriptor().getId())) {
            return null;
        }
        if (this != standardPluginClassLoader && !this.getPluginManager().isPluginActivated(this.getPluginDescriptor()) && !this.getPluginManager().isPluginActivating(this.getPluginDescriptor())) {
            String string2 = "can't load class " + string + ", plug-in " + this.getPluginDescriptor() + " is not activated yet";
            log.warn(string2);
            throw new ClassNotFoundException(string2);
        }
        Class clazz = null;
        StandardPluginClassLoader standardPluginClassLoader2 = this;
        synchronized (standardPluginClassLoader2) {
            int n;
            clazz = this.findLoadedClass(string);
            if (clazz != null) {
                this.checkClassVisibility(clazz, standardPluginClassLoader);
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                this.checkClassVisibility(clazz, standardPluginClassLoader);
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(this.getPluginDescriptor().getId());
            for (n = 0; n < this.publicImports.length; ++n) {
                if (hashSet.contains(this.publicImports[n].getId()) || (clazz = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(this.publicImports[n])).loadClass(string, bl, standardPluginClassLoader, hashSet)) == null) continue;
                if (!bl) break;
                this.resolveClass(clazz);
                break;
            }
            if (this == standardPluginClassLoader && clazz == null) {
                for (n = 0; n < this.privateImports.length; ++n) {
                    if (hashSet.contains(this.privateImports[n].getId()) || (clazz = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(this.privateImports[n])).loadClass(string, bl, standardPluginClassLoader, hashSet)) == null) continue;
                    if (!bl) break;
                    this.resolveClass(clazz);
                    break;
                }
            }
        }
        return clazz;
    }

    private void checkClassVisibility(Class clazz, StandardPluginClassLoader standardPluginClassLoader) throws ClassNotFoundException {
        log.debug("checkClassVisibility(Class, PluginClassLoader): class=" + clazz.getName() + ", requestor=" + standardPluginClassLoader + ", this=" + this);
        if (this == standardPluginClassLoader) {
            return;
        }
        URL uRL = StandardPluginClassLoader.getClassBaseUrl(clazz);
        if (uRL == null) {
            return;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        if (!(classLoader instanceof StandardPluginClassLoader)) {
            return;
        }
        if (classLoader != this) {
            ((StandardPluginClassLoader)classLoader).checkClassVisibility(clazz, standardPluginClassLoader);
        } else {
            ResourceFilter resourceFilter = (ResourceFilter)this.resourceFilters.get(uRL);
            if (resourceFilter == null || !resourceFilter.isClassVisible(clazz.getName())) {
                String string = "class " + clazz.getName() + " is not visible for plug-in " + standardPluginClassLoader.getPluginDescriptor().getId();
                log.warn(string);
                throw new ClassNotFoundException(string);
            }
        }
    }

    protected String findLibrary(String string) {
        if (string == null || "".equals(string.trim())) {
            return null;
        }
        log.debug("findLibrary(String): libname=" + string);
        string = System.mapLibraryName(string);
        String string2 = null;
        PathResolver pathResolver = this.getPluginManager().getPathResolver();
        Iterator iterator = this.getPluginDescriptor().getLibraries().iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            if (library.isCodeLibrary()) continue;
            URL uRL = pathResolver.resolvePath(library, library.getPath() + string);
            log.debug("findLibrary(String): trying URL " + uRL);
            File file = IoUtil.url2file(uRL);
            if (file != null) {
                log.debug("findLibrary(String): URL " + uRL + " resolved as local file " + file);
                if (!file.isFile()) continue;
                string2 = file.getAbsolutePath();
                break;
            }
            file = (File)this.libraryCache.get(string);
            if (file != null) {
                if (file.isFile()) {
                    string2 = file.getAbsolutePath();
                    break;
                }
                this.libraryCache.remove(string);
            }
            if (this.libraryCache.containsKey(string)) break;
            file = this.cacheLibrary(uRL, string);
            if (file == null) continue;
            string2 = file.getAbsolutePath();
            break;
        }
        log.debug("findLibrary(String): result=" + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized File cacheLibrary(URL uRL, String string) {
        File file = StandardPluginClassLoader.getLibCacheFolder();
        if (this.libraryCache.containsKey(string)) {
            return (File)this.libraryCache.get(string);
        }
        File file2 = null;
        try {
            if (file == null) {
                throw new IOException("can't initialize libraries cache folder");
            }
            File file3 = new File(file, this.getPluginDescriptor().getUniqueId());
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("can't create cache folder " + file3);
            }
            file2 = new File(file3, string);
            InputStream inputStream = uRL.openStream();
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                try {
                    int n;
                    byte[] byArray = new byte[512];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    }
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
            this.libraryCache.put(string, file2);
            log.debug("library " + string + " successfully cached from URL " + uRL + " and saved to local file " + file2);
        }
        catch (IOException iOException) {
            log.error("can't cache library " + string + " from URL " + uRL, iOException);
            this.libraryCache.put(string, null);
            file2 = null;
        }
        return file2;
    }

    public URL findResource(String string) {
        log.debug("findResource(String): name=" + string);
        URL uRL = this.findResource(string, this, null);
        log.debug("findResource(String): result=" + uRL);
        return uRL;
    }

    public Enumeration findResources(String string) throws IOException {
        LinkedList linkedList = new LinkedList();
        this.findResources(linkedList, string, this, null);
        return Collections.enumeration(linkedList);
    }

    private URL findResource(String string, StandardPluginClassLoader standardPluginClassLoader, Set hashSet) {
        int n;
        log.debug("findResource(String,...): name=" + string + ", this=" + this);
        if (hashSet != null && hashSet.contains(this.getPluginDescriptor().getId())) {
            return null;
        }
        URL uRL = super.findResource(string);
        if (uRL != null) {
            if (this.isResourceVisible(string, uRL, standardPluginClassLoader)) {
                return uRL;
            }
            return null;
        }
        if (this.resourceLoader != null && (uRL = this.resourceLoader.findResource(string)) != null) {
            if (this.isResourceVisible(string, uRL, standardPluginClassLoader)) {
                return uRL;
            }
            return null;
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        hashSet.add(this.getPluginDescriptor().getId());
        for (n = 0; n < this.publicImports.length && (hashSet.contains(this.publicImports[n].getId()) || (uRL = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(this.publicImports[n])).findResource(string, standardPluginClassLoader, hashSet)) == null); ++n) {
        }
        if (this == standardPluginClassLoader && uRL == null) {
            for (n = 0; n < this.privateImports.length && (hashSet.contains(this.privateImports[n].getId()) || (uRL = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(this.privateImports[n])).findResource(string, standardPluginClassLoader, hashSet)) == null); ++n) {
            }
        }
        return uRL;
    }

    private void findResources(List list, String string, StandardPluginClassLoader standardPluginClassLoader, Set hashSet) throws IOException {
        int n;
        URL uRL;
        if (hashSet != null && hashSet.contains(this.getPluginDescriptor().getId())) {
            return;
        }
        Enumeration<URL> enumeration = super.findResources(string);
        while (enumeration.hasMoreElements()) {
            uRL = enumeration.nextElement();
            if (!this.isResourceVisible(string, uRL, standardPluginClassLoader)) continue;
            list.add(uRL);
        }
        if (this.resourceLoader != null) {
            enumeration = this.resourceLoader.findResources(string);
            while (enumeration.hasMoreElements()) {
                uRL = enumeration.nextElement();
                if (!this.isResourceVisible(string, uRL, standardPluginClassLoader)) continue;
                list.add(uRL);
            }
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        hashSet.add(this.getPluginDescriptor().getId());
        for (n = 0; n < this.publicImports.length; ++n) {
            if (hashSet.contains(this.publicImports[n].getId())) continue;
            ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(this.publicImports[n])).findResources(list, string, standardPluginClassLoader, hashSet);
        }
        if (this == standardPluginClassLoader) {
            for (n = 0; n < this.privateImports.length; ++n) {
                if (hashSet.contains(this.privateImports[n].getId())) continue;
                ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(this.privateImports[n])).findResources(list, string, standardPluginClassLoader, hashSet);
            }
        }
    }

    private boolean isResourceVisible(String string, URL uRL, StandardPluginClassLoader standardPluginClassLoader) {
        Object object;
        log.debug("isResourceVisible(URL, PluginClassLoader): URL=" + uRL + ", requestor=" + standardPluginClassLoader);
        if (this == standardPluginClassLoader) {
            return true;
        }
        URL uRL2 = null;
        String string2 = uRL.getFile();
        try {
            object = string2.substring(0, string2.length() - string.length());
            String string3 = uRL.getProtocol();
            uRL2 = "jar".equals(string3) ? (((String)object).endsWith("!/") ? new URL(((String)object).substring(0, ((String)object).length() - 2)) : (((String)object).endsWith("!") ? new URL(((String)object).substring(0, ((String)object).length() - 1)) : new URL((String)object))) : new URL(string3, uRL.getHost(), (String)object);
        }
        catch (MalformedURLException malformedURLException) {
            log.error("can't get resource library URL", malformedURLException);
            return false;
        }
        object = (ResourceFilter)this.resourceFilters.get(uRL2);
        if (object == null) {
            return false;
        }
        return ((ResourceFilter)object).isResourceVisible(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        libCacheFolderInitialized = false;
    }

    private static class PluginResourceLoader
    extends URLClassLoader {
        private static Log logger = LogFactory.getLog(class$org$java$plugin$standard$StandardPluginClassLoader$PluginResourceLoader == null ? (class$org$java$plugin$standard$StandardPluginClassLoader$PluginResourceLoader = StandardPluginClassLoader.class$("org.java.plugin.standard.StandardPluginClassLoader$PluginResourceLoader")) : class$org$java$plugin$standard$StandardPluginClassLoader$PluginResourceLoader);

        static PluginResourceLoader get(PluginManager pluginManager, PluginDescriptor pluginDescriptor) {
            Object object;
            LinkedList<URL> linkedList = new LinkedList<URL>();
            Object object2 = pluginDescriptor.getLibraries().iterator();
            while (object2.hasNext()) {
                object = (Library)object2.next();
                if (object.isCodeLibrary()) continue;
                linkedList.add(pluginManager.getPathResolver().resolvePath((Identity)object, object.getPath()));
            }
            if (logger.isDebugEnabled()) {
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("Resource URL's populated for plug-in " + pluginDescriptor + ":\r\n");
                object = linkedList.iterator();
                while (object.hasNext()) {
                    ((StringBuffer)object2).append("\t");
                    ((StringBuffer)object2).append(object.next());
                    ((StringBuffer)object2).append("\r\n");
                }
                logger.trace(((StringBuffer)object2).toString());
            }
            if (linkedList.isEmpty()) {
                return null;
            }
            return new PluginResourceLoader(linkedList.toArray(new URL[linkedList.size()]));
        }

        private PluginResourceLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            throw new ClassNotFoundException(string);
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            throw new ClassNotFoundException(string);
        }
    }

    private static final class ResourceFilter {
        private boolean isPublic;
        private Set entries = new HashSet();

        protected ResourceFilter(Library library) {
            Iterator iterator = library.getExports().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if ("*".equals(string)) {
                    this.isPublic = true;
                    this.entries.clear();
                    break;
                }
                if (!library.isCodeLibrary() && (string = string.replace('\\', '.').replace('/', '.')).startsWith(".")) {
                    string = string.substring(1);
                }
                this.entries.add(string);
            }
        }

        protected boolean isClassVisible(String string) {
            if (this.isPublic) {
                return true;
            }
            if (this.entries.isEmpty()) {
                return false;
            }
            if (this.entries.contains(string)) {
                return true;
            }
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return false;
            }
            return this.entries.contains(string.substring(0, n) + ".*");
        }

        protected boolean isResourceVisible(String string) {
            if (this.isPublic) {
                return true;
            }
            if (this.entries.isEmpty()) {
                return false;
            }
            if ((string = string.replace('\\', '.').replace('/', '.')).startsWith(".")) {
                string = string.substring(1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
            return this.isClassVisible(string);
        }
    }
}

