/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DIALOGBOX_H
#define DIALOGBOX_H

#include "global.h"

#include "Dice.h"
#include "Translator.h"
#include "Config.h"

#ifndef NOSOUND
#include "SoundPlayer.h"
#endif

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

#define DIALOG_NONE -1
#define DIALOG_YESNO 0
#define DIALOG_BLOCK 1
#define DIALOG_INFO 2
#define DIALOG_TOSS 3
#define DIALOG_CHOICE 4

#define DIALOG_ALPHA 234

#define DIALOG_W 240
#define DIALOG_H 170

#define DIALOG_FPS 14

#define DIALOG_TITLE_BAR_H 25

#define ICONS_X 25
#define ICONS_Y 34
#define ICONS_W 60
#define ICONS_H 60

#define CLOSE_BUTTON_X 62
#define CLOSE_BUTTON_Y 136
#define CLOSE_BUTTON_W 114
#define CLOSE_BUTTON_H 30

#define YES_BUTTON_X 60
#define YES_BUTTON_Y 135
#define YES_BUTTON_W 50
#define YES_BUTTON_H 31

#define NO_BUTTON_X 130
#define NO_BUTTON_Y 135
#define NO_BUTTON_W 50
#define NO_BUTTON_H 31

#define DICE_1_BUTTON_X 36
#define DICE_1_BUTTON_Y 40
#define DICE_2_BUTTON_X 96
#define DICE_2_BUTTON_Y 40
#define DICE_3_BUTTON_X 156
#define DICE_3_BUTTON_Y 40
#define DICES_BUTTON_W 47
#define DICES_BUTTON_H 47

#define DICES_DIFF 60

#define DICE_1_INDICATOR_X 51
#define DICE_2_INDICATOR_X 111
#define DICE_3_INDICATOR_X 171
#define DICES_INDICATOR_Y 93
#define INDICATOR_W 19
#define INDICATOR_H 24

#define DICES_INDICATOR_SPEED 7

#define PIECE_HEAD_INDICATOR_X 65
#define PIECE_TAIL_INDICATOR_X 158
#define PIECES_INDICATOR_Y 113

#define PIECE_HEAD_X 40
#define PIECE_HEAD_Y 36
#define PIECE_TAIL_X 134
#define PIECE_TAIL_Y 36
#define PIECES_W 70
#define PIECES_H 70

#define HEAD_BUTTON_X 46
#define HEAD_BUTTON_Y 133
#define HEAD_BUTTON_W 63
#define HEAD_BUTTON_H 28

#define TAIL_BUTTON_X 130
#define TAIL_BUTTON_Y 133
#define TAIL_BUTTON_W 55
#define TAIL_BUTTON_H 26

#define HEAD 1
#define TAIL 2

#define TOSS_CHOICE 0
#define TOSS_UP 1
#define TOSS_KICK_OR_RECEIVE 2

#define KICK_BUTTON_X 38
#define KICK_BUTTON_Y 132
#define KICK_BUTTON_W 57
#define KICK_BUTTON_H 28

#define RECEIVE_BUTTON_X 120
#define RECEIVE_BUTTON_Y 132
#define RECEIVE_BUTTON_W 86
#define RECEIVE_BUTTON_H 28

#define TOSS_BOTTOM_X 36
#define TOSS_BOTTOM_Y 108
#define TOSS_BOTTOM_W 170
#define TOSS_BOTTOM_H 51

#define REROLL_BUTTON_X 55
#define REROLL_BUTTON_Y 136
#define REROLL_BUTTON_W 126
#define REROLL_BUTTON_H 29

#define DEFENDER_X 26
#define DEFENDER_Y 119
#define DEFENDER_W 180
#define DEFENDER_H 18

#define NOT_AGREE_X 20
#define NOT_AGREE_Y 100
#define NOT_AGREE_W 70 
#define NOT_AGREE_H 34

#define MSG_X 90
#define MSG_Y 30
#define MSG_W 130
#define MSG_H 106
#define MSG_LINES 6
#define MSG_MAX_CHAR 15
#define MSG_INTERLIGNE 18
 
#define TITLE_Y 4
#define TITLE_MAX_CHAR 25 

//#define MSG_PER_LINE 8

const int LEFT_BUTTON=1;

#define OVER_BOX(a,b) (((a)>=x)&&((a)<(x+DIALOG_W))&&((b)>=y)&&((b)<(y+DIALOG_H)))
#define OVER_TITLE_BAR(a,b) (((a)>=x)&&((a)<(x+DIALOG_W))&&((b)>=y)&&((b)<(y+DIALOG_TITLE_BAR_H)))
#define OVER_CLOSE_BUTTON(a,b) (((a)>=CLOSE_BUTTON_X)&&((a)<(CLOSE_BUTTON_X+CLOSE_BUTTON_W))&&((b)>=CLOSE_BUTTON_Y)&&((b)<(CLOSE_BUTTON_Y+CLOSE_BUTTON_H)))
#define OVER_YES_BUTTON(a,b) (((a)>=YES_BUTTON_X)&&((a)<(YES_BUTTON_X+YES_BUTTON_W))&&((b)>=YES_BUTTON_Y)&&((b)<(YES_BUTTON_Y+YES_BUTTON_H)))
#define OVER_NO_BUTTON(a,b) (((a)>=NO_BUTTON_X)&&((a)<(NO_BUTTON_X+NO_BUTTON_W))&&((b)>=NO_BUTTON_Y)&&((b)<(NO_BUTTON_Y+NO_BUTTON_H)))
#define OVER_REROLL_BUTTON(a,b) (((a)>=REROLL_BUTTON_X)&&((a)<(REROLL_BUTTON_X+REROLL_BUTTON_W))&&((b)>=REROLL_BUTTON_Y)&&((b)<(REROLL_BUTTON_Y+REROLL_BUTTON_H)))
#define OVER_DICE_1_BUTTON(a,b) (((a)>=DICE_1_BUTTON_X)&&((a)<(DICE_1_BUTTON_X+DICES_BUTTON_W))&&((b)>=DICE_1_BUTTON_Y)&&((b)<(DICE_1_BUTTON_Y+DICES_BUTTON_H)))
#define OVER_DICE_2_BUTTON(a,b) (((a)>=DICE_2_BUTTON_X)&&((a)<(DICE_2_BUTTON_X+DICES_BUTTON_W))&&((b)>=DICE_2_BUTTON_Y)&&((b)<(DICE_2_BUTTON_Y+DICES_BUTTON_H)))
#define OVER_DICE_3_BUTTON(a,b) (((a)>=DICE_3_BUTTON_X)&&((a)<(DICE_3_BUTTON_X+DICES_BUTTON_W))&&((b)>=DICE_3_BUTTON_Y)&&((b)<(DICE_3_BUTTON_Y+DICES_BUTTON_H)))
#define OVER_HEAD_BUTTON(a,b) (((a)>=HEAD_BUTTON_X)&&((a)<(HEAD_BUTTON_X+HEAD_BUTTON_W))&&((b)>=HEAD_BUTTON_Y)&&((b)<(HEAD_BUTTON_Y+HEAD_BUTTON_H)))
#define OVER_TAIL_BUTTON(a,b)  (((a)>=TAIL_BUTTON_X)&&((a)<(TAIL_BUTTON_X+TAIL_BUTTON_W))&&((b)>=TAIL_BUTTON_Y)&&((b)<(TAIL_BUTTON_Y+TAIL_BUTTON_H)))
#define OVER_KICK_BUTTON(a,b) (((a)>=KICK_BUTTON_X)&&((a)<(KICK_BUTTON_X+KICK_BUTTON_W))&&((b)>=KICK_BUTTON_Y)&&((b)<(KICK_BUTTON_Y+KICK_BUTTON_H)))
#define OVER_RECEIVE_BUTTON(a,b)(((a)>=RECEIVE_BUTTON_X)&&((a)<(RECEIVE_BUTTON_X+RECEIVE_BUTTON_W))&&((b)>=RECEIVE_BUTTON_Y)&&((b)<(RECEIVE_BUTTON_Y+RECEIVE_BUTTON_H)))
#define OVER_NOT_AGREE(a,b)(((a)>=NOT_AGREE_X)&&((a)<(NOT_AGREE_X+NOT_AGREE_W))&&((b)>=NOT_AGREE_Y)&&((b)<(NOT_AGREE_Y+NOT_AGREE_H)))
#define OVER_HEAD_PIECE(a,b) (((a)>=PIECE_HEAD_X)&&((a)<(PIECE_HEAD_X+PIECES_W))&&((b)>=PIECE_HEAD_Y)&&((b)<(PIECE_HEAD_Y+PIECES_H)))
#define OVER_TAIL_PIECE(a,b)  (((a)>=PIECE_TAIL_X)&&((a)<(PIECE_TAIL_X+PIECES_W))&&((b)>=PIECE_TAIL_Y)&&((b)<(PIECE_TAIL_Y+PIECES_H)))

#define OVER_A_BUTTON(a,b) (OVER_YES_BUTTON(a,b))
#define OVER_B_BUTTON(a,b) (OVER_NO_BUTTON(a,b))

#define MASK_ALPHA 50

#define MSG_TEST -1
#define MSG_QUIT 0
#define MSG_PURSUE 1
#define MSG_TOO_MUCH_PLAYER_ON_LEFT_CORRIDOR 2
#define MSG_TOO_MUCH_PLAYER_ON_RIGHT_CORRIDOR 3
#define MSG_NOT_ENOUGH_PLAYER_ON_CENTER_LINE 4
#define MSG_TOO_MUCH_PLAYER_ON_PLAYGROUND 5
#define MSG_REROLL_QUESTION 6
#define MSG_INCOMPLETE_PASS_REROLL_QUESTION 7
#define MSG_FUMBLE_PASS_REROLL_QUESTION 8
#define MSG_INTERCEPTION_PASS_REROLL_QUESTION 9
#define MSG_INTERCEPTION_ATTEMPT_QUESTION 10
#define MSG_GO_TO_WEB 11
#define MSG_PLAYER_EJECTED 12
#define MSG_PLAYER_KO 13
#define MSG_PLAYER_TOUCHED 14
#define MSG_PLAYER_INJURED 15
#define MSG_PLAYER_DEAD 16
#define MSG_INTERCEPTION 17
#define MSG_INCOMPLETE_PASS 18
#define MSG_FUMBLE 19
#define MSG_PERFECT_PASS 20
#define MSG_READY_FOR_PLAYING_X_FIRST 21
#define MSG_TOUCHDOWN 22
#define MSG_THROW_IN 23
#define MSG_CHOOSE_INTERCEPTOR 24
#define MSG_RECEIVE_QUESTION 25
#define MSG_X_PLACEMENT_FIRST 26
#define MSG_X_CHOOSE_BALL_OWNER 27
#define MSG_X_PLACE_BALL 28
#define MSG_TIME_OUT 29
#define MSG_HALF_TIME 30
#define MSG_FULL_TIME 31
#define MSG_EXTRA_TIME 32
#define MSG_WINNER_X 33
#define MSG_X_KO_RECOVERY_OK 34
#define MSG_X_KO_RECOVERY_FAILED 35
#define MSG_REFEREE_RULES 36
#define MSG_TEAM_RULES 37
#define MSG_REFEREE_DESPISE 38
#define MSG_TURNOVER 39
#define MSG_AGGRESS_SUCCESS 40
#define MSG_AGGRESS_FAILED 41
#define MSG_MOVE_REROLL_QUESTION 42
#define MSG_MOVE_PLUS_REROLL_QUESTION 43
#define MSG_GATHER_REROLL_QUESTION 44
#define MSG_RECEIVE_REROLL_QUESTION 45
#define MSG_TRANSMISSION_REROLL_QUESTION 46
#define MSG_X_AFFECTED_BY_SUNSTROKE 47
#define MSG_RECEIVE_FREE_REROLL 48
#define MSG_GATHER_FREE_REROLL 49
#define MSG_TRANSMISSION_FREE_REROLL 50
#define MSG_INTERCEPTION_FREE_REROLL 51
#define MSG_MOVE_FREE_REROLL 52
#define MSG_INCOMPLETE_PASS_FREE_REROLL 53
#define MSG_FUMBLE_PASS_FREE_REROLL 54
#define MSG_KICKOFF_RIOT 55
#define MSG_KICKOFF_REFEREE 56
#define MSG_KICKOFF_REFEREE_X 57 
#define MSG_KICKOFF_DEFENSE 58
#define MSG_KICKOFF_SUPPORTERS_X 59
#define MSG_KICKOFF_CANNONBALL 60
#define MSG_KICKOFF_WEATHER 61
#define MSG_KICKOFF_SURPRISE 62
#define MSG_KICKOFF_TRAINING_X 63
#define MSG_KICKOFF_BLITZ 64
#define MSG_KICKOFF_ROCK_X 65
#define MSG_KICKOFF_INVASION_X 66
#define MSG_PLAYER_DOWN 67
#define MSG_PLAYER_GROUND 68
#define MSG_DRAW 69
#define MSG_MOVE_PLUS_FREE_REROLL 70
#define MSG_LANDING_REROLL_QUESTION 71
#define MSG_PLAYER_RESERVE 72

#define MSG_LEAP_REROLL_QUESTION MSG_MOVE_PLUS_REROLL_QUESTION

//////////////////////////////////////
// Ragnar Modif3 : comptences
#define MSG_SKILL_DUMP_OFF 73
#define MSG_SKILL_SIDE_STEP 74
#define MSG_SKILL_DAUNTLESS_SUCCESS 75
#define MSG_SKILL_DAUNTLESS_FAILURE 76
#define MSG_SKILL_KICK 77
#define MSG_SKILL_PILLING_ON 78
#define MSG_SKILL_MIGHTY_OR_PILLING_ON 79
#define MSG_SKILL_STAND_FIRM_PUSH 80
#define MSG_SKILL_STAND_FIRM_DODGE 81
//////////////////////////////////////
// Ragnar Modif4
#define MSG_PENALTY 82
#define MSG_QUESTION_PENALTY 83
//////////////////////////////////////
// Ragnar Modif5
#define MSG_APOTHECARY 84
#define MSG_APOTHECARY_SUCCESS 85
#define MSG_APOTHECARY_FAIL 86
//////////////////////////////////////
// Ragnar Modif6 : nouveaux messages
#define MSG_BONE_HEAD 87
#define MSG_REALLY_STUPID 88
#define MSG_GET_UP_TAKE_ROOT 89
#define MSG_TAKE_ROOT 90
#define MSG_ALWAYS_HUNGRY_ESCAPE 91
#define MSG_ALWAYS_HUNGRY_DEATH 92
//////////////////////////////////////

#define NOP 0 
#define YES 1
#define NO 2
#define CLOSE 3
#define FIRST_DICE 4
#define SECOND_DICE 5
#define THIRD_DICE 6
#define REROLL 7
#define HOME_KICK 8
#define VISITOR_KICK 9
#define NOT_AGREE 10
#define CHOICE_A 11
#define CHOICE_B 12

#define ICONS_REFEREE 0
#define ICONS_STOP 1
#define ICONS_WARNING 2
#define ICONS_SMILEY 3
#define ICONS_AFRAID 4
#define ICONS_QUESTION 5
#define ICONS_INFO 6
#define ICONS_KICKOFF 7
#define ICONS_RESERVE 8
#define ICONS_GROUND 9
#define ICONS_DOWN 10
#define ICONS_KO 11
#define ICONS_TOUCHED 12
#define ICONS_INJURED 13
#define ICONS_DEAD 14

class DialogBox{
 public:
  /**
   * Constructeur par defaut
   */
  DialogBox(SDL_Surface*);
  DialogBox(SDL_Surface*,const char*);
  ~DialogBox();

  int open_yesno(SDL_Surface*,int,int,const char*);
  int open_yesno_s(SDL_Surface*,int,int,const char*,const char* );
  
  int open_choice(SDL_Surface*,int,int,const char*);
  int open_choice_s(SDL_Surface*,int,int,const char*,const char*);
  
  int open_block(SDL_Surface*,int*,int,bool,const char*);
  int open_info(SDL_Surface*,int,int,bool,const char*);
  int open_info_s(SDL_Surface*,int,int,bool,const char*,const char*);
  int open_info_si(SDL_Surface*,int,int,bool,const char*,const char*,int);
  int open_info_i(SDL_Surface*,int,int,bool,const char*,int);
  int open_toss(SDL_Surface*,const char*,const char*); 
  void load_images(void);
  void free_images(void);
  bool is_visible(void) {return visible;}
  void change_language(const char*);

#ifndef NOSOUND
  void set_sound_player(SoundPlayer*);
#endif

 protected:

#ifndef NOSOUND
	SoundPlayer *sp;
#endif

  void wait_for_next_frame(void);
  void draw(void);
  int handle_event(void);
  void draw_multiline_string(SDL_Surface*,int,int,const char*);
  void draw_title(SDL_Surface*);
  void init_graphics(SDL_Surface*);
  SDL_Surface* load_image(const char*,int);
  SDL_Surface *screen, *old_screen, *dialog_box_surf, *dialog_img[DIALOG_CHOICE+1],*mask_img,*close_img,*yes_img,*no_img,*indicator_img,*block_dices_img,*reroll_img,*icons_img,*defender_img,*pieces_img,*toss_bottom_img,*kick_receive_img,*not_agree_img,*head_tail_img, *font_img, *a_img, *b_img;
  int type;
  int face_choice;
  int face_result;
  int toss_state;
  bool visible;
  int icons_id;
  bool can_complain;
  int x,y;
  int who_choose;
  int *dices;
  bool can_reroll;
  int dices_indicator_x_dest;
  int dices_indicator_x_current;
  int pieces_indicator_x;
  int pieces_toss_count;
  bool move_dialog,over_a,over_b,over_yes,over_no,over_over,over_close,over_reroll,over_kick,over_receive,over_head,over_tail,over_not_agree;
  bool update;
  SDL_Rect cliprect;
  char *msg;
  char *title;
  char *team_name[2];
  Translator *translator;
  Dice *d2;
};
#endif












