/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import java.lang.invoke.SwitchPoint;
import java.util.List;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.jruby.runtime.opto.Invalidator;

public class FailoverSwitchPointInvalidator
implements Invalidator {
    private static final SwitchPoint DUMMY = new SwitchPoint();
    private final AtomicStampedReference<SwitchPoint> switchPoint = new AtomicStampedReference<SwitchPoint>(DUMMY, 0);
    private final int maxFailures;

    public FailoverSwitchPointInvalidator(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    @Override
    public void invalidate() {
        SwitchPoint switchPoint = this.switchPoint.getReference();
        if (switchPoint == DUMMY) {
            return;
        }
        int failures = this.switchPoint.getStamp();
        SwitchPoint newSwitch = DUMMY;
        if (failures < this.maxFailures) {
            newSwitch = new SwitchPoint();
        }
        this.switchPoint.compareAndSet(switchPoint, newSwitch, failures, failures + 1);
        SwitchPoint.invalidateAll(new SwitchPoint[]{switchPoint});
    }

    @Override
    public void invalidateAll(List<Invalidator> invalidators) {
        SwitchPoint[] switchPoints = new SwitchPoint[invalidators.size()];
        for (int i2 = 0; i2 < invalidators.size(); ++i2) {
            Invalidator invalidator = invalidators.get(i2);
            assert (invalidator instanceof FailoverSwitchPointInvalidator);
            switchPoints[i2] = ((FailoverSwitchPointInvalidator)invalidator).replaceSwitchPoint();
        }
        SwitchPoint.invalidateAll(switchPoints);
    }

    @Override
    public synchronized Object getData() {
        SwitchPoint switchPoint;
        block1: {
            int failures;
            SwitchPoint newSwitch;
            do {
                switchPoint = this.switchPoint.getReference();
                failures = this.switchPoint.getStamp();
                if (switchPoint != DUMMY || failures > this.maxFailures) break block1;
            } while (!this.switchPoint.compareAndSet(DUMMY, newSwitch = new SwitchPoint(), failures, failures));
            return newSwitch;
        }
        return switchPoint;
    }

    public synchronized SwitchPoint replaceSwitchPoint() {
        int failures;
        SwitchPoint newSwitch;
        SwitchPoint switchPoint;
        do {
            switchPoint = this.switchPoint.getReference();
            failures = this.switchPoint.getStamp();
            if (switchPoint != DUMMY && failures <= this.maxFailures) continue;
            return DUMMY;
        } while (!this.switchPoint.compareAndSet(switchPoint, newSwitch = new SwitchPoint(), failures, failures + 1));
        return newSwitch;
    }

    static {
        SwitchPoint.invalidateAll(new SwitchPoint[]{DUMMY});
    }
}

