/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/bmpbndl.h>
        #include <wx/bitmap.h>
        #include <wx/icon.h>
        #include <wx/image.h>
        #include <wx/gdicmn.h>
        #include <wx/bmpbndl.h>
        #include <wx/iconbndl.h>
        #include <wx/window.h>


PyDoc_STRVAR(doc_wxBitmapBundle_Clear, "Clear() -> None\n"
"\n"
"Clear the existing bundle contents.");

extern "C" {static PyObject *meth_wxBitmapBundle_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxBitmapBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmapBundle, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_IsOk, "IsOk() -> bool\n"
"\n"
"Check if bitmap bundle is non-empty.");

extern "C" {static PyObject *meth_wxBitmapBundle_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmapBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmapBundle, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetDefaultSize, "GetDefaultSize() -> Size\n"
"\n"
"Get the size of the bitmap represented by this bundle in default\n"
"resolution or, equivalently, at 100% scaling.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetDefaultSize(PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetDefaultSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmapBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxBitmapBundle, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetDefaultSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetDefaultSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetPreferredBitmapSizeAtScale, "GetPreferredBitmapSizeAtScale(scale) -> Size\n"
"\n"
"Get the size that would be best to use for this bundle at the given\n"
"DPI scaling factor.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetPreferredBitmapSizeAtScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetPreferredBitmapSizeAtScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double scale;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_scale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_wxBitmapBundle, &sipCpp, &scale))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetPreferredBitmapSizeAtScale(scale));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetPreferredBitmapSizeAtScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetPreferredBitmapSizeFor, "GetPreferredBitmapSizeFor(window) -> Size\n"
"\n"
"Get the size that would be best to use for this bundle at the DPI\n"
"scaling factor used by the given window.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetPreferredBitmapSizeFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetPreferredBitmapSizeFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxWindow* window;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxBitmapBundle, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetPreferredBitmapSizeFor(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetPreferredBitmapSizeFor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetPreferredLogicalSizeFor, "GetPreferredLogicalSizeFor(window) -> Size\n"
"\n"
"Get the size that would be best to use for this bundle at the DPI\n"
"scaling factor used by the given window in logical size.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetPreferredLogicalSizeFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetPreferredLogicalSizeFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxWindow* window;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxBitmapBundle, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetPreferredLogicalSizeFor(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetPreferredLogicalSizeFor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetBitmap, "GetBitmap(size) -> Bitmap\n"
"\n"
"Get bitmap of the specified size, creating a new bitmap from the\n"
"closest available size by rescaling it if necessary.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSize* size;
        int sizeState = 0;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxBitmapBundle, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmap(sipCpp->GetBitmap(*size));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size), sipType_wxSize, sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetBitmapFor, "GetBitmapFor(window) -> Bitmap\n"
"\n"
"Get bitmap of the size appropriate for the DPI scaling used by the\n"
"given window.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetBitmapFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetBitmapFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxWindow* window;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxBitmapBundle, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmap(sipCpp->GetBitmapFor(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetBitmapFor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetIcon, "GetIcon(size) -> Icon\n"
"\n"
"Get icon of the specified size.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxSize* size;
        int sizeState = 0;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxBitmapBundle, &sipCpp, sipType_wxSize, &size, &sizeState))
        {
            ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxIcon(sipCpp->GetIcon(*size));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(size), sipType_wxSize, sizeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxIcon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_GetIconFor, "GetIconFor(window) -> Icon\n"
"\n"
"Get icon of the size appropriate for the DPI scaling used by the given\n"
"window.");

extern "C" {static PyObject *meth_wxBitmapBundle_GetIconFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_GetIconFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxWindow* window;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxBitmapBundle, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxIcon(sipCpp->GetIconFor(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxIcon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_GetIconFor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_IsSameAs, "IsSameAs(other) -> bool\n"
"\n"
"Check if the two bundles refer to the same object.");

extern "C" {static PyObject *meth_wxBitmapBundle_IsSameAs(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_IsSameAs(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmapBundle* other;
        int otherState = 0;
        const ::wxBitmapBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxBitmapBundle, &sipCpp, sipType_wxBitmapBundle, &other, &otherState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSameAs(*other);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxBitmapBundle *>(other), sipType_wxBitmapBundle, otherState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_IsSameAs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromBitmaps, "FromBitmaps(bitmaps) -> BitmapBundle\n"
"FromBitmaps(bitmap1, bitmap2) -> BitmapBundle\n"
"\n"
"Create a bundle from the given collection of bitmaps.\n"
"");

extern "C" {static PyObject *meth_wxBitmapBundle_FromBitmaps(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromBitmaps(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const wxVector< ::wxBitmap>* bitmaps;
        int bitmapsState = 0;

        static const char *sipKwdList[] = {
            sipName_bitmaps,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxVector_0100wxBitmap, &bitmaps, &bitmapsState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromBitmaps(*bitmaps));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<wxVector< ::wxBitmap> *>(bitmaps), sipType_wxVector_0100wxBitmap, bitmapsState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    {
        const ::wxBitmap* bitmap1;
        const ::wxBitmap* bitmap2;

        static const char *sipKwdList[] = {
            sipName_bitmap1,
            sipName_bitmap2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9J9", sipType_wxBitmap, &bitmap1, sipType_wxBitmap, &bitmap2))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromBitmaps(*bitmap1, *bitmap2));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromBitmaps, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromBitmap, "FromBitmap(bitmap) -> BitmapBundle\n"
"\n"
"Create a bundle from a single bitmap.");

extern "C" {static PyObject *meth_wxBitmapBundle_FromBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromBitmap(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmap* bitmap;

        static const char *sipKwdList[] = {
            sipName_bitmap,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9", sipType_wxBitmap, &bitmap))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromBitmap(*bitmap));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromIconBundle, "FromIconBundle(iconBundle) -> BitmapBundle\n"
"\n"
"Create a bundle from an icon bundle.");

extern "C" {static PyObject *meth_wxBitmapBundle_FromIconBundle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromIconBundle(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIconBundle* iconBundle;

        static const char *sipKwdList[] = {
            sipName_iconBundle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9", sipType_wxIconBundle, &iconBundle))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromIconBundle(*iconBundle));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromIconBundle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromImage, "FromImage(image) -> BitmapBundle\n"
"\n"
"Create a bundle from a single image.");

extern "C" {static PyObject *meth_wxBitmapBundle_FromImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromImage(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxImage* image;

        static const char *sipKwdList[] = {
            sipName_image,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9", sipType_wxImage, &image))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromImage(*image));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromImpl, "FromImpl(impl) -> BitmapBundle\n"
"\n"
"Create a bundle from a custom bitmap bundle implementation.");

extern "C" {static PyObject *meth_wxBitmapBundle_FromImpl(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromImpl(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxBitmapBundleImpl* impl;

        static const char *sipKwdList[] = {
            sipName_impl,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J:", sipType_wxBitmapBundleImpl, &impl))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromImpl(impl));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromImpl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromResources, "FromResources(name) -> BitmapBundle\n"
"\n"
"Create a bundle from the bitmaps in the application resources.");

extern "C" {static PyObject *meth_wxBitmapBundle_FromResources(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromResources(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &name, &nameState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromResources(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromResources, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromFiles, "FromFiles(path, filename, extension=\"png\") -> BitmapBundle\n"
"FromFiles(fullpathname) -> BitmapBundle\n"
"\n"
"Create a bundle from bitmaps stored as files.\n"
"");

extern "C" {static PyObject *meth_wxBitmapBundle_FromFiles(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromFiles(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* path;
        int pathState = 0;
        const ::wxString* filename;
        int filenameState = 0;
        const ::wxString& extensiondef = "png";
        const ::wxString* extension = &extensiondef;
        int extensionState = 0;

        static const char *sipKwdList[] = {
            sipName_path,
            sipName_filename,
            sipName_extension,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1J1|J1", sipType_wxString, &path, &pathState, sipType_wxString, &filename, &filenameState, sipType_wxString, &extension, &extensionState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromFiles(*path, *filename, *extension));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(path), sipType_wxString, pathState);
            sipReleaseType(const_cast< ::wxString *>(filename), sipType_wxString, filenameState);
            sipReleaseType(const_cast< ::wxString *>(extension), sipType_wxString, extensionState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    {
        const ::wxString* fullpathname;
        int fullpathnameState = 0;

        static const char *sipKwdList[] = {
            sipName_fullpathname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &fullpathname, &fullpathnameState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromFiles(*fullpathname));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(fullpathname), sipType_wxString, fullpathnameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromFiles, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromSVG, "FromSVG(data, sizeDef) -> BitmapBundle\n"
"FromSVG(data, len, sizeDef) -> BitmapBundle\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.\n"
"");

extern "C" {static PyObject *meth_wxBitmapBundle_FromSVG(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromSVG(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* data;
        const ::wxSize* sizeDef;
        int sizeDefState = 0;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_sizeDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "sJ1", &data, sipType_wxSize, &sizeDef, &sizeDefState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromSVG(data, *sizeDef));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sizeDef), sipType_wxSize, sizeDefState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    {
        ::wxByte data;
        size_t len;
        const ::wxSize* sizeDef;
        int sizeDefState = 0;

        static const char *sipKwdList[] = {
            sipName_data,
            sipName_len,
            sipName_sizeDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "M=J1", &data, &len, sipType_wxSize, &sizeDef, &sizeDefState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromSVG(&data, len, *sizeDef));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxSize *>(sizeDef), sipType_wxSize, sizeDefState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromSVG, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromSVGFile, "FromSVGFile(path, sizeDef) -> BitmapBundle\n"
"\n"
"Create a bundle from the SVG image loaded from the given file.");

extern "C" {static PyObject *meth_wxBitmapBundle_FromSVGFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromSVGFile(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* path;
        int pathState = 0;
        const ::wxSize* sizeDef;
        int sizeDefState = 0;

        static const char *sipKwdList[] = {
            sipName_path,
            sipName_sizeDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1J1", sipType_wxString, &path, &pathState, sipType_wxSize, &sizeDef, &sizeDefState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromSVGFile(*path, *sizeDef));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(path), sipType_wxString, pathState);
            sipReleaseType(const_cast< ::wxSize *>(sizeDef), sipType_wxSize, sizeDefState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromSVGFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxBitmapBundle_FromSVGResource, "FromSVGResource(name, sizeDef) -> BitmapBundle\n"
"\n"
"Create a bundle from the SVG image loaded from an application\n"
"resource.");

extern "C" {static PyObject *meth_wxBitmapBundle_FromSVGResource(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxBitmapBundle_FromSVGResource(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        const ::wxSize* sizeDef;
        int sizeDefState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_sizeDef,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1J1", sipType_wxString, &name, &nameState, sipType_wxSize, &sizeDef, &sizeDefState))
        {
            ::wxBitmapBundle*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmapBundle(::wxBitmapBundle::FromSVGResource(*name, *sizeDef));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxSize *>(sizeDef), sipType_wxSize, sizeDefState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmapBundle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_BitmapBundle, sipName_FromSVGResource, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxBitmapBundle(void *, int);}
static void release_wxBitmapBundle(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxBitmapBundle *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxBitmapBundle(Py_ssize_t);}
static void *array_wxBitmapBundle(Py_ssize_t sipNrElem)
{
    return new ::wxBitmapBundle[sipNrElem];
}


extern "C" {static void array_delete_wxBitmapBundle(void *);}
static void array_delete_wxBitmapBundle(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxBitmapBundle *>(sipCpp);
}


extern "C" {static void assign_wxBitmapBundle(void *, Py_ssize_t, void *);}
static void assign_wxBitmapBundle(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxBitmapBundle *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxBitmapBundle *>(sipSrc);
}


extern "C" {static void *copy_wxBitmapBundle(const void *, Py_ssize_t);}
static void *copy_wxBitmapBundle(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxBitmapBundle(reinterpret_cast<const ::wxBitmapBundle *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxBitmapBundle(sipSimpleWrapper *);}
static void dealloc_wxBitmapBundle(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxBitmapBundle(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxBitmapBundle(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxBitmapBundle(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxBitmapBundle *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBitmapBundle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmap* bitmap;

        static const char *sipKwdList[] = {
            sipName_bitmap,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &bitmap))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBitmapBundle(*bitmap);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxIcon* icon;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxIcon, &icon))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBitmapBundle(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxImage* image;

        static const char *sipKwdList[] = {
            sipName_image,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxImage, &image))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBitmapBundle(*image);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmapBundle* other;
        int otherState = 0;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxBitmapBundle, &other, &otherState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxBitmapBundle(*other);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxBitmapBundle *>(other), sipType_wxBitmapBundle, otherState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_wxBitmapBundle(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxBitmapBundle(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::wxBitmapBundle **sipCppPtr = reinterpret_cast< ::wxBitmapBundle **>(sipCppPtrV);
        // Check for type compatibility
        if (!sipIsErr) {
            if (sipCanConvertToType(sipPy, sipType_wxBitmap, SIP_NO_CONVERTORS))
                return 1;
            if (sipCanConvertToType(sipPy, sipType_wxIcon, SIP_NO_CONVERTORS))
                return 1;
            if (sipCanConvertToType(sipPy, sipType_wxImage, SIP_NO_CONVERTORS))
                return 1;
            if (sipCanConvertToType(sipPy, sipType_wxBitmapBundle, SIP_NO_CONVERTORS))
                return 1;
            return 0;
        }
        
        // Otherwise, a conversion is needed
        int state = 0;
        // TODO: A macro for these nearly identical statements would be a good idea...
        if (sipCanConvertToType(sipPy, sipType_wxBitmap, SIP_NO_CONVERTORS)) {
            wxBitmap* obj = reinterpret_cast<wxBitmap*>(
                sipConvertToType(sipPy, sipType_wxBitmap, sipTransferObj, SIP_NO_CONVERTORS, &state, sipIsErr));
            *sipCppPtr = new wxBitmapBundle(*obj);
            sipReleaseType(obj, sipType_wxBitmap, state);
            return sipGetState(sipTransferObj);
        }
        if (sipCanConvertToType(sipPy, sipType_wxIcon, SIP_NO_CONVERTORS)) {
            wxIcon* obj = reinterpret_cast<wxIcon*>(
                sipConvertToType(sipPy, sipType_wxIcon, sipTransferObj, SIP_NO_CONVERTORS, &state, sipIsErr));
            *sipCppPtr = new wxBitmapBundle(*obj);
            sipReleaseType(obj, sipType_wxIcon, state);
            return sipGetState(sipTransferObj);
        }
        if (sipCanConvertToType(sipPy, sipType_wxImage, SIP_NO_CONVERTORS)) {
            wxImage* obj = reinterpret_cast<wxImage*>(
                sipConvertToType(sipPy, sipType_wxImage, sipTransferObj, SIP_NO_CONVERTORS, &state, sipIsErr));
            *sipCppPtr = new wxBitmapBundle(*obj);
            sipReleaseType(obj, sipType_wxImage, state);
            return sipGetState(sipTransferObj);
        }
        
        // The final option is that it is already a wxBitmapBundle, so just fetch the pointer and return
        *sipCppPtr = reinterpret_cast<wxBitmapBundle*>(
            sipConvertToType(sipPy, sipType_wxBitmapBundle, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));
        return 0; // not a new instance
}


static PyMethodDef methods_wxBitmapBundle[] = {
    {sipName_Clear, meth_wxBitmapBundle_Clear, METH_VARARGS, doc_wxBitmapBundle_Clear},
    {sipName_FromBitmap, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromBitmap},
    {sipName_FromBitmaps, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromBitmaps), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromBitmaps},
    {sipName_FromFiles, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromFiles), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromFiles},
    {sipName_FromIconBundle, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromIconBundle), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromIconBundle},
    {sipName_FromImage, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromImage), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromImage},
    {sipName_FromImpl, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromImpl), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromImpl},
    {sipName_FromResources, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromResources), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromResources},
    {sipName_FromSVG, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromSVG), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromSVG},
    {sipName_FromSVGFile, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromSVGFile), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromSVGFile},
    {sipName_FromSVGResource, SIP_MLMETH_CAST(meth_wxBitmapBundle_FromSVGResource), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_FromSVGResource},
    {sipName_GetBitmap, SIP_MLMETH_CAST(meth_wxBitmapBundle_GetBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_GetBitmap},
    {sipName_GetBitmapFor, SIP_MLMETH_CAST(meth_wxBitmapBundle_GetBitmapFor), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_GetBitmapFor},
    {sipName_GetDefaultSize, meth_wxBitmapBundle_GetDefaultSize, METH_VARARGS, doc_wxBitmapBundle_GetDefaultSize},
    {sipName_GetIcon, SIP_MLMETH_CAST(meth_wxBitmapBundle_GetIcon), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_GetIcon},
    {sipName_GetIconFor, SIP_MLMETH_CAST(meth_wxBitmapBundle_GetIconFor), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_GetIconFor},
    {sipName_GetPreferredBitmapSizeAtScale, SIP_MLMETH_CAST(meth_wxBitmapBundle_GetPreferredBitmapSizeAtScale), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_GetPreferredBitmapSizeAtScale},
    {sipName_GetPreferredBitmapSizeFor, SIP_MLMETH_CAST(meth_wxBitmapBundle_GetPreferredBitmapSizeFor), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_GetPreferredBitmapSizeFor},
    {sipName_GetPreferredLogicalSizeFor, SIP_MLMETH_CAST(meth_wxBitmapBundle_GetPreferredLogicalSizeFor), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_GetPreferredLogicalSizeFor},
    {sipName_IsOk, meth_wxBitmapBundle_IsOk, METH_VARARGS, doc_wxBitmapBundle_IsOk},
    {sipName_IsSameAs, SIP_MLMETH_CAST(meth_wxBitmapBundle_IsSameAs), METH_VARARGS|METH_KEYWORDS, doc_wxBitmapBundle_IsSameAs}
};

sipVariableDef variables_wxBitmapBundle[] = {
    {PropertyVariable, sipName_DefaultSize, &methods_wxBitmapBundle[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxBitmapBundle, "BitmapBundle() -> None\n"
"BitmapBundle(bitmap) -> None\n"
"BitmapBundle(icon) -> None\n"
"BitmapBundle(image) -> None\n"
"BitmapBundle(other) -> None\n"
"\n"
"Contains representations of the same bitmap in different resolutions.");


sipClassTypeDef sipTypeDef__core_wxBitmapBundle = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxBitmapBundle,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_BitmapBundle,
        {0, 0, 1},
        21, methods_wxBitmapBundle,
        0, SIP_NULLPTR,
        1, variables_wxBitmapBundle,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxBitmapBundle,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxBitmapBundle,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxBitmapBundle,
    assign_wxBitmapBundle,
    array_wxBitmapBundle,
    copy_wxBitmapBundle,
    release_wxBitmapBundle,
    SIP_NULLPTR,
    convertTo_wxBitmapBundle,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxBitmapBundle,
    sizeof (::wxBitmapBundle),
};
