﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codecommit/model/BatchDisassociateApprovalRuleTemplateFromRepositoriesError.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CodeCommit {
namespace Model {

BatchDisassociateApprovalRuleTemplateFromRepositoriesError::BatchDisassociateApprovalRuleTemplateFromRepositoriesError(JsonView jsonValue) {
  *this = jsonValue;
}

BatchDisassociateApprovalRuleTemplateFromRepositoriesError& BatchDisassociateApprovalRuleTemplateFromRepositoriesError::operator=(
    JsonView jsonValue) {
  if (jsonValue.ValueExists("repositoryName")) {
    m_repositoryName = jsonValue.GetString("repositoryName");
    m_repositoryNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("errorCode")) {
    m_errorCode = jsonValue.GetString("errorCode");
    m_errorCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("errorMessage")) {
    m_errorMessage = jsonValue.GetString("errorMessage");
    m_errorMessageHasBeenSet = true;
  }
  return *this;
}

JsonValue BatchDisassociateApprovalRuleTemplateFromRepositoriesError::Jsonize() const {
  JsonValue payload;

  if (m_repositoryNameHasBeenSet) {
    payload.WithString("repositoryName", m_repositoryName);
  }

  if (m_errorCodeHasBeenSet) {
    payload.WithString("errorCode", m_errorCode);
  }

  if (m_errorMessageHasBeenSet) {
    payload.WithString("errorMessage", m_errorMessage);
  }

  return payload;
}

}  // namespace Model
}  // namespace CodeCommit
}  // namespace Aws
