// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/confidentialcomputing/v1/service.proto

#include "google/cloud/confidentialcomputing/v1/internal/confidential_computing_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace confidentialcomputing_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConfidentialComputingTracingStub::ConfidentialComputingTracingStub(
    std::shared_ptr<ConfidentialComputingStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::confidentialcomputing::v1::Challenge>
ConfidentialComputingTracingStub::CreateChallenge(
    grpc::ClientContext& context,
    google::cloud::confidentialcomputing::v1::CreateChallengeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.confidentialcomputing.v1.ConfidentialComputing",
      "CreateChallenge");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateChallenge(context, request));
}

StatusOr<google::cloud::confidentialcomputing::v1::VerifyAttestationResponse>
ConfidentialComputingTracingStub::VerifyAttestation(
    grpc::ClientContext& context,
    google::cloud::confidentialcomputing::v1::VerifyAttestationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.confidentialcomputing.v1.ConfidentialComputing",
      "VerifyAttestation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->VerifyAttestation(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ConfidentialComputingStub> MakeConfidentialComputingTracingStub(
    std::shared_ptr<ConfidentialComputingStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ConfidentialComputingTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace confidentialcomputing_v1_internal
}  // namespace cloud
}  // namespace google
