// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/metadata.proto

#include "google/cloud/dataplex/v1/metadata_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetadataServiceClient::MetadataServiceClient(
    std::shared_ptr<MetadataServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
MetadataServiceClient::~MetadataServiceClient() = default;

StatusOr<google::cloud::dataplex::v1::Entity>
MetadataServiceClient::CreateEntity(
    std::string const& parent,
    google::cloud::dataplex::v1::Entity const& entity, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreateEntityRequest request;
  request.set_parent(parent);
  *request.mutable_entity() = entity;
  return connection_->CreateEntity(request);
}

StatusOr<google::cloud::dataplex::v1::Entity>
MetadataServiceClient::CreateEntity(
    google::cloud::dataplex::v1::CreateEntityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEntity(request);
}

StatusOr<google::cloud::dataplex::v1::Entity>
MetadataServiceClient::UpdateEntity(
    google::cloud::dataplex::v1::UpdateEntityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEntity(request);
}

Status MetadataServiceClient::DeleteEntity(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeleteEntityRequest request;
  request.set_name(name);
  return connection_->DeleteEntity(request);
}

Status MetadataServiceClient::DeleteEntity(
    google::cloud::dataplex::v1::DeleteEntityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEntity(request);
}

StatusOr<google::cloud::dataplex::v1::Entity> MetadataServiceClient::GetEntity(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetEntityRequest request;
  request.set_name(name);
  return connection_->GetEntity(request);
}

StatusOr<google::cloud::dataplex::v1::Entity> MetadataServiceClient::GetEntity(
    google::cloud::dataplex::v1::GetEntityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEntity(request);
}

StreamRange<google::cloud::dataplex::v1::Entity>
MetadataServiceClient::ListEntities(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListEntitiesRequest request;
  request.set_parent(parent);
  return connection_->ListEntities(request);
}

StreamRange<google::cloud::dataplex::v1::Entity>
MetadataServiceClient::ListEntities(
    google::cloud::dataplex::v1::ListEntitiesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEntities(std::move(request));
}

StatusOr<google::cloud::dataplex::v1::Partition>
MetadataServiceClient::CreatePartition(
    std::string const& parent,
    google::cloud::dataplex::v1::Partition const& partition, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::CreatePartitionRequest request;
  request.set_parent(parent);
  *request.mutable_partition() = partition;
  return connection_->CreatePartition(request);
}

StatusOr<google::cloud::dataplex::v1::Partition>
MetadataServiceClient::CreatePartition(
    google::cloud::dataplex::v1::CreatePartitionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePartition(request);
}

Status MetadataServiceClient::DeletePartition(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::DeletePartitionRequest request;
  request.set_name(name);
  return connection_->DeletePartition(request);
}

Status MetadataServiceClient::DeletePartition(
    google::cloud::dataplex::v1::DeletePartitionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePartition(request);
}

StatusOr<google::cloud::dataplex::v1::Partition>
MetadataServiceClient::GetPartition(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::GetPartitionRequest request;
  request.set_name(name);
  return connection_->GetPartition(request);
}

StatusOr<google::cloud::dataplex::v1::Partition>
MetadataServiceClient::GetPartition(
    google::cloud::dataplex::v1::GetPartitionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPartition(request);
}

StreamRange<google::cloud::dataplex::v1::Partition>
MetadataServiceClient::ListPartitions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataplex::v1::ListPartitionsRequest request;
  request.set_parent(parent);
  return connection_->ListPartitions(request);
}

StreamRange<google::cloud::dataplex::v1::Partition>
MetadataServiceClient::ListPartitions(
    google::cloud::dataplex::v1::ListPartitionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPartitions(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
