// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto

#include "google/cloud/rapidmigrationassessment/v1/internal/rapid_migration_assessment_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace rapidmigrationassessment_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RapidMigrationAssessmentTracingConnection::
    RapidMigrationAssessmentTracingConnection(
        std::shared_ptr<
            rapidmigrationassessment_v1::RapidMigrationAssessmentConnection>
            child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentTracingConnection::CreateCollector(
    google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "CreateCollector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCollector(request));
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
RapidMigrationAssessmentTracingConnection::CreateAnnotation(
    google::cloud::rapidmigrationassessment::v1::CreateAnnotationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "CreateAnnotation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateAnnotation(request));
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>
RapidMigrationAssessmentTracingConnection::GetAnnotation(
    google::cloud::rapidmigrationassessment::v1::GetAnnotationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "GetAnnotation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAnnotation(request));
}

StreamRange<google::cloud::rapidmigrationassessment::v1::Collector>
RapidMigrationAssessmentTracingConnection::ListCollectors(
    google::cloud::rapidmigrationassessment::v1::ListCollectorsRequest
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "ListCollectors");
  internal::OTelScope scope(span);
  auto sr = child_->ListCollectors(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::rapidmigrationassessment::v1::Collector>(std::move(span),
                                                              std::move(sr));
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>
RapidMigrationAssessmentTracingConnection::GetCollector(
    google::cloud::rapidmigrationassessment::v1::GetCollectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "GetCollector");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCollector(request));
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentTracingConnection::UpdateCollector(
    google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "UpdateCollector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCollector(request));
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentTracingConnection::DeleteCollector(
    google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "DeleteCollector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCollector(request));
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentTracingConnection::ResumeCollector(
    google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "ResumeCollector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ResumeCollector(request));
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentTracingConnection::RegisterCollector(
    google::cloud::rapidmigrationassessment::v1::RegisterCollectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "RegisterCollector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RegisterCollector(request));
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentTracingConnection::PauseCollector(
    google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "rapidmigrationassessment_v1::RapidMigrationAssessmentConnection::"
      "PauseCollector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PauseCollector(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<rapidmigrationassessment_v1::RapidMigrationAssessmentConnection>
MakeRapidMigrationAssessmentTracingConnection(
    std::shared_ptr<
        rapidmigrationassessment_v1::RapidMigrationAssessmentConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RapidMigrationAssessmentTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace rapidmigrationassessment_v1_internal
}  // namespace cloud
}  // namespace google
