// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_values.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_TAG_VALUES_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_TAG_VALUES_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/resourcemanager/v3/tag_values.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TagValuesConnectionIdempotencyPolicy {
 public:
  virtual ~TagValuesConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<TagValuesConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency ListTagValues(
      google::cloud::resourcemanager::v3::ListTagValuesRequest request);

  virtual google::cloud::Idempotency GetTagValue(
      google::cloud::resourcemanager::v3::GetTagValueRequest const& request);

  virtual google::cloud::Idempotency GetNamespacedTagValue(
      google::cloud::resourcemanager::v3::GetNamespacedTagValueRequest const&
          request);

  virtual google::cloud::Idempotency CreateTagValue(
      google::cloud::resourcemanager::v3::CreateTagValueRequest const& request);

  virtual google::cloud::Idempotency UpdateTagValue(
      google::cloud::resourcemanager::v3::UpdateTagValueRequest const& request);

  virtual google::cloud::Idempotency DeleteTagValue(
      google::cloud::resourcemanager::v3::DeleteTagValueRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);
};

std::unique_ptr<TagValuesConnectionIdempotencyPolicy>
MakeDefaultTagValuesConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_TAG_VALUES_CONNECTION_IDEMPOTENCY_POLICY_H
