// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workstations/v1/workstations.proto

#include "google/cloud/workstations/v1/internal/workstations_connection_impl.h"
#include "google/cloud/workstations/v1/internal/workstations_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace workstations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<workstations_v1::WorkstationsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<workstations_v1::WorkstationsRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<workstations_v1::WorkstationsBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<workstations_v1::WorkstationsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<workstations_v1::WorkstationsConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<workstations_v1::WorkstationsPollingPolicyOption>()
      ->clone();
}

}  // namespace

WorkstationsConnectionImpl::WorkstationsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<workstations_v1_internal::WorkstationsStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      WorkstationsConnection::options())) {}

StatusOr<google::cloud::workstations::v1::WorkstationCluster>
WorkstationsConnectionImpl::GetWorkstationCluster(
    google::cloud::workstations::v1::GetWorkstationClusterRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetWorkstationCluster(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::workstations::v1::GetWorkstationClusterRequest const&
              request) {
        return stub_->GetWorkstationCluster(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::workstations::v1::WorkstationCluster>
WorkstationsConnectionImpl::ListWorkstationClusters(
    google::cloud::workstations::v1::ListWorkstationClustersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListWorkstationClusters(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workstations::v1::WorkstationCluster>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<workstations_v1::WorkstationsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::workstations::v1::ListWorkstationClustersRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::workstations::v1::
                       ListWorkstationClustersRequest const& request) {
              return stub->ListWorkstationClusters(context, request);
            },
            r, function_name);
      },
      [](google::cloud::workstations::v1::ListWorkstationClustersResponse r) {
        std::vector<google::cloud::workstations::v1::WorkstationCluster> result(
            r.workstation_clusters().size());
        auto& messages = *r.mutable_workstation_clusters();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsConnectionImpl::CreateWorkstationCluster(
    google::cloud::workstations::v1::CreateWorkstationClusterRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::WorkstationCluster>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::workstations::v1::
                         CreateWorkstationClusterRequest const& request) {
        return stub->AsyncCreateWorkstationCluster(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::WorkstationCluster>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateWorkstationCluster(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsConnectionImpl::UpdateWorkstationCluster(
    google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::WorkstationCluster>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::workstations::v1::
                         UpdateWorkstationClusterRequest const& request) {
        return stub->AsyncUpdateWorkstationCluster(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::WorkstationCluster>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateWorkstationCluster(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
WorkstationsConnectionImpl::DeleteWorkstationCluster(
    google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::WorkstationCluster>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::workstations::v1::
                         DeleteWorkstationClusterRequest const& request) {
        return stub->AsyncDeleteWorkstationCluster(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::WorkstationCluster>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteWorkstationCluster(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsConnectionImpl::GetWorkstationConfig(
    google::cloud::workstations::v1::GetWorkstationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetWorkstationConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::GetWorkstationConfigRequest const&
                 request) {
        return stub_->GetWorkstationConfig(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsConnectionImpl::ListWorkstationConfigs(
    google::cloud::workstations::v1::ListWorkstationConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListWorkstationConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workstations::v1::WorkstationConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<workstations_v1::WorkstationsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::workstations::v1::ListWorkstationConfigsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::workstations::v1::
                       ListWorkstationConfigsRequest const& request) {
              return stub->ListWorkstationConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::workstations::v1::ListWorkstationConfigsResponse r) {
        std::vector<google::cloud::workstations::v1::WorkstationConfig> result(
            r.workstation_configs().size());
        auto& messages = *r.mutable_workstation_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::workstations::v1::WorkstationConfig>
WorkstationsConnectionImpl::ListUsableWorkstationConfigs(
    google::cloud::workstations::v1::ListUsableWorkstationConfigsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListUsableWorkstationConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workstations::v1::WorkstationConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<workstations_v1::WorkstationsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::workstations::v1::
              ListUsableWorkstationConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::workstations::v1::
                       ListUsableWorkstationConfigsRequest const& request) {
              return stub->ListUsableWorkstationConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::workstations::v1::ListUsableWorkstationConfigsResponse
             r) {
        std::vector<google::cloud::workstations::v1::WorkstationConfig> result(
            r.workstation_configs().size());
        auto& messages = *r.mutable_workstation_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsConnectionImpl::CreateWorkstationConfig(
    google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::WorkstationConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
              request) {
        return stub->AsyncCreateWorkstationConfig(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::WorkstationConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateWorkstationConfig(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsConnectionImpl::UpdateWorkstationConfig(
    google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::WorkstationConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
              request) {
        return stub->AsyncUpdateWorkstationConfig(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::WorkstationConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateWorkstationConfig(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
WorkstationsConnectionImpl::DeleteWorkstationConfig(
    google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::WorkstationConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
              request) {
        return stub->AsyncDeleteWorkstationConfig(cq, std::move(context),
                                                  options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::WorkstationConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteWorkstationConfig(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::workstations::v1::Workstation>
WorkstationsConnectionImpl::GetWorkstation(
    google::cloud::workstations::v1::GetWorkstationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetWorkstation(request),
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::GetWorkstationRequest const&
                 request) { return stub_->GetWorkstation(context, request); },
      request, __func__);
}

StreamRange<google::cloud::workstations::v1::Workstation>
WorkstationsConnectionImpl::ListWorkstations(
    google::cloud::workstations::v1::ListWorkstationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListWorkstations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workstations::v1::Workstation>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<workstations_v1::WorkstationsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::workstations::v1::ListWorkstationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::workstations::v1::ListWorkstationsRequest const&
                    request) {
              return stub->ListWorkstations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::workstations::v1::ListWorkstationsResponse r) {
        std::vector<google::cloud::workstations::v1::Workstation> result(
            r.workstations().size());
        auto& messages = *r.mutable_workstations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::workstations::v1::Workstation>
WorkstationsConnectionImpl::ListUsableWorkstations(
    google::cloud::workstations::v1::ListUsableWorkstationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListUsableWorkstations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workstations::v1::Workstation>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<workstations_v1::WorkstationsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::workstations::v1::ListUsableWorkstationsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::workstations::v1::
                       ListUsableWorkstationsRequest const& request) {
              return stub->ListUsableWorkstations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::workstations::v1::ListUsableWorkstationsResponse r) {
        std::vector<google::cloud::workstations::v1::Workstation> result(
            r.workstations().size());
        auto& messages = *r.mutable_workstations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnectionImpl::CreateWorkstation(
    google::cloud::workstations::v1::CreateWorkstationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::Workstation>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::CreateWorkstationRequest const&
              request) {
        return stub->AsyncCreateWorkstation(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::Workstation>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateWorkstation(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnectionImpl::UpdateWorkstation(
    google::cloud::workstations::v1::UpdateWorkstationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::Workstation>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::UpdateWorkstationRequest const&
              request) {
        return stub->AsyncUpdateWorkstation(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::Workstation>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateWorkstation(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnectionImpl::DeleteWorkstation(
    google::cloud::workstations::v1::DeleteWorkstationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::Workstation>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::DeleteWorkstationRequest const&
              request) {
        return stub->AsyncDeleteWorkstation(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::Workstation>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteWorkstation(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnectionImpl::StartWorkstation(
    google::cloud::workstations::v1::StartWorkstationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::Workstation>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::StartWorkstationRequest const&
              request) {
        return stub->AsyncStartWorkstation(cq, std::move(context), options,
                                           request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::Workstation>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StartWorkstation(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::workstations::v1::Workstation>>
WorkstationsConnectionImpl::StopWorkstation(
    google::cloud::workstations::v1::StopWorkstationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::workstations::v1::Workstation>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::workstations::v1::StopWorkstationRequest const&
              request) {
        return stub->AsyncStopWorkstation(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::workstations::v1::Workstation>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StopWorkstation(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::workstations::v1::GenerateAccessTokenResponse>
WorkstationsConnectionImpl::GenerateAccessToken(
    google::cloud::workstations::v1::GenerateAccessTokenRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateAccessToken(request),
      [this](grpc::ClientContext& context,
             google::cloud::workstations::v1::GenerateAccessTokenRequest const&
                 request) {
        return stub_->GenerateAccessToken(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workstations_v1_internal
}  // namespace cloud
}  // namespace google
