/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.util.ImageFormat;

public class DialogUtils {
    private static final String OLD_FILE_EXT = ".xmap";
    private static final String OPEN_DIALOG_SETTINGS_ID = "org.xmind.ui.openDialog";
    private static final String FILTER_INDEX = "filterIndex";
    private static final String FILTER_PATH = "filterPath";

    private DialogUtils() {
    }

    public static void makeDefaultImageSelectorDialog(FileDialog dialog, boolean withAllFileFilter) {
        DialogUtils.makeImageSelectorDialog(dialog, withAllFileFilter, ImageFormat.values());
    }

    public static void makeImageSelectorDialog(FileDialog dialog, boolean withAllFileFilter, ImageFormat ... imageFormats) {
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        if (withAllFileFilter) {
            extensions.add("*.*");
            names.add(NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName));
        }
        ImageFormat[] imageFormatArray = imageFormats;
        int n = imageFormats.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            List exts = format.getExtensions();
            if (!exts.isEmpty()) {
                StringBuilder extBuilder = new StringBuilder(exts.size() * 5);
                StringBuilder extDescBuilder = new StringBuilder(exts.size() * 5);
                for (String ext : exts) {
                    String pattern = "*" + ext;
                    if (extBuilder.length() > 0) {
                        extBuilder.append(";");
                    }
                    extBuilder.append(pattern);
                    if (extDescBuilder.length() > 0) {
                        extDescBuilder.append(", ");
                    }
                    extDescBuilder.append(pattern);
                }
                extensions.add(extBuilder.toString());
                names.add(NLS.bind((String)"{0} ({1})", (Object)format.getDescription(), (Object)extDescBuilder.toString()));
            }
            ++n2;
        }
        dialog.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
        dialog.setFilterNames(names.toArray(new String[names.size()]));
    }

    public static boolean confirmOverwrite(Shell shell, String filePath) {
        return MessageDialog.openConfirm((Shell)shell, (String)DialogMessages.ConfirmOverwrite_title, (String)NLS.bind((String)DialogMessages.ConfirmOverwrite_message, (Object)filePath));
    }

    public static boolean confirmRestart(Shell shell) {
        return new MessageDialog(null, DialogMessages.ConfirmRestart_title, null, DialogMessages.ConfirmRestart_message, 3, new String[]{DialogMessages.ConfirmRestart_Restart, DialogMessages.ConfirmRestart_Continue}, 1).open() == 0;
    }

    public static String save(Shell shell, String title, String proposalName, String[] filterExtensions, String[] filterNames, int filterIndex, String dirPath) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(false);
        dialog.setText(title == null ? DialogMessages.Save_title : title);
        if (proposalName != null) {
            dialog.setFileName(proposalName);
        }
        if (dirPath != null) {
            dialog.setFilterPath(dirPath);
        }
        if (filterExtensions != null) {
            dialog.setFilterExtensions(filterExtensions);
        }
        if (filterNames != null) {
            dialog.setFilterNames(filterNames);
        }
        if (filterIndex >= 0) {
            dialog.setFilterIndex(filterIndex);
        }
        return DialogUtils.save(shell, dialog);
    }

    public static String save(Shell shell, String proposalName, String[] filterExtensions, String[] filterNames, int filterIndex, String dirPath) {
        return DialogUtils.save(shell, null, proposalName, filterExtensions, filterNames, filterIndex, dirPath);
    }

    public static String save(Shell shell, FileDialog dialog) {
        String extension;
        int filterIndex;
        String fileName = dialog.open();
        if (fileName != null && (filterIndex = dialog.getFilterIndex()) >= 0 && new File(fileName = DialogUtils.adaptFileName(fileName, extension = dialog.getFilterExtensions()[filterIndex])).exists() && !DialogUtils.confirmOverwrite(shell, fileName)) {
            return DialogUtils.save(shell, dialog);
        }
        return fileName;
    }

    private static String adaptFileName(String fileName, String extension) {
        if (extension != null && !"".equals(extension)) {
            String defaultExt = null;
            String[] stringArray = extension.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if ((ext = ext.trim()).startsWith("*")) {
                    ext = ext.substring(1);
                }
                if (defaultExt == null) {
                    defaultExt = ext;
                }
                if (fileName.endsWith(ext)) {
                    return fileName;
                }
                ++n2;
            }
            if (defaultExt != null) {
                return String.valueOf(fileName) + defaultExt;
            }
        }
        return fileName;
    }

    public static List<File> openXMindFiles(Shell parentShell, int style) {
        String selection;
        FileDialog dialog = new FileDialog(parentShell, 0x1000 | style);
        String xmindExt = "*.xmind";
        String xmtExt = "*.xmt";
        String oldExt = "*.xmap";
        String allSupportedFileExt = String.format("%s;%s;%s", xmindExt, xmtExt, oldExt);
        String allExt = "*.*";
        ArrayList<String> filterExtensions = new ArrayList<String>(Arrays.asList(dialog.getFilterExtensions()));
        filterExtensions.add(xmindExt);
        filterExtensions.add(oldExt);
        filterExtensions.add(allSupportedFileExt);
        filterExtensions.add(allExt);
        dialog.setFilterExtensions(filterExtensions.toArray(new String[filterExtensions.size()]));
        ArrayList<String> filterNames = new ArrayList<String>(Arrays.asList(dialog.getFilterNames()));
        filterNames.add(NLS.bind((String)"{0} ({1})", (Object)DialogMessages.WorkbookFilterName, (Object)xmindExt));
        filterNames.add(NLS.bind((String)"{0} ({1})", (Object)DialogMessages.OldWorkbookFilterName, (Object)oldExt));
        filterNames.add(NLS.bind((String)"{0} ({1}, {2}, {3})", (Object[])new Object[]{DialogMessages.AllSupportedFilesFilterName, xmindExt, xmtExt, oldExt}));
        filterNames.add(NLS.bind((String)"{0} ({1})", (Object)DialogMessages.AllFilesFilterName, (Object)allExt));
        dialog.setFilterNames(filterNames.toArray(new String[filterNames.size()]));
        IDialogSettings globalSettings = MindMapUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = globalSettings.getSection(OPEN_DIALOG_SETTINGS_ID);
        if (settings == null) {
            settings = globalSettings.addNewSection(OPEN_DIALOG_SETTINGS_ID);
        }
        int filterIndex = 0;
        try {
            filterIndex = settings.getInt(FILTER_INDEX);
            if (filterIndex < 0 || filterIndex > 2) {
                filterIndex = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        dialog.setFilterIndex(filterIndex);
        String filterPath = settings.get(FILTER_PATH);
        if (filterPath != null && !"".equals(filterPath)) {
            dialog.setFilterPath(filterPath);
        }
        if ((selection = dialog.open()) == null) {
            return Collections.emptyList();
        }
        filterIndex = dialog.getFilterIndex();
        settings.put(FILTER_INDEX, filterIndex);
        filterPath = dialog.getFilterPath();
        settings.put(FILTER_PATH, filterPath);
        String[] fileNames = dialog.getFileNames();
        ArrayList<File> files = new ArrayList<File>(fileNames.length);
        int i = 0;
        while (i < fileNames.length) {
            files.add(new File(filterPath, fileNames[i]));
            ++i;
        }
        return files;
    }
}

