/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.SaveWizardManager;
import org.xmind.ui.wizards.SaveOptions;

public class SaveWizardDialog
extends Dialog {
    private List<SaveWizardManager.SaveWizardDescriptor> wizards;
    private SaveWizardManager.SaveWizardDescriptor targetWizard;
    private SaveOptions targetOptions;
    private boolean prepareForSpace = false;
    private Button defaultButton;

    public SaveWizardDialog(Shell parentShell, List<SaveWizardManager.SaveWizardDescriptor> wizards, SaveWizardManager.SaveWizardDescriptor targetWizard, SaveOptions targetOptions) {
        super(parentShell);
        this.wizards = wizards;
        this.targetWizard = targetWizard;
        this.targetOptions = targetOptions == null ? SaveOptions.getDefault() : targetOptions;
    }

    public SaveWizardManager.SaveWizardDescriptor getTargetWizard() {
        return this.targetWizard;
    }

    public SaveOptions getTargetOptions() {
        return this.targetOptions;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MindMapMessages.SaveWizardDialog_shell_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 360;
        layoutData.heightHint = -1;
        composite.setLayoutData((Object)layoutData);
        this.createNameField(composite);
        this.createWizardChoiceField(composite);
        return composite;
    }

    private void createNameField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = -1;
        layoutData.heightHint = -1;
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(MindMapMessages.SaveWizardDialog_name_text);
        Text text = new Text(composite, 18436);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText(this.targetOptions.proposalName());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String content = ((Text)e.widget).getText();
                content = content.contains("\r") ? content.replaceAll("\n\r", " ") : content.replaceAll("\n", " ");
                SaveWizardDialog.this.targetOptions = SaveWizardDialog.this.targetOptions.proposalName(content);
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 131072) {
                    SaveWizardDialog.this.prepareForSpace = false;
                    while (SaveWizardDialog.this.getShell().getDefaultButton() != SaveWizardDialog.this.defaultButton) {
                        SaveWizardDialog.this.getShell().setDefaultButton(SaveWizardDialog.this.defaultButton);
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 131072) {
                    SaveWizardDialog.this.prepareForSpace = true;
                    while (SaveWizardDialog.this.getShell().getDefaultButton() != null) {
                        SaveWizardDialog.this.getShell().setDefaultButton(null);
                    }
                    SaveWizardDialog.this.getShell().update();
                } else if (e.keyCode == 13 && SaveWizardDialog.this.prepareForSpace && e.widget instanceof Text) {
                    ((Text)e.widget).insert(" ");
                }
            }
        });
    }

    private void createWizardChoiceField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = -1;
        layoutData.heightHint = -1;
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        label.setText(MindMapMessages.SaveWizardDialog_location_text);
        Composite radioGroup = new Composite(composite, 0);
        GridLayout radioLayout = new GridLayout(1, false);
        radioLayout.marginWidth = 0;
        radioLayout.marginHeight = 0;
        radioLayout.verticalSpacing = 5;
        radioLayout.horizontalSpacing = 5;
        radioGroup.setLayout((Layout)radioLayout);
        for (SaveWizardManager.SaveWizardDescriptor wizard : this.wizards) {
            Button wizardRadio = new Button(radioGroup, 16);
            wizardRadio.setText(wizard.getName());
            wizardRadio.setData((Object)wizard);
            wizardRadio.setSelection(wizard.equals(this.targetWizard));
            wizardRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SaveWizardDialog.this.targetWizard = (SaveWizardManager.SaveWizardDescriptor)e.widget.getData();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                    SaveWizardDialog.this.okPressed();
                }
            });
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.defaultButton = this.createButton(parent, 0, MindMapMessages.SaveWizardDialog_okButton_text, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

