/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.Core;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.io.DownloadJob;
import org.xmind.ui.io.UIJobChangeListener;
import org.xmind.ui.mindmap.MindMapUI;

public class ImageDownloader {
    private static final int ROTATION_INTERVALS = 200;
    private static final ImageDownloader instance = new ImageDownloader();
    private Map<String, ImageDownload> downloads = new HashMap<String, ImageDownload>();
    private Set<ImageDownload> busyDownloads = new HashSet<ImageDownload>();
    private List<ImageDescriptor> busyImages = null;
    private ImageDescriptor warningImage = null;
    private int busyImageIndex = 0;
    private boolean rotatingBusyImages = false;
    private Runnable rotateBusyImages = new Runnable(){

        @Override
        public void run() {
            ImageDownloader.this.rotateBusyImages();
        }
    };

    private ImageDownloader() {
    }

    public void register(String url, Runnable notifier) {
        ImageDownload download = this.downloads.get(url);
        if (download == null) {
            download = new ImageDownload(url);
            this.downloads.put(url, download);
        }
        download.addNotifier(notifier);
        this.checkBusyImageRotation();
    }

    public void unregister(String url, Runnable notifier) {
        ImageDownload download = this.downloads.get(url);
        if (download != null) {
            download.removeNotifier(notifier);
        }
        this.checkBusyImageRotation();
    }

    public ImageDescriptor getImage(String url) {
        ImageDownload download = this.downloads.get(url);
        if (download != null) {
            return download.getImage();
        }
        return null;
    }

    public IStatus getStatus(String url) {
        ImageDownload download = this.downloads.get(url);
        if (download != null) {
            return download.getStatus();
        }
        return null;
    }

    private void checkBusyImageRotation() {
        if (this.busyDownloads.size() > 0) {
            if (!this.rotatingBusyImages) {
                this.asyncRunInUI(new Runnable(){

                    @Override
                    public void run() {
                        Display.getCurrent().timerExec(200, ImageDownloader.this.rotateBusyImages);
                    }
                });
            }
            this.rotatingBusyImages = true;
        } else {
            this.rotatingBusyImages = false;
        }
    }

    private void rotateBusyImages() {
        Object[] busyDownloadsArray;
        if (!this.rotatingBusyImages) {
            return;
        }
        ++this.busyImageIndex;
        if (this.busyImageIndex >= this.busyImages.size()) {
            this.busyImageIndex = 0;
        }
        Object[] objectArray = busyDownloadsArray = this.busyDownloads.toArray();
        int n = busyDownloadsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object download = objectArray[n2];
            ((ImageDownload)((Object)download)).setImage(this.getCurrentBusyImage());
            ++n2;
        }
        Display.getCurrent().timerExec(200, this.rotateBusyImages);
    }

    private void asyncRunInUI(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    private List<ImageDescriptor> getBusyImages() {
        if (this.busyImages == null) {
            this.busyImages = this.findBusyImages();
        }
        return this.busyImages;
    }

    private ImageDescriptor getWarningImage() {
        if (this.warningImage == null) {
            this.warningImage = ImageDescriptor.createFromImage((Image)Display.getCurrent().getSystemImage(8));
        }
        return this.warningImage;
    }

    private List<ImageDescriptor> findBusyImages() {
        ArrayList<ImageDescriptor> list = new ArrayList<ImageDescriptor>();
        int index = 1;
        while (index <= 12) {
            String path = String.format("/icons/busy/busy_f%02d.gif", index);
            ImageDescriptor img = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui.browser", (String)path);
            if (img != null) {
                list.add(img);
            }
            ++index;
        }
        if (list.isEmpty()) {
            list.add(MindMapUI.getImages().get("nav_stop.gif", true));
        }
        return list;
    }

    private ImageDescriptor getCurrentBusyImage() {
        return this.getBusyImages().get(this.busyImageIndex);
    }

    public static ImageDownloader getInstance() {
        return instance;
    }

    private class ImageDownload
    extends UIJobChangeListener {
        private String url;
        private IStatus status;
        private ImageDescriptor image;
        private File tempFile;
        private DownloadJob job;
        private List<Runnable> notifiers = new ArrayList<Runnable>();

        public ImageDownload(String url) {
            this.url = url;
            this.startDownload();
        }

        private void startDownload() {
            String fileExtension;
            try {
                URI uri = new URI(this.url);
                fileExtension = FileUtils.getExtension((String)uri.getPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                fileExtension = FileUtils.getExtension((String)this.url);
            }
            this.tempFile = Core.getWorkspace().createTempFile("imageDownload", "", fileExtension);
            this.job = new DownloadJob(NLS.bind((String)"Download Image From ''{0}''", (Object)this.url), this.url, this.tempFile.getAbsolutePath(), "org.xmind.ui");
            this.job.addJobChangeListener((IJobChangeListener)this);
            this.job.schedule(50L);
            this.status = new Status(1, "org.xmind.ui", NLS.bind((String)"Downloading image from ''{0}''", (Object)this.url));
            this.image = ImageDownloader.this.getCurrentBusyImage();
        }

        public void addNotifier(Runnable notifier) {
            this.notifiers.add(notifier);
            if (this.notifiers.size() > 0) {
                if (this.status.getSeverity() != 0 && this.status.getSeverity() != 1) {
                    this.startDownload();
                }
                if (this.status.getSeverity() == 1) {
                    ImageDownloader.this.busyDownloads.add(this);
                }
            }
        }

        public void removeNotifier(Runnable notifier) {
            this.notifiers.remove(notifier);
            if (this.status.getSeverity() != 1 || this.notifiers.size() <= 0) {
                ImageDownloader.this.busyDownloads.remove((Object)this);
            }
        }

        protected void doDone(IJobChangeEvent event) {
            ImageDownloader.this.busyDownloads.remove((Object)this);
            int code = event.getResult().getSeverity();
            if (code == 0) {
                this.onSuccess();
            } else if (code == 8) {
                this.onCancel();
            } else {
                this.onFailed(event.getResult());
            }
        }

        private void onSuccess() {
            try {
                this.status = new Status(0, "org.xmind.ui", NLS.bind((String)"Image downloaded from ''{0}''", (Object)this.url));
                this.setImage(ImageDescriptor.createFromURL((URL)this.tempFile.toURI().toURL()));
            }
            catch (MalformedURLException e) {
                this.status = new Status(4, "org.xmind.ui", NLS.bind((String)"Failed to parse the temp file path for the downloaded image ''{0}''", (Object)this.url), (Throwable)e);
                MindMapUIPlugin.getDefault().getLog().log(this.status);
                this.setImage(ImageDownloader.this.getWarningImage());
            }
        }

        private void onFailed(IStatus result) {
            this.status = new Status(4, "org.xmind.ui", NLS.bind((String)"Failed to download image from ''{0}'' due to ''{1}''", (Object)this.url, (Object)result.getMessage()), result.getException());
            this.setImage(ImageDownloader.this.getWarningImage());
        }

        private void onCancel() {
            this.status = new Status(8, "org.xmind.ui", NLS.bind((String)"Image download canceled from ''{0}''", (Object)this.url));
            this.setImage(ImageDownloader.this.getWarningImage());
        }

        public void setImage(ImageDescriptor newImage) {
            this.image = newImage;
            this.callNotifiers();
        }

        private void callNotifiers() {
            Object[] notifierArray;
            Object[] objectArray = notifierArray = this.notifiers.toArray();
            int n = notifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object notifier = objectArray[n2];
                try {
                    ((Runnable)notifier).run();
                }
                catch (Throwable e) {
                    MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui", "Failed to call one notifier when image downloaded from '" + this.url + "'", e));
                }
                ++n2;
            }
        }

        public ImageDescriptor getImage() {
            return this.image;
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

