/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ResourceFinder {
    private static final String SEP = "/";
    private static final String LINK = "_";
    private static final char Link = '_';

    protected ResourceFinder() {
    }

    public static URL findResource(String bundleName, String mainPath, String prefix, String suffix) {
        return ResourceFinder.findResource(bundleName, mainPath, prefix, suffix, Platform.getNL());
    }

    public static URL findResource(String bundleName, String mainPath, String prefix, String suffix, String nl) {
        return ResourceFinder.findResource(Platform.getBundle((String)bundleName), mainPath, prefix, suffix, nl);
    }

    public static URL findResource(Bundle bundle, String mainPath, String prefix, String suffix) {
        return ResourceFinder.findResource(bundle, mainPath, prefix, suffix, Platform.getNL());
    }

    public static URL findResource(Bundle bundle, String mainPath, String prefix, String suffix, String nl) {
        URL url;
        if (bundle == null) {
            return null;
        }
        String ma = ResourceFinder.getMajorLang(nl);
        String mi = ResourceFinder.getMinorLang(nl);
        if (!mainPath.endsWith(SEP)) {
            mainPath = String.valueOf(mainPath) + SEP;
        }
        if ((url = ResourceFinder.findResource(bundle, mainPath, prefix, suffix, nl, ma, mi)) != null) {
            return url;
        }
        return null;
    }

    private static URL findResource(Bundle bundle, String mainPath, String prefix, String suffix, String nl, String ma, String mi) {
        String path;
        URL url;
        if (mi != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path = String.valueOf(mainPath) + ma + SEP + mi + SEP + prefix + suffix), null)) != null) {
            return url;
        }
        path = String.valueOf(mainPath) + ma + SEP + prefix + suffix;
        url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (url != null) {
            return url;
        }
        path = String.valueOf(mainPath) + prefix + LINK + nl + suffix;
        url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (url != null) {
            return url;
        }
        if (!ma.equals(nl) && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path = String.valueOf(mainPath) + prefix + LINK + ma + suffix), null)) != null) {
            return url;
        }
        path = String.valueOf(mainPath) + prefix + suffix;
        url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (url != null) {
            return url;
        }
        return null;
    }

    public static String getMajorLang(String nl) {
        int i = nl.indexOf(95);
        if (i > 0) {
            return nl.substring(0, i);
        }
        return nl;
    }

    public static String getMinorLang(String nl) {
        int i = nl.indexOf(95);
        if (i > 0) {
            return nl.substring(i + 1);
        }
        return null;
    }
}

