/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.Item;
import org.xmind.ui.internal.spreadsheet.structures.Row;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends BranchStructureData {
    private Chart ownedChart;
    private Row ownedRow;
    private Column ownedColumn;
    private List<Item> items = new ArrayList<Item>();
    private Dimension prefContentSize = null;
    private int contentHeight = -1;
    private Rectangle bounds = null;

    public Cell(Chart ownedChart, Row ownedRow, Column ownedColumn) {
        super(ownedRow.getHead());
        this.ownedChart = ownedChart;
        this.ownedRow = ownedRow;
        this.ownedColumn = ownedColumn;
    }

    public Chart getOwnedChart() {
        return this.ownedChart;
    }

    public Column getOwnedColumn() {
        return this.ownedColumn;
    }

    public Row getOwnedRow() {
        return this.ownedRow;
    }

    void addItem(Item item) {
        this.items.add(item);
        item.setOwnedCell(this);
    }

    void removeItem(Item item) {
        this.items.remove((Object)item);
        item.setOwnedCell(null);
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Dimension getPrefContentSize() {
        if (this.prefContentSize == null) {
            this.prefContentSize = this.calcPrefContentSize();
        }
        return this.prefContentSize;
    }

    private Dimension calcPrefContentSize() {
        int w = 0;
        int h = 0;
        int minorSpacing = this.getOwnedRow().getMinorSpacing();
        Iterator<Item> it = this.items.iterator();
        while (it.hasNext()) {
            List boundaries;
            int bw = 0;
            int bh = 0;
            Item item = it.next();
            IBranchPart parent = item.getBranch().getParentBranch();
            if (parent != null && !(boundaries = parent.getBoundaries()).isEmpty()) {
                for (IBoundaryPart boundary : boundaries) {
                    List enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.contains(item.getBranch())) {
                        Insets ins = boundary.getFigure().getInsets();
                        bw = ins.getWidth();
                        if (boundary.getTitle() != null && boundary.getTitle().getFigure() != null) {
                            bw += 5;
                        }
                    }
                    if (enclosingBranches.isEmpty() || !item.getBranch().equals(enclosingBranches.get(0))) continue;
                    bh = boundary.getFigure().getInsets().getHeight();
                    if (boundary.getTitle() == null || boundary.getTitle().getFigure() == null) continue;
                    Dimension s = boundary.getTitle().getFigure().getPreferredSize();
                    bh += s.height;
                }
            }
            IFigure itemFigure = item.getBranch().getFigure();
            Dimension size = itemFigure.getPreferredSize();
            w = Math.max(w, size.width + bw);
            h += size.height;
            if (!it.hasNext()) continue;
            h += minorSpacing + bh;
        }
        return new Dimension(w, h);
    }

    public int getContentHeight() {
        if (this.contentHeight < 0) {
            this.contentHeight = this.calcContentHeight();
        }
        return this.contentHeight;
    }

    private int calcContentHeight() {
        if (!this.items.isEmpty()) {
            Item first = this.items.get(0);
            Item last = this.items.get(this.items.size() - 1);
            int height = last.getBranch().getFigure().getBounds().bottom() - first.getBranch().getFigure().getBounds().y;
            IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.getBranch(), (String)"org.xmind.ui.branchCache.insertion");
            if (ins != null && (ins.getIndex() == 0 || ins.getIndex() == this.items.size()) && this.getOwnedColumn().getHead().equals(MindMapUtils.getCache((IPart)this.getBranch(), (String)"org.xmind.ui.spreadsheet.cache.insertionColumnHead"))) {
                height += ins.getSize().height + this.getOwnedRow().getMinorSpacing();
            }
            int bh = 0;
            for (Item item : this.items) {
                List boundaries;
                IBranchPart parent = item.getBranch().getParentBranch();
                if (parent == null || (boundaries = parent.getBoundaries()).isEmpty()) continue;
                for (IBoundaryPart boundary : boundaries) {
                    List enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.isEmpty() || !item.getBranch().equals(enclosingBranches.get(0))) continue;
                    bh = boundary.getFigure().getInsets().getHeight() - this.getOwnedChart().getMinorSpacing();
                    if (boundary.getTitle() == null || boundary.getTitle().getFigure() == null) continue;
                    Dimension s = boundary.getTitle().getFigure().getPreferredSize();
                    bh += s.height;
                }
            }
            return height + bh;
        }
        return 0;
    }

    public Item findItem(IBranchPart itemBranch) {
        for (Item item : this.items) {
            if (item.getBranch() != itemBranch) continue;
            return item;
        }
        return null;
    }

    public Item getPreviousItem(Item item) {
        int index = this.getItemIndex(item);
        if (index > 0) {
            return this.items.get(index - 1);
        }
        return null;
    }

    public Item getNextItem(Item item) {
        int index = this.getItemIndex(item);
        if (index < this.items.size() - 1) {
            return this.items.get(index + 1);
        }
        return null;
    }

    public int getItemIndex(Item item) {
        return this.items.indexOf((Object)item);
    }

    public int getX() {
        return this.getOwnedColumn().getLeft();
    }

    public int getY() {
        return this.getOwnedRow().getTop();
    }

    public int getWidth() {
        return this.getOwnedColumn().getWidth();
    }

    public int getHeight() {
        return this.getOwnedRow().getHeight();
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        return this.bounds;
    }

    public String toString() {
        return "[" + this.getOwnedRow().toString() + ", " + this.getOwnedColumn().toString() + "]";
    }
}

