/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.acc.IAccessible;
import org.xmind.gef.dnd.DndData;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.gef.draw2d.KeepVisibleToolTipHelper;
import org.xmind.gef.event.DragDropEvent;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.event.MouseWheelEvent;
import org.xmind.gef.event.ViewerEventDispatcher;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.status.IStatusMachine;
import org.xmind.gef.tool.AbstractTool;
import org.xmind.gef.tool.IDragDropHandler;
import org.xmind.gef.tool.IGraphicalTool;
import org.xmind.gef.tool.ITool;

public class PartsEventDispatcher
extends ViewerEventDispatcher
implements DropTargetListener {
    private static int LONG_PRESSING_ACTIVATION_TIME = 500;
    private static int DEFAULT_START_DRAG_THRESHOLD = 3;
    private ToolTipHelper toolTipHelper;
    private Shell shell = null;
    private DropTarget dropTarget = null;
    private boolean ignoreDoubleClicking = false;
    private boolean ignoreLongPressing = false;
    private boolean ignoreDragging = false;
    private boolean ignoreNextMouseUp = false;
    private MouseDragEvent lastDragEvent = null;
    private MouseEvent currentMouseEvent = null;
    private DragDropEvent currentDropEvent = null;
    private IDragDropHandler dropHandler = null;
    private int pressedMouseButton = 0;
    private PartAccessibilityDispatcher accDispatcher = null;
    private PropertyChangeListener viewportScrollListener = null;
    private RangeModel horizontalRangeModel = null;
    private RangeModel verticalRangeModel = null;
    private boolean mouseHovering = false;
    private boolean isDraging = false;

    public PartsEventDispatcher(IGraphicalViewer viewer) {
        super(viewer);
    }

    public EditDomain getDomain() {
        return this.getViewer().getEditDomain();
    }

    protected void onActivated() {
        super.onActivated();
        this.setIgnoreDoubleClicking(false);
    }

    protected void onDeactivated() {
        this.hideToolTip();
        this.cancelLongPressing();
        this.lastDragEvent = null;
        this.currentMouseEvent = null;
        this.currentDropEvent = null;
        this.dropHandler = null;
        this.setIgnoreDoubleClicking(true);
    }

    public void setControl(Control c) {
        if (c == this.control) {
            return;
        }
        if (this.control != null && !this.control.isDisposed()) {
            throw new RuntimeException("Can not set control again once it has been set");
        }
        if (c != null) {
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (PartsEventDispatcher.this.toolTipHelper != null) {
                        PartsEventDispatcher.this.toolTipHelper.dispose();
                    }
                }
            });
        }
        this.control = c;
        this.createDropTarget(c);
    }

    protected void createDropTarget(Control c) {
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
            this.dropTarget = null;
        }
        if (this.getDndSupport() != null) {
            this.dropTarget = new DropTarget(c, this.getDndSupport().getStyle());
            this.dropTarget.setTransfer(this.getDndSupport().getTransfers());
            this.dropTarget.addDropListener((DropTargetListener)this);
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PartsEventDispatcher.this.disposeDropTarget();
                }
            });
        }
    }

    protected void dndSupportChanged(IDndSupport oldDndSupport, IDndSupport newDndSupport) {
        super.dndSupportChanged(oldDndSupport, newDndSupport);
        if (this.control != null && !this.control.isDisposed()) {
            this.createDropTarget(this.control);
        }
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    protected void disposeDropTarget() {
        if (this.dropTarget != null) {
            if (!this.dropTarget.isDisposed()) {
                this.dropTarget.removeDropListener((DropTargetListener)this);
            }
            this.dropTarget.dispose();
            this.dropTarget = null;
        }
    }

    protected Point convertPoint(int controlX, int controlY) {
        Point p = new Point(controlX, controlY);
        if (this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed()) {
            p = this.getViewer().computeToLayer(p, true);
        }
        return p;
    }

    protected MouseEvent convertMouse(org.eclipse.swt.events.MouseEvent me) {
        Point pos = this.convertPoint(me.x, me.y);
        return MouseEvent.createEvent(me, this.findPart(me.x, me.y), pos);
    }

    protected MouseEvent convertMouse(org.eclipse.swt.events.MouseEvent me, IPart host) {
        Point pos = this.convertPoint(me.x, me.y);
        return MouseEvent.createEvent(me, host, pos);
    }

    protected MouseDragEvent convertDrag(org.eclipse.swt.events.MouseEvent me) {
        Point pos = this.convertPoint(me.x, me.y);
        return MouseDragEvent.createEvent(me, this.lastDragEvent, pos, this.findPart(me.x, me.y));
    }

    protected MouseDragEvent convertDrag(org.eclipse.swt.events.MouseEvent me, IPart host) {
        Point pos = this.convertPoint(me.x, me.y);
        return MouseDragEvent.createEvent(me, this.lastDragEvent, pos, host);
    }

    protected MouseDragEvent convertDrag(org.eclipse.swt.events.MouseEvent me, MouseEvent current) {
        return MouseDragEvent.createEvent(me, this.lastDragEvent, current.cursorLocation, current.target);
    }

    protected KeyEvent convertKey(org.eclipse.swt.events.KeyEvent ke) {
        return KeyEvent.createEvent(ke, this.isImeOpened());
    }

    protected MouseWheelEvent convertWheel(Event e) {
        return MouseWheelEvent.createEvent(this.findPart(e.x, e.y), e);
    }

    protected MouseDragEvent createDragEvent(org.eclipse.swt.events.MouseEvent me) {
        Point startPoint = this.convertPoint(me.x, me.y);
        return MouseDragEvent.createEvent(me, this.findPart(me.x, me.y), startPoint);
    }

    public PartAccessibilityDispatcher getPartAccessibilityDispatcher() {
        if (this.accDispatcher == null) {
            this.accDispatcher = new PartAccessibilityDispatcher();
        }
        return this.accDispatcher;
    }

    protected EventDispatcher.AccessibilityDispatcher getAccessibilityDispatcher() {
        return this.getPartAccessibilityDispatcher();
    }

    protected IPart findPart(int controlX, int controlY) {
        IPart part = this.getViewer().findPart(controlX, controlY);
        return part == null ? this.getViewer().getRootPart() : part;
    }

    protected ITool getActiveTool() {
        EditDomain domain = this.getDomain();
        return domain != null && !domain.isDisposed() ? domain.getActiveTool() : null;
    }

    protected boolean isImeOpened() {
        if (this.shell == null) {
            if (this.control != null & !this.control.isDisposed()) {
                this.shell = this.control.getShell();
            } else {
                Control viewerControl = this.getViewer().getControl();
                if (viewerControl != null && !viewerControl.isDisposed()) {
                    this.shell = viewerControl.getShell();
                }
            }
        }
        return this.shell == null ? false : this.shell.getImeInputMode() != 0;
    }

    public void dispatchFocusGained(FocusEvent e) {
        if (!this.isActive()) {
            return;
        }
        ITool tool = this.getActiveTool();
        if (tool != null) {
            tool.focusGained(this.getViewer());
            MouseEvent me = this.currentMouseEvent;
            if (me != null) {
                this.updateCursor(me.cursorLocation, me.target);
            }
        } else {
            super.dispatchFocusGained(e);
        }
        this.updateFocus();
    }

    public void dispatchFocusLost(FocusEvent e) {
        this.cancelLongPressing();
        if (!this.isActive()) {
            return;
        }
        ITool tool = this.getActiveTool();
        if (tool != null) {
            tool.focusLost(this.getViewer());
            MouseEvent me = this.currentMouseEvent;
            if (me != null) {
                this.updateCursor(me.cursorLocation, me.target);
            }
        } else {
            super.dispatchFocusLost(e);
        }
    }

    public void dispatchKeyPressed(org.eclipse.swt.events.KeyEvent e) {
        if (!this.isActive()) {
            return;
        }
        ITool tool = this.getActiveTool();
        if (tool != null) {
            KeyEvent ke = this.convertKey(e);
            tool.keyDown(ke, this.getViewer());
            e.doit = !ke.isConsumed();
            MouseEvent me = this.currentMouseEvent;
            if (me != null && this.isValidGraphicalPart(me.target)) {
                this.updateCursor(me.cursorLocation, me.target);
            }
        } else {
            super.dispatchKeyPressed(e);
        }
        if ((e.keyCode & 0x1B) != 0) {
            this.lastDragEvent = null;
        }
        this.updateFocus();
    }

    public void dispatchKeyReleased(org.eclipse.swt.events.KeyEvent e) {
        if (!this.isActive()) {
            return;
        }
        ITool tool = this.getActiveTool();
        if (tool != null) {
            KeyEvent ke = this.convertKey(e);
            tool.keyUp(ke, this.getViewer());
            e.doit = !ke.isConsumed();
            MouseEvent me = this.currentMouseEvent;
            if (me != null && this.isValidGraphicalPart(me.target)) {
                this.updateCursor(me.cursorLocation, me.target);
            }
        } else {
            super.dispatchKeyReleased(e);
        }
        this.updateFocus();
    }

    public void dispatchKeyTraversed(TraverseEvent e) {
        if (!this.isActive()) {
            return;
        }
        ITool tool = this.getActiveTool();
        if (tool != null) {
            KeyEvent ke = this.convertKey((org.eclipse.swt.events.KeyEvent)e);
            tool.keyTraversed(ke, this.getViewer());
            e.doit = !ke.isConsumed();
            e.detail = ke.traverse;
            MouseEvent me = this.currentMouseEvent;
            if (me != null && this.isValidGraphicalPart(me.target)) {
                this.updateCursor(me.cursorLocation, me.target);
            }
        } else {
            super.dispatchKeyTraversed(e);
        }
        this.updateFocus();
    }

    public void dispatchMouseDoubleClicked(org.eclipse.swt.events.MouseEvent me) {
        if (!this.isActive()) {
            return;
        }
        this.cancelToolTipShowing();
        if (this.ignoresDoubleClicking()) {
            this.setIgnoreDoubleClicking(false);
            return;
        }
        this.receive(me);
        ITool tool = this.getActiveTool();
        if (tool != null) {
            MouseEvent e = this.currentMouseEvent;
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            tool.mouseDoubleClick(e, this.getViewer());
            this.updateCursor(e.cursorLocation, e.target);
            this.ignoreDragging = e.isConsumed() && this.pressedMouseButton != 0;
        } else {
            super.dispatchMouseDoubleClicked(me);
        }
        this.updateFocus();
    }

    public void dispatchMouseEntered(org.eclipse.swt.events.MouseEvent me) {
        if (!this.isActive()) {
            return;
        }
        this.mouseHovering = false;
        this.hookScrollBars();
        this.cancelToolTipShowing();
        this.receive(me);
        ITool tool = this.getActiveTool();
        if (tool != null) {
            MouseEvent e = this.currentMouseEvent;
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            tool.mouseEntered(e, this.getViewer());
            this.updateCursor(e.cursorLocation, e.target);
        } else {
            super.dispatchMouseEntered(me);
        }
        this.updateFocus();
    }

    public void dispatchMouseExited(org.eclipse.swt.events.MouseEvent me) {
        this.unhookScrollBars();
        if (!this.isActive()) {
            return;
        }
        this.mouseHovering = false;
        this.cancelToolTipShowing();
        this.hideToolTip();
        this.receive(me);
        ITool tool = this.getActiveTool();
        if (tool != null) {
            MouseEvent e = this.currentMouseEvent;
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            tool.mouseExited(e, this.getViewer());
            this.updateCursor(e.cursorLocation, e.target);
        } else {
            super.dispatchMouseExited(me);
        }
        this.updateFocus();
    }

    private void hookScrollBars() {
        Viewport viewport = this.getViewer().getCanvas().getViewport();
        this.horizontalRangeModel = viewport.getHorizontalRangeModel();
        this.horizontalRangeModel.addPropertyChangeListener(this.getViewportScrollListener());
        this.verticalRangeModel = viewport.getVerticalRangeModel();
        this.verticalRangeModel.addPropertyChangeListener(this.getViewportScrollListener());
    }

    private void unhookScrollBars() {
        if (this.horizontalRangeModel != null) {
            this.horizontalRangeModel.removePropertyChangeListener(this.getViewportScrollListener());
            this.horizontalRangeModel = null;
        }
        if (this.verticalRangeModel != null) {
            this.verticalRangeModel.removePropertyChangeListener(this.getViewportScrollListener());
            this.verticalRangeModel = null;
        }
    }

    private PropertyChangeListener getViewportScrollListener() {
        if (this.viewportScrollListener == null) {
            this.viewportScrollListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    PartsEventDispatcher.this.dispatchViewerScrolled(evt);
                }
            };
        }
        return this.viewportScrollListener;
    }

    protected void dispatchViewerScrolled(PropertyChangeEvent evt) {
        if (this.lastDragEvent != null || this.currentDropEvent != null || Boolean.TRUE.equals(this.getViewer().getProperties().get("ignoreScrollEvent"))) {
            return;
        }
        Display currentDisplay = Display.getCurrent();
        org.eclipse.swt.graphics.Point loc = currentDisplay.getCursorLocation();
        loc = this.control.toControl(loc);
        org.eclipse.swt.graphics.Rectangle bounds = this.control.getBounds();
        if (bounds.contains(loc)) {
            org.eclipse.swt.events.MouseEvent last;
            Event event = new Event();
            org.eclipse.swt.events.MouseEvent mouseEvent = last = this.currentMouseEvent == null ? null : this.currentMouseEvent.currentSWTEvent;
            if (last != null) {
                event.button = last.button;
                event.count = last.count;
                event.data = last.data;
                event.display = last.display;
                event.stateMask = last.stateMask;
                event.widget = last.widget;
            } else {
                event.display = currentDisplay;
                event.widget = this.control;
            }
            event.time = (int)System.currentTimeMillis();
            event.x = loc.x;
            event.y = loc.y;
            this.dispatchMouseMoved(new org.eclipse.swt.events.MouseEvent(event));
        }
    }

    public void dispatchMouseHover(org.eclipse.swt.events.MouseEvent me) {
        if (!this.isActive()) {
            return;
        }
        this.mouseHovering = true;
        this.cancelToolTipShowing();
        this.receive(me);
        ITool tool = this.getActiveTool();
        if (tool != null) {
            MouseEvent e = this.currentMouseEvent;
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            tool.mouseHover(e, this.getViewer());
            this.updateCursor(e.cursorLocation, e.target);
            this.updateToolTip(e);
        } else {
            super.dispatchMouseHover(me);
        }
        this.updateFocus();
    }

    public void cancelToolTipShowing() {
    }

    public void updateToolTip() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.hideToolTip();
        if (this.mouseHovering && this.currentMouseEvent != null) {
            this.updateToolTip(this.currentMouseEvent, false);
        }
    }

    protected void updateToolTip(MouseEvent me, boolean useEventTarget) {
        IPart target;
        Point cp = null;
        org.eclipse.swt.events.MouseEvent e = me.getCurrentSWTEvent();
        cp = e != null ? new Point(e.x, e.y) : this.getViewer().computeToControl(me.cursorLocation, true);
        IPart iPart = target = useEventTarget ? me.target : this.findPart(cp.x, cp.y);
        if (target != null && target instanceof IGraphicalPart) {
            ITool tool = this.getActiveTool();
            IFigure tooltip = null;
            if (tool instanceof IGraphicalTool) {
                tooltip = ((IGraphicalTool)((Object)tool)).getToolTip(target, me.cursorLocation);
            }
            if (tooltip == null && target instanceof IGraphicalEditPart) {
                tooltip = ((IGraphicalEditPart)target).findTooltipAt(me.cursorLocation);
            }
            if (tooltip != null) {
                Point absolute = new Point(this.control.toDisplay(cp.x, cp.y));
                this.getToolTipHelper().displayToolTipNear(((IGraphicalPart)target).getFigure(), tooltip, absolute.x, absolute.y);
                return;
            }
        }
        this.hideToolTip();
    }

    protected ToolTipHelper getToolTipHelper() {
        IPart target;
        if (this.toolTipHelper == null) {
            IPart target2;
            if (this.currentMouseEvent != null && (target2 = this.currentMouseEvent.target) != null && target2 instanceof GraphicalEditPart) {
                String actionId = ((GraphicalEditPart)target2).getActionId();
                this.toolTipHelper = actionId != null && (actionId.equals("org.xmind.ui.editNotes") || actionId.equals("org.xmind.ui.editComments")) ? new KeepVisibleToolTipHelper(this.control) : new ToolTipHelper(this.control);
            }
        } else if (this.currentMouseEvent != null && (target = this.currentMouseEvent.target) != null && target instanceof GraphicalEditPart) {
            String actionId = ((GraphicalEditPart)target).getActionId();
            if (actionId != null && (actionId.equals("org.xmind.ui.editNotes") || actionId.equals("org.xmind.ui.editComments"))) {
                if (!(this.toolTipHelper instanceof KeepVisibleToolTipHelper)) {
                    this.toolTipHelper.dispose();
                    this.toolTipHelper = new KeepVisibleToolTipHelper(this.control);
                }
            } else if (this.toolTipHelper instanceof KeepVisibleToolTipHelper) {
                this.toolTipHelper.dispose();
                this.toolTipHelper = new ToolTipHelper(this.control);
            }
        }
        if (this.toolTipHelper == null) {
            this.toolTipHelper = new ToolTipHelper(this.control);
        }
        return this.toolTipHelper;
    }

    protected void updateToolTip(MouseEvent me) {
        this.updateToolTip(me, true);
    }

    protected boolean isValidGraphicalPart(IPart host) {
        return host != null && host instanceof IGraphicalPart && host.getStatus().isActive();
    }

    protected void updateFocus() {
        IFigure fig;
        IFigure focusableFigure = null;
        IPart focusedPart = this.getViewer().getFocusedPart();
        if (focusedPart instanceof IGraphicalPart && (fig = ((IGraphicalPart)focusedPart).getFigure()).isRequestFocusEnabled()) {
            focusableFigure = fig;
        }
        this.setFocus(focusableFigure);
    }

    public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
        if (!this.isActive()) {
            return;
        }
        if (me.x > 36863) {
            me.x -= 65536;
        }
        this.mouseHovering = false;
        this.cancelToolTipShowing();
        this.receive(me);
        ITool tool = this.getActiveTool();
        if (tool != null) {
            MouseEvent e = this.currentMouseEvent;
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            if ((me.stateMask & SWT.BUTTON_MASK) != 0 && this.lastDragEvent != null && !this.ignoreDragging) {
                this.lastDragEvent = this.convertDrag(me, e);
                if (!this.isDraging) {
                    this.isDraging = this.isDragDetected(this.lastDragEvent, this.getViewer().getProperties().getInteger("startDragThreshold", DEFAULT_START_DRAG_THRESHOLD));
                }
                if (this.isDraging) {
                    tool.mouseDrag(this.lastDragEvent, this.getViewer());
                }
            } else if ((me.stateMask & SWT.BUTTON_MASK) == 0) {
                tool.mouseMove(e, this.getViewer());
            }
            this.updateCursor(e.cursorLocation, e.target);
            if (this.getToolTipHelper().isShowing()) {
                this.updateToolTip(e);
            }
        } else {
            super.dispatchMouseMoved(me);
        }
        this.updateFocus();
    }

    private boolean isDragDetected(MouseDragEvent me, int threshold) {
        int deltaX = Math.abs(me.cursorLocation.x - me.startingLocation.x);
        int deltaY = Math.abs(me.cursorLocation.y - me.startingLocation.y);
        return deltaX >= threshold || deltaY >= threshold;
    }

    private void receive(org.eclipse.swt.events.MouseEvent me) {
        this.readStateMask(me);
        MouseEvent current = this.convertMouse(me);
        if (this.currentMouseEvent == null || current.target != this.currentMouseEvent.target) {
            ITool tool;
            if (this.currentMouseEvent != null) {
                tool = this.getActiveTool();
                if (tool != null) {
                    tool.mouseExited(this.currentMouseEvent, this.getViewer());
                }
                this.hideToolTip();
            }
            if (current.target != null && (tool = this.getActiveTool()) != null) {
                tool.mouseEntered(current, this.getViewer());
            }
        }
        this.currentMouseEvent = current;
    }

    protected void readStateMask(org.eclipse.swt.events.MouseEvent me) {
        ITool tool = this.getActiveTool();
        if (tool != null && tool instanceof AbstractTool) {
            IStatusMachine statusMachine = ((AbstractTool)tool).getStatus();
            int stateMask = me.stateMask;
            statusMachine.setStatus(4, (stateMask & SWT.MOD1) != 0);
            statusMachine.setStatus(8, (stateMask & SWT.MOD2) != 0);
            statusMachine.setStatus(2, (stateMask & SWT.MOD3) != 0);
        }
    }

    public void hideToolTip() {
        if (this.control != null && !this.control.isDisposed()) {
            this.getToolTipHelper().updateToolTip(null, null, 0, 0);
        }
    }

    protected void updateCursor(Point pos, IPart host) {
        if (!this.isActive()) {
            return;
        }
        Cursor currentCursor = null;
        ITool tool = this.getActiveTool();
        if (tool instanceof IGraphicalTool) {
            currentCursor = ((IGraphicalTool)((Object)tool)).getCurrentCursor(pos, host);
        }
        if (currentCursor == null && host != null && host instanceof IGraphicalEditPart && host.getStatus().isActive()) {
            currentCursor = ((IGraphicalEditPart)host).getCursor(pos);
        }
        this.setCursor(currentCursor);
    }

    protected int getLongPressingActivationTime() {
        return LONG_PRESSING_ACTIVATION_TIME;
    }

    public void dispatchMousePressed(org.eclipse.swt.events.MouseEvent me) {
        this.isDraging = false;
        this.pressedMouseButton = me.button;
        if (!this.isActive()) {
            return;
        }
        this.cancelToolTipShowing();
        this.lastDragEvent = this.createDragEvent(me);
        this.receive(me);
        ITool tool = this.getActiveTool();
        if (tool != null) {
            final MouseEvent e = this.currentMouseEvent;
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            tool.mouseDown(e, this.getViewer());
            if (e.isConsumed()) {
                this.ignoreNextMouseUp = true;
            }
            this.updateCursor(e.cursorLocation, e.target);
            if (this.getToolTipHelper().isShowing()) {
                this.updateToolTip(e);
            }
            this.ignoreLongPressing = false;
            this.setIgnoreDoubleClicking(e.isConsumed());
            Display.getCurrent().timerExec(this.getLongPressingActivationTime(), new Runnable(){

                public void run() {
                    PartsEventDispatcher.this.dispatchMouseLongPressed(e);
                }
            });
        } else {
            super.dispatchMousePressed(me);
            this.setIgnoreDoubleClicking(this.getCurrentEvent() != null && this.getCurrentEvent().isConsumed());
        }
        this.updateFocus();
    }

    public boolean isMousePressed() {
        return this.pressedMouseButton != 0;
    }

    public int getPressedMouseButton() {
        return this.pressedMouseButton;
    }

    public boolean ignoresDoubleClicking() {
        return this.ignoreDoubleClicking;
    }

    public void setIgnoreDoubleClicking(boolean ignore) {
        this.ignoreDoubleClicking = ignore;
    }

    public void cancelLongPressing() {
        this.ignoreLongPressing = true;
    }

    public boolean ignoresLongPressing() {
        return this.ignoreLongPressing;
    }

    public void dispatchMouseLongPressed(MouseEvent me) {
        ITool tool;
        if (!this.isActive()) {
            return;
        }
        if (!this.ignoresLongPressing() && me == this.currentMouseEvent && me != null && !me.isConsumed() && (tool = this.getActiveTool()) != null) {
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(me.cursorLocation);
            }
            tool.mouseLongPressed(me, this.getViewer());
            this.updateCursor(me.cursorLocation, me.target);
        }
    }

    public void dispatchMouseReleased(org.eclipse.swt.events.MouseEvent me) {
        if (this.ignoreNextMouseUp) {
            this.ignoreNextMouseUp = false;
            return;
        }
        this.pressedMouseButton = 0;
        this.ignoreDragging = false;
        this.isDraging = false;
        if (!this.isActive()) {
            return;
        }
        this.cancelToolTipShowing();
        this.lastDragEvent = null;
        this.receive(me);
        ITool tool = this.getActiveTool();
        if (tool != null) {
            MouseEvent e = this.currentMouseEvent;
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            tool.mouseUp(e, this.getViewer());
            this.updateCursor(e.cursorLocation, e.target);
        } else {
            super.dispatchMouseReleased(me);
        }
        this.updateFocus();
    }

    public void dispatchMouseWheelScrolled(Event event) {
        if (!this.isActive()) {
            return;
        }
        this.cancelToolTipShowing();
        ITool tool = this.getActiveTool();
        if (tool != null) {
            MouseEvent e = this.currentMouseEvent;
            if (e != null && tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(e.cursorLocation);
            }
            MouseWheelEvent mwe = this.convertWheel(event);
            tool.mouseWheelScrolled(mwe, this.getViewer());
            if (e != null) {
                this.updateCursor(e.cursorLocation, e.target);
            }
            event.doit = mwe.doIt;
        } else {
            super.dispatchMouseWheelScrolled(event);
        }
    }

    protected DragDropEvent createDropEvent(DropTargetEvent e, boolean drop) {
        TransferData[] dataTypes = drop && e.currentDataType != null ? new TransferData[]{e.currentDataType} : e.dataTypes;
        DndData dndData = this.getDndSupport().parseData(dataTypes, this.getDropTarget(), !drop);
        if (dndData == null) {
            return null;
        }
        Point p = new Point(this.control.toControl(e.x, e.y));
        Point location = this.convertPoint(p.x, p.y);
        IPart host = this.findPart(p.x, p.y);
        DragDropEvent event = DragDropEvent.createFrom(e, host, location);
        event.dndData = dndData;
        IDndClient client = this.getDndSupport().getDndClient(dndData.clientId);
        if (event.detail == 16) {
            event.detail = event.operations;
        }
        if ((event.detail & 4) != 0 && !client.canLink(dndData.dataType, this.getViewer(), location, host)) {
            event.detail &= 0xFFFFFFFB;
        }
        if ((event.detail & 2) != 0 && !client.canMove(dndData.dataType, this.getViewer(), location, host)) {
            event.detail &= 0xFFFFFFFD;
        }
        if ((event.detail & 1) != 0 && !client.canCopy(dndData.dataType, this.getViewer(), location, host)) {
            event.detail &= 0xFFFFFFFE;
        }
        return event;
    }

    protected void feedback(DragDropEvent de, DropTargetEvent swtEvent) {
        swtEvent.detail = de.detail;
        swtEvent.currentDataType = de.dndData.dataType;
        this.updateControl();
    }

    private void updateControl() {
        LightweightSystem lws;
        if (this.control instanceof FigureCanvas) {
            lws = ((FigureCanvas)this.control).getLightweightSystem();
        } else if (this.getViewer() instanceof GraphicalViewer) {
            lws = ((GraphicalViewer)this.getViewer()).getLightweightSystem();
        } else if (this.getViewer().getCanvas() != null && !this.getViewer().getCanvas().isDisposed()) {
            lws = this.getViewer().getCanvas().getLightweightSystem();
        } else {
            return;
        }
        lws.getUpdateManager().performUpdate();
    }

    protected IDragDropHandler getDragDropHandler() {
        IDragDropHandler handler = null;
        ITool tool = this.getActiveTool();
        if (tool instanceof IDragDropHandler) {
            handler = (IDragDropHandler)((Object)tool);
        }
        return handler;
    }

    public void dragEnter(DropTargetEvent event) {
        if (!this.isActive()) {
            return;
        }
        this.dropHandler = null;
        this.currentDropEvent = this.createDropEvent(event, false);
        if (this.currentDropEvent == null) {
            event.detail = 0;
            return;
        }
        IDragDropHandler handler = this.getDragDropHandler();
        if (handler != null) {
            if (handler instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)handler)).setCursorPosition(this.currentDropEvent.location);
            }
            handler.dragStarted(this.currentDropEvent, this.getViewer());
            handler.dragEntered(this.currentDropEvent, this.getViewer());
            this.feedback(this.currentDropEvent, event);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        if (!this.isActive()) {
            return;
        }
        if (this.currentDropEvent == null) {
            event.detail = 0;
            return;
        }
        IDragDropHandler handler = this.getDragDropHandler();
        if (handler != null) {
            if (handler instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)handler)).setCursorPosition(this.currentDropEvent.location);
            }
            handler.dragExited(this.currentDropEvent, this.getViewer());
            handler.dragDismissed(this.currentDropEvent, this.getViewer());
            this.feedback(this.currentDropEvent, event);
            this.dropHandler = handler;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (!this.isActive()) {
            return;
        }
        this.currentDropEvent = this.createDropEvent(event, false);
        if (this.currentDropEvent == null) {
            event.detail = 0;
            return;
        }
        IDragDropHandler handler = this.getDragDropHandler();
        if (handler != null) {
            if (handler instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)handler)).setCursorPosition(this.currentDropEvent.location);
            }
            handler.dragOperationChanged(this.currentDropEvent, this.getViewer());
            this.feedback(this.currentDropEvent, event);
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (!this.isActive()) {
            return;
        }
        DragDropEvent prevDropEvent = this.currentDropEvent;
        this.currentDropEvent = this.createDropEvent(event, false);
        if (this.currentDropEvent == null) {
            event.detail = 0;
            return;
        }
        IDragDropHandler handler = this.getDragDropHandler();
        if (handler != null) {
            if (handler instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)handler)).setCursorPosition(this.currentDropEvent.location);
            }
            if (prevDropEvent != null && prevDropEvent.target != this.currentDropEvent.target) {
                handler.dragExited(prevDropEvent, this.getViewer());
                handler.dragEntered(this.currentDropEvent, this.getViewer());
            }
            handler.dragOver(this.currentDropEvent, this.getViewer());
            this.feedback(this.currentDropEvent, event);
        }
    }

    public void drop(DropTargetEvent event) {
        if (!this.isActive()) {
            return;
        }
        this.currentDropEvent = this.createDropEvent(event, true);
        if (this.currentDropEvent == null) {
            event.detail = 0;
            return;
        }
        IDragDropHandler handler = this.dropHandler;
        if (handler == null) {
            handler = this.getDragDropHandler();
        }
        if (handler != null) {
            if (handler instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)handler)).setCursorPosition(this.currentDropEvent.location);
            }
            handler.drop(this.currentDropEvent, this.getViewer());
            this.feedback(this.currentDropEvent, event);
            this.dropHandler = null;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (!this.isActive()) {
            return;
        }
        this.currentDropEvent = this.createDropEvent(event, false);
        if (this.currentDropEvent == null) {
            event.detail = 0;
            return;
        }
        IDragDropHandler handler = this.dropHandler;
        if (handler == null) {
            handler = this.getDragDropHandler();
        }
        if (handler != null) {
            if (handler instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)handler)).setCursorPosition(this.currentDropEvent.location);
            }
            handler.dropAccept(this.currentDropEvent, this.getViewer());
            this.feedback(this.currentDropEvent, event);
        }
    }

    protected class PartAccessibilityDispatcher
    extends EventDispatcher.AccessibilityDispatcher {
        protected PartAccessibilityDispatcher() {
        }

        private IAccessible get(int childID) {
            if (childID == -1 || childID == -2) {
                IAccessible acc;
                IPart focused = this.getFocusedPart();
                if (focused != null && (acc = (IAccessible)focused.getAdapter(IAccessible.class)) != null) {
                    return acc;
                }
                IPart contents = PartsEventDispatcher.this.getViewer().getRootPart().getContents();
                if (contents == null) {
                    return null;
                }
                return (IAccessible)contents.getAdapter(IAccessible.class);
            }
            return PartsEventDispatcher.this.getViewer().getAccessibleRegistry().getAccessible(childID);
        }

        public void getChildAtPoint(AccessibleControlEvent e) {
            IPart part = PartsEventDispatcher.this.findPart(e.x, e.y);
            if (part == null) {
                return;
            }
            IAccessible acc = (IAccessible)part.getAdapter(IAccessible.class);
            if (acc != null) {
                e.childID = acc.getAccessibleId();
            }
        }

        public void getChildCount(AccessibleControlEvent e) {
            e.detail = PartsEventDispatcher.this.getViewer().getAccessibleRegistry().getNumAccessibles();
        }

        public void getChildren(AccessibleControlEvent e) {
            e.children = PartsEventDispatcher.this.getViewer().getAccessibleRegistry().getAllAccessibleIDs();
        }

        public void getDefaultAction(AccessibleControlEvent e) {
            String defaultAction;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (defaultAction = acc.getDefaultAction()) != null) {
                e.result = defaultAction;
            }
        }

        public void getFocus(AccessibleControlEvent e) {
            if (PartsEventDispatcher.this.control.isFocusControl()) {
                IAccessible acc;
                IPart focusedPart = this.getFocusedPart();
                if (focusedPart != null && (acc = (IAccessible)focusedPart.getAdapter(IAccessible.class)) != null) {
                    e.childID = acc.getAccessibleId();
                    return;
                }
                e.childID = -1;
            } else {
                e.childID = -2;
            }
        }

        private IPart getFocusedPart() {
            Object focused = PartsEventDispatcher.this.getViewer().getFocused();
            return focused == null ? null : PartsEventDispatcher.this.getViewer().getSelectionSupport().findSelectablePart(focused);
        }

        public void getLocation(AccessibleControlEvent e) {
            Rectangle r;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (r = acc.getLocation()) != null) {
                e.x = r.x;
                e.y = r.y;
                if (r.width >= 0) {
                    e.width = r.width;
                }
                if (r.height >= 0) {
                    e.height = r.height;
                }
            }
        }

        public void getRole(AccessibleControlEvent e) {
            int role;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (role = acc.getRole()) >= 0) {
                e.detail = role;
            }
        }

        public void getSelection(AccessibleControlEvent e) {
            List<IPart> selectedParts = PartsEventDispatcher.this.getViewer().getSelectionSupport().getPartSelection();
            if (selectedParts.isEmpty()) {
                e.childID = PartsEventDispatcher.this.getViewer().getControl().isFocusControl() ? -1 : -2;
                return;
            }
            ArrayList<Integer> childIds = new ArrayList<Integer>(selectedParts.size());
            for (IPart p : selectedParts) {
                IAccessible acc = (IAccessible)p.getAdapter(IAccessible.class);
                if (acc == null) continue;
                childIds.add(acc.getAccessibleId());
            }
            if (childIds.isEmpty()) {
                e.childID = -2;
            } else {
                e.childID = -3;
                e.children = childIds.toArray();
            }
        }

        public void getState(AccessibleControlEvent e) {
            int state;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (state = acc.getState()) >= 0) {
                e.detail = state;
            }
        }

        public void getValue(AccessibleControlEvent e) {
            String value;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (value = acc.getValue()) != null) {
                e.result = value;
            }
        }

        public void getDescription(AccessibleEvent e) {
            String description;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (description = acc.getDescription()) != null) {
                e.result = description;
            }
        }

        public void getHelp(AccessibleEvent e) {
            String help;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (help = acc.getHelp()) != null) {
                e.result = help;
            }
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
            String keyboardShortcut;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (keyboardShortcut = acc.getKeyboardShortcut()) != null) {
                e.result = keyboardShortcut;
            }
        }

        public void getName(AccessibleEvent e) {
            String name;
            IAccessible acc = this.get(e.childID);
            if (acc != null && (name = acc.getName()) != null) {
                e.result = name;
            }
        }
    }
}

