/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.novamind;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.imports.ImportMessages;
import org.xmind.ui.internal.imports.ImportPlugin;
import org.xmind.ui.internal.imports.novamind.NovaMindImporter;
import org.xmind.ui.wizards.AbstractMindMapImportPage;
import org.xmind.ui.wizards.AbstractMindMapImportWizard;
import org.xmind.ui.wizards.MindMapImporter;

public class NovaMindImportWizard
extends AbstractMindMapImportWizard {
    private static final String SETTINGS_ID = "org.xmind.ui.imports.NovaMind";
    private static final String PAGE_ID = "importNovaMind";
    private static final String EXT = "*.nm5";
    private NovaMindImportPage page;

    public NovaMindImportWizard() {
        IDialogSettings settings = ImportPlugin.getDefault().getDialogSettings().getSection(SETTINGS_ID);
        if (settings == null) {
            settings = ImportPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_ID);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(ImportMessages.NovaMindImportWizard_windowTitle);
    }

    public void addPages() {
        this.page = new NovaMindImportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected MindMapImporter createImporter(String sourcePath, IWorkbook targetWorkbook) {
        return new NovaMindImporter(sourcePath, targetWorkbook);
    }

    protected String getApplicationId() {
        return "NovaMind";
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private class NovaMindImportPage
    extends AbstractMindMapImportPage {
        protected NovaMindImportPage() {
            super(NovaMindImportWizard.PAGE_ID, ImportMessages.NovaMindImportPage_title);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            Control destinationControl = this.createDestinationControl(composite);
            destinationControl.setLayoutData((Object)new GridData(4, 4, true, true));
            this.updateStatus();
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    NovaMindImportPage.this.openBrowseDialog();
                }
            });
        }

        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            dialog.setFilterExtensions(new String[]{NovaMindImportWizard.EXT});
            dialog.setFilterNames(new String[]{NLS.bind((String)ImportMessages.NovaMindImportPage_FileDialog_Filter_name, (Object)NovaMindImportWizard.EXT)});
            return dialog;
        }
    }
}

