/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.vector.svg;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.exports.vector.svg.Messages;
import org.xmind.ui.internal.exports.vector.svg.SVGExporter;
import org.xmind.ui.internal.exports.vector.svg.SvgPlugin;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class SVGExportWizard
extends DocumentExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.export.svgExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.export.svg";
    private static final String SVG_EXT = ".svg";
    private SVGExportPage page;

    public SVGExportWizard() {
        this.setWindowTitle(Messages.SVGWizard_WindowTitle);
        this.setDialogSettings(SvgPlugin.getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected IExporter createExporter() {
        IMindMap mindmap = this.getSourceMindMap();
        SVGExporter exporter = new SVGExporter(mindmap.getSheet(), mindmap.getCentralTopic(), this.getTargetPath(), (IGraphicalViewer)this.getSourceViewer(), this.getDialogSettings());
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    public void openFile(String path, IProgressMonitor monitor) {
        boolean edgeExcuteFlag = false;
        if (new File(path).exists()) {
            monitor.subTask(Messages.ExportPage_Launching);
            if (this.isWin10OrHigher()) {
                try {
                    edgeExcuteFlag = true;
                    Runtime.getRuntime().exec("cmd.exe /c \"start microsoft-edge:" + new File(path).toURI().toString() + "\"");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!edgeExcuteFlag) {
                Program.launch((String)path);
            }
        }
    }

    public boolean isWin10OrHigher() {
        String osVersion = System.getProperty("os.version");
        String osName = System.getProperty("os.name");
        return osName.indexOf("Windows") != -1 && (osVersion.indexOf("10.") != -1 || Double.valueOf(osVersion) > 6.2 && Double.valueOf(osVersion) < 7.0);
    }

    protected void addValidPages() {
        this.page = new SVGExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getFormatName() {
        return Messages.SVGWizard_FormatName;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && SVG_EXT.equalsIgnoreCase(extension);
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + SVG_EXT;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        SvgPlugin.getDefault().getUsageDataCollector().increase("ExportToSVGCount");
        super.doExport(monitor, display, parentShell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SVGExportPage
    extends AbstractMindMapExportPage {
        private Button showPlusCheck;
        private Button showMinusCheck;

        public SVGExportPage() {
            super(SVGExportWizard.PAGE_NAME, Messages.SVGPage_Title);
            this.setDescription(Messages.SVGPage_Description);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, Messages.SVGPage_FilterName);
            filterExtensions.add(0, "*.svg");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 25;
            layout.marginTop = 20;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control setupGroup = this.createSetupControls(composite);
            setupGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            Control fileGroup = this.createFileControls(composite);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = 210;
            fileGroup.setLayoutData((Object)gridData);
        }

        private Control createSetupControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 20;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            this.createShowPlusMinusControls(composite);
            return composite;
        }

        private void createShowPlusMinusControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 15;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(Messages.ExportWizard_Collapse_Expand_text);
            Composite rightGroup = new Composite(composite, 0);
            GridLayout gridLayout2 = new GridLayout(1, false);
            gridLayout2.marginWidth = 0;
            gridLayout2.marginHeight = 0;
            gridLayout2.verticalSpacing = 15;
            gridLayout2.horizontalSpacing = 0;
            gridLayout2.marginLeft = 15;
            rightGroup.setLayout((Layout)gridLayout2);
            GridData gridData = new GridData(4, 4, false, false);
            gridData.widthHint = 300;
            gridData.heightHint = -1;
            rightGroup.setLayoutData((Object)gridData);
            this.createShowPlusCheck(rightGroup);
            this.createShowMinusCheck(rightGroup);
            this.initPlusMinusCheckState();
        }

        private void createShowPlusCheck(Composite parent) {
            this.showPlusCheck = this.createPlusMinusCheck(parent, Messages.SVGExportWizard_showPlusCheck_text, MindMapUI.getImages().get("plus.png", true).createImage());
        }

        private void createShowMinusCheck(Composite parent) {
            this.showMinusCheck = this.createPlusMinusCheck(parent, Messages.SVGExportWizard_showMinusCheck_text, MindMapUI.getImages().get("minus.png", true).createImage());
        }

        private Button createPlusMinusCheck(Composite parent, String text, Image image) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getBackground());
            composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            Button check = new Button(composite, 32);
            check.setBackground(composite.getBackground());
            check.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            check.setText(text);
            Label imageLabel = new Label(composite, 0);
            imageLabel.setBackground(composite.getBackground());
            imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            imageLabel.setImage(image);
            this.hookWidget((Widget)check, 13);
            return check;
        }

        private void initPlusMinusCheckState() {
            boolean plusVisible = this.getBoolean(this.getDialogSettings(), "plusVisible", true);
            boolean minusVisible = this.getBoolean(this.getDialogSettings(), "minusVisible", true);
            this.showPlusCheck.setSelection(plusVisible);
            this.showMinusCheck.setSelection(minusVisible);
        }

        private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
            boolean value = defaultValue;
            if (settings.get(key) != null) {
                value = settings.getBoolean(key);
            }
            return value;
        }

        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.showPlusCheck) {
                this.setProperty("plusVisible", this.showPlusCheck.getSelection());
            } else if (event.widget == this.showMinusCheck) {
                this.setProperty("minusVisible", this.showMinusCheck.getSelection());
            } else {
                super.handleWidgetEvent(event);
            }
        }

        private void setProperty(String key, boolean value) {
            this.getDialogSettings().put(key, value);
        }
    }
}

