
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_Polygon3D.hxx>
#include <Poly_Polygon2D.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_CoherentTriangle.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_CoherentTriangle.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_CoherentLink.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Dir.hxx>
#include <gp_Dir2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_TriangulationParameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Poly.hxx>
#include <Poly_Array1OfTriangle.hxx>
#include <Poly_ArrayOfNodes.hxx>
#include <Poly_ArrayOfUVNodes.hxx>
#include <Poly_CoherentLink.hxx>
#include <Poly_CoherentNode.hxx>
#include <Poly_CoherentTriangle.hxx>
#include <Poly_CoherentTriangulation.hxx>
#include <Poly_CoherentTriPtr.hxx>
#include <Poly_Connect.hxx>
#include <Poly_HArray1OfTriangle.hxx>
#include <Poly_ListOfTriangulation.hxx>
#include <Poly_MakeLoops.hxx>
#include <Poly_MergeNodesTool.hxx>
#include <Poly_MeshPurpose.hxx>
#include <Poly_Polygon2D.hxx>
#include <Poly_Polygon3D.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Triangle.hxx>
#include <Poly_Triangulation.hxx>
#include <Poly_TriangulationParameters.hxx>

// template related includes

// ./opencascade/Poly_Array1OfTriangle.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Poly_CoherentTriangulation.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Poly_CoherentTriangulation.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Poly_CoherentTriangulation.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Poly_ListOfTriangulation.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <OSD_FileSystem.hxx>

// Module definiiton
void register_Poly(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Poly"));
py::object klass;

//Python trampoline classes

// classes

    // Class Poly_ArrayOfNodes from ./opencascade/Poly_ArrayOfNodes.hxx
    klass = m.attr("Poly_ArrayOfNodes");


    // nested enums

    static_cast<py::class_<Poly_ArrayOfNodes , shared_ptr<Poly_ArrayOfNodes>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< Standard_Integer >()  , py::arg("theLength") )
        .def(py::init< const Poly_ArrayOfNodes & >()  , py::arg("theOther") )
        .def(py::init< const gp_Pnt &,Standard_Integer >()  , py::arg("theBegin"),  py::arg("theLength") )
        .def(py::init<  const NCollection_Vec3<Standard_ShortReal> &,Standard_Integer >()  , py::arg("theBegin"),  py::arg("theLength") )
    // custom constructors
    // methods
        .def("IsDoublePrecision",
             (bool (Poly_ArrayOfNodes::*)() const) static_cast<bool (Poly_ArrayOfNodes::*)() const>(&Poly_ArrayOfNodes::IsDoublePrecision),
             R"#(Returns TRUE if array defines nodes with double precision.)#" 
          )
        .def("SetDoublePrecision",
             (void (Poly_ArrayOfNodes::*)( bool  ) ) static_cast<void (Poly_ArrayOfNodes::*)( bool  ) >(&Poly_ArrayOfNodes::SetDoublePrecision),
             R"#(Sets if array should define nodes with double or single precision. Raises exception if array was already allocated.)#"  , py::arg("theIsDouble")
          )
        .def("Assign",
             (Poly_ArrayOfNodes & (Poly_ArrayOfNodes::*)( const Poly_ArrayOfNodes &  ) ) static_cast<Poly_ArrayOfNodes & (Poly_ArrayOfNodes::*)( const Poly_ArrayOfNodes &  ) >(&Poly_ArrayOfNodes::Assign),
             R"#(Copies data of theOther array to this. The arrays should have the same length, but may have different precision / number of components (data conversion will be applied in the latter case).)#"  , py::arg("theOther")
          )
        .def("Move",
             (Poly_ArrayOfNodes & (Poly_ArrayOfNodes::*)( Poly_ArrayOfNodes &  ) ) static_cast<Poly_ArrayOfNodes & (Poly_ArrayOfNodes::*)( Poly_ArrayOfNodes &  ) >(&Poly_ArrayOfNodes::Move),
             R"#(Move assignment.)#"  , py::arg("theOther")
          )
        .def("Value",
             (gp_Pnt (Poly_ArrayOfNodes::*)( Standard_Integer  ) const) static_cast<gp_Pnt (Poly_ArrayOfNodes::*)( Standard_Integer  ) const>(&Poly_ArrayOfNodes::Value),
             R"#(A generalized accessor to point.)#"  , py::arg("theIndex")
          )
        .def("SetValue",
             (void (Poly_ArrayOfNodes::*)( Standard_Integer ,  const gp_Pnt &  ) ) static_cast<void (Poly_ArrayOfNodes::*)( Standard_Integer ,  const gp_Pnt &  ) >(&Poly_ArrayOfNodes::SetValue),
             R"#(A generalized setter for point.)#"  , py::arg("theIndex"),  py::arg("theValue")
          )
        .def("Value",
             (gp_Pnt (Poly_ArrayOfNodes::*)( Standard_Integer  ) const) static_cast<gp_Pnt (Poly_ArrayOfNodes::*)( Standard_Integer  ) const>(&Poly_ArrayOfNodes::Value),
             R"#(A generalized accessor to point.)#"  , py::arg("theIndex")
          )
        .def("SetValue",
             (void (Poly_ArrayOfNodes::*)( Standard_Integer ,  const gp_Pnt &  ) ) static_cast<void (Poly_ArrayOfNodes::*)( Standard_Integer ,  const gp_Pnt &  ) >(&Poly_ArrayOfNodes::SetValue),
             R"#(A generalized setter for point.)#"  , py::arg("theIndex"),  py::arg("theValue")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Poly_ArrayOfUVNodes from ./opencascade/Poly_ArrayOfUVNodes.hxx
    klass = m.attr("Poly_ArrayOfUVNodes");


    // nested enums

    static_cast<py::class_<Poly_ArrayOfUVNodes , shared_ptr<Poly_ArrayOfUVNodes>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< Standard_Integer >()  , py::arg("theLength") )
        .def(py::init< const Poly_ArrayOfUVNodes & >()  , py::arg("theOther") )
        .def(py::init< const gp_Pnt2d &,Standard_Integer >()  , py::arg("theBegin"),  py::arg("theLength") )
        .def(py::init<  const NCollection_Vec2<Standard_ShortReal> &,Standard_Integer >()  , py::arg("theBegin"),  py::arg("theLength") )
    // custom constructors
    // methods
        .def("IsDoublePrecision",
             (bool (Poly_ArrayOfUVNodes::*)() const) static_cast<bool (Poly_ArrayOfUVNodes::*)() const>(&Poly_ArrayOfUVNodes::IsDoublePrecision),
             R"#(Returns TRUE if array defines nodes with double precision.)#" 
          )
        .def("SetDoublePrecision",
             (void (Poly_ArrayOfUVNodes::*)( bool  ) ) static_cast<void (Poly_ArrayOfUVNodes::*)( bool  ) >(&Poly_ArrayOfUVNodes::SetDoublePrecision),
             R"#(Sets if array should define nodes with double or single precision. Raises exception if array was already allocated.)#"  , py::arg("theIsDouble")
          )
        .def("Assign",
             (Poly_ArrayOfUVNodes & (Poly_ArrayOfUVNodes::*)( const Poly_ArrayOfUVNodes &  ) ) static_cast<Poly_ArrayOfUVNodes & (Poly_ArrayOfUVNodes::*)( const Poly_ArrayOfUVNodes &  ) >(&Poly_ArrayOfUVNodes::Assign),
             R"#(Copies data of theOther array to this. The arrays should have the same length, but may have different precision / number of components (data conversion will be applied in the latter case).)#"  , py::arg("theOther")
          )
        .def("Move",
             (Poly_ArrayOfUVNodes & (Poly_ArrayOfUVNodes::*)( Poly_ArrayOfUVNodes &  ) ) static_cast<Poly_ArrayOfUVNodes & (Poly_ArrayOfUVNodes::*)( Poly_ArrayOfUVNodes &  ) >(&Poly_ArrayOfUVNodes::Move),
             R"#(Move assignment.)#"  , py::arg("theOther")
          )
        .def("Value",
             (gp_Pnt2d (Poly_ArrayOfUVNodes::*)( Standard_Integer  ) const) static_cast<gp_Pnt2d (Poly_ArrayOfUVNodes::*)( Standard_Integer  ) const>(&Poly_ArrayOfUVNodes::Value),
             R"#(A generalized accessor to point.)#"  , py::arg("theIndex")
          )
        .def("SetValue",
             (void (Poly_ArrayOfUVNodes::*)( Standard_Integer ,  const gp_Pnt2d &  ) ) static_cast<void (Poly_ArrayOfUVNodes::*)( Standard_Integer ,  const gp_Pnt2d &  ) >(&Poly_ArrayOfUVNodes::SetValue),
             R"#(A generalized setter for point.)#"  , py::arg("theIndex"),  py::arg("theValue")
          )
        .def("Value",
             (gp_Pnt2d (Poly_ArrayOfUVNodes::*)( Standard_Integer  ) const) static_cast<gp_Pnt2d (Poly_ArrayOfUVNodes::*)( Standard_Integer  ) const>(&Poly_ArrayOfUVNodes::Value),
             R"#(A generalized accessor to point.)#"  , py::arg("theIndex")
          )
        .def("SetValue",
             (void (Poly_ArrayOfUVNodes::*)( Standard_Integer ,  const gp_Pnt2d &  ) ) static_cast<void (Poly_ArrayOfUVNodes::*)( Standard_Integer ,  const gp_Pnt2d &  ) >(&Poly_ArrayOfUVNodes::SetValue),
             R"#(A generalized setter for point.)#"  , py::arg("theIndex"),  py::arg("theValue")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Poly_CoherentLink from ./opencascade/Poly_CoherentLink.hxx
    klass = m.attr("Poly_CoherentLink");


    // nested enums

    static_cast<py::class_<Poly_CoherentLink , shared_ptr<Poly_CoherentLink>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Integer,const Standard_Integer >()  , py::arg("iNode0"),  py::arg("iNode1") )
        .def(py::init< const Poly_CoherentTriangle &,Standard_Integer >()  , py::arg("theTri"),  py::arg("iSide") )
    // custom constructors
    // methods
        .def("Node",
             (Standard_Integer (Poly_CoherentLink::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (Poly_CoherentLink::*)( const Standard_Integer  ) const>(&Poly_CoherentLink::Node),
             R"#(Return the node index in the current triangulation.)#"  , py::arg("ind")
          )
        .def("OppositeNode",
             (Standard_Integer (Poly_CoherentLink::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (Poly_CoherentLink::*)( const Standard_Integer  ) const>(&Poly_CoherentLink::OppositeNode),
             R"#(Return the opposite node (belonging to the left or right incident triangle) index in the current triangulation.)#"  , py::arg("ind")
          )
        .def("GetAttribute",
             (Standard_Address (Poly_CoherentLink::*)() const) static_cast<Standard_Address (Poly_CoherentLink::*)() const>(&Poly_CoherentLink::GetAttribute),
             R"#(Query the attribute of the Link.)#" 
          )
        .def("SetAttribute",
             (void (Poly_CoherentLink::*)( const Standard_Address  ) ) static_cast<void (Poly_CoherentLink::*)( const Standard_Address  ) >(&Poly_CoherentLink::SetAttribute),
             R"#(Set the attribute of the Link.)#"  , py::arg("theAtt")
          )
        .def("IsEmpty",
             (Standard_Boolean (Poly_CoherentLink::*)() const) static_cast<Standard_Boolean (Poly_CoherentLink::*)() const>(&Poly_CoherentLink::IsEmpty),
             R"#(Query the status of the link - if it is an invalid one. An invalid link has Node members equal to -1.)#" 
          )
        .def("Nullify",
             (void (Poly_CoherentLink::*)() ) static_cast<void (Poly_CoherentLink::*)() >(&Poly_CoherentLink::Nullify),
             R"#(Invalidate this Link.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Poly_CoherentNode from ./opencascade/Poly_CoherentNode.hxx
    klass = m.attr("Poly_CoherentNode");


    // nested enums

    static_cast<py::class_<Poly_CoherentNode , shared_ptr<Poly_CoherentNode>  , gp_XYZ >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const gp_XYZ & >()  , py::arg("thePnt") )
    // custom constructors
    // methods
        .def("SetUV",
             (void (Poly_CoherentNode::*)( const Standard_Real ,  const Standard_Real  ) ) static_cast<void (Poly_CoherentNode::*)( const Standard_Real ,  const Standard_Real  ) >(&Poly_CoherentNode::SetUV),
             R"#(Set the UV coordinates of the Node.)#"  , py::arg("theU"),  py::arg("theV")
          )
        .def("GetU",
             (Standard_Real (Poly_CoherentNode::*)() const) static_cast<Standard_Real (Poly_CoherentNode::*)() const>(&Poly_CoherentNode::GetU),
             R"#(Get U coordinate of the Node.)#" 
          )
        .def("GetV",
             (Standard_Real (Poly_CoherentNode::*)() const) static_cast<Standard_Real (Poly_CoherentNode::*)() const>(&Poly_CoherentNode::GetV),
             R"#(Get V coordinate of the Node.)#" 
          )
        .def("SetNormal",
             (void (Poly_CoherentNode::*)( const gp_XYZ &  ) ) static_cast<void (Poly_CoherentNode::*)( const gp_XYZ &  ) >(&Poly_CoherentNode::SetNormal),
             R"#(Define the normal vector in the Node.)#"  , py::arg("theVector")
          )
        .def("HasNormal",
             (Standard_Boolean (Poly_CoherentNode::*)() const) static_cast<Standard_Boolean (Poly_CoherentNode::*)() const>(&Poly_CoherentNode::HasNormal),
             R"#(Query if the Node contains a normal vector.)#" 
          )
        .def("GetNormal",
             (gp_XYZ (Poly_CoherentNode::*)() const) static_cast<gp_XYZ (Poly_CoherentNode::*)() const>(&Poly_CoherentNode::GetNormal),
             R"#(Get the stored normal in the node.)#" 
          )
        .def("SetIndex",
             (void (Poly_CoherentNode::*)( const Standard_Integer  ) ) static_cast<void (Poly_CoherentNode::*)( const Standard_Integer  ) >(&Poly_CoherentNode::SetIndex),
             R"#(Set the value of node Index.)#"  , py::arg("theIndex")
          )
        .def("GetIndex",
             (Standard_Integer (Poly_CoherentNode::*)() const) static_cast<Standard_Integer (Poly_CoherentNode::*)() const>(&Poly_CoherentNode::GetIndex),
             R"#(Get the value of node Index.)#" 
          )
        .def("IsFreeNode",
             (Standard_Boolean (Poly_CoherentNode::*)() const) static_cast<Standard_Boolean (Poly_CoherentNode::*)() const>(&Poly_CoherentNode::IsFreeNode),
             R"#(Check if this is a free node, i.e., a node without a single incident triangle.)#" 
          )
        .def("Clear",
             (void (Poly_CoherentNode::*)( const opencascade::handle<NCollection_BaseAllocator> &  ) ) static_cast<void (Poly_CoherentNode::*)( const opencascade::handle<NCollection_BaseAllocator> &  ) >(&Poly_CoherentNode::Clear),
             R"#(Reset the Node to void.)#"  , py::arg("arg")
          )
        .def("AddTriangle",
             (void (Poly_CoherentNode::*)( const Poly_CoherentTriangle & ,  const opencascade::handle<NCollection_BaseAllocator> &  ) ) static_cast<void (Poly_CoherentNode::*)( const Poly_CoherentTriangle & ,  const opencascade::handle<NCollection_BaseAllocator> &  ) >(&Poly_CoherentNode::AddTriangle),
             R"#(Connect a triangle to this Node.)#"  , py::arg("theTri"),  py::arg("theA")
          )
        .def("RemoveTriangle",
             (Standard_Boolean (Poly_CoherentNode::*)( const Poly_CoherentTriangle & ,  const opencascade::handle<NCollection_BaseAllocator> &  ) ) static_cast<Standard_Boolean (Poly_CoherentNode::*)( const Poly_CoherentTriangle & ,  const opencascade::handle<NCollection_BaseAllocator> &  ) >(&Poly_CoherentNode::RemoveTriangle),
             R"#(Disconnect a triangle from this Node.)#"  , py::arg("theTri"),  py::arg("theA")
          )
        .def("TriangleIterator",
             (Poly_CoherentTriPtr::Iterator (Poly_CoherentNode::*)() const) static_cast<Poly_CoherentTriPtr::Iterator (Poly_CoherentNode::*)() const>(&Poly_CoherentNode::TriangleIterator),
             R"#(Create an iterator of incident triangles.)#" 
          )
        .def("Dump",
             (void (Poly_CoherentNode::*)( std::ostream &  ) const) static_cast<void (Poly_CoherentNode::*)( std::ostream &  ) const>(&Poly_CoherentNode::Dump),
             R"#(None)#"  , py::arg("theStream")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Poly_CoherentTriangle from ./opencascade/Poly_CoherentTriangle.hxx
    klass = m.attr("Poly_CoherentTriangle");


    // nested enums

    static_cast<py::class_<Poly_CoherentTriangle , shared_ptr<Poly_CoherentTriangle>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Integer,const Standard_Integer,const Standard_Integer >()  , py::arg("iNode0"),  py::arg("iNode1"),  py::arg("iNode2") )
    // custom constructors
    // methods
        .def("Node",
             (Standard_Integer (Poly_CoherentTriangle::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (Poly_CoherentTriangle::*)( const Standard_Integer  ) const>(&Poly_CoherentTriangle::Node),
             R"#(Query the node index in the position given by the parameter 'ind')#"  , py::arg("ind")
          )
        .def("IsEmpty",
             (Standard_Boolean (Poly_CoherentTriangle::*)() const) static_cast<Standard_Boolean (Poly_CoherentTriangle::*)() const>(&Poly_CoherentTriangle::IsEmpty),
             R"#(Query if this is a valid triangle.)#" 
          )
        .def("SetConnection",
             (Standard_Boolean (Poly_CoherentTriangle::*)( const Standard_Integer ,  Poly_CoherentTriangle &  ) ) static_cast<Standard_Boolean (Poly_CoherentTriangle::*)( const Standard_Integer ,  Poly_CoherentTriangle &  ) >(&Poly_CoherentTriangle::SetConnection),
             R"#(Create connection with another triangle theTri. This method creates both connections: in this triangle and in theTri. You do not need to call the same method on triangle theTr.)#"  , py::arg("iConn"),  py::arg("theTr")
          )
        .def("SetConnection",
             (Standard_Boolean (Poly_CoherentTriangle::*)( Poly_CoherentTriangle &  ) ) static_cast<Standard_Boolean (Poly_CoherentTriangle::*)( Poly_CoherentTriangle &  ) >(&Poly_CoherentTriangle::SetConnection),
             R"#(Create connection with another triangle theTri. This method creates both connections: in this triangle and in theTri. This method is slower than the previous one, because it makes analysis what sides of both triangles are connected.)#"  , py::arg("theTri")
          )
        .def("RemoveConnection",
             (void (Poly_CoherentTriangle::*)( const Standard_Integer  ) ) static_cast<void (Poly_CoherentTriangle::*)( const Standard_Integer  ) >(&Poly_CoherentTriangle::RemoveConnection),
             R"#(Remove the connection with the given index.)#"  , py::arg("iConn")
          )
        .def("RemoveConnection",
             (Standard_Boolean (Poly_CoherentTriangle::*)( Poly_CoherentTriangle &  ) ) static_cast<Standard_Boolean (Poly_CoherentTriangle::*)( Poly_CoherentTriangle &  ) >(&Poly_CoherentTriangle::RemoveConnection),
             R"#(Remove the connection with the given Triangle.)#"  , py::arg("theTri")
          )
        .def("NConnections",
             (Standard_Integer (Poly_CoherentTriangle::*)() const) static_cast<Standard_Integer (Poly_CoherentTriangle::*)() const>(&Poly_CoherentTriangle::NConnections),
             R"#(Query the number of connected triangles.)#" 
          )
        .def("GetConnectedNode",
             (Standard_Integer (Poly_CoherentTriangle::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (Poly_CoherentTriangle::*)( const Standard_Integer  ) const>(&Poly_CoherentTriangle::GetConnectedNode),
             R"#(Query the connected node on the given side. Returns -1 if there is no connection on the specified side.)#"  , py::arg("iConn")
          )
        .def("GetConnectedTri",
             (const Poly_CoherentTriangle * (Poly_CoherentTriangle::*)( const Standard_Integer  ) const) static_cast<const Poly_CoherentTriangle * (Poly_CoherentTriangle::*)( const Standard_Integer  ) const>(&Poly_CoherentTriangle::GetConnectedTri),
             R"#(Query the connected triangle on the given side. Returns NULL if there is no connection on the specified side.)#"  , py::arg("iConn")
          )
        .def("GetLink",
             (const Poly_CoherentLink * (Poly_CoherentTriangle::*)( const Standard_Integer  ) const) static_cast<const Poly_CoherentLink * (Poly_CoherentTriangle::*)( const Standard_Integer  ) const>(&Poly_CoherentTriangle::GetLink),
             R"#(Query the Link associate with the given side of the Triangle. May return NULL if there are no links in the triangulation.)#"  , py::arg("iLink")
          )
        .def("FindConnection",
             (Standard_Integer (Poly_CoherentTriangle::*)( const Poly_CoherentTriangle &  ) const) static_cast<Standard_Integer (Poly_CoherentTriangle::*)( const Poly_CoherentTriangle &  ) const>(&Poly_CoherentTriangle::FindConnection),
             R"#(Returns the index of the connection with the given triangle, or -1 if not found.)#"  , py::arg("arg")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Poly_CoherentTriangulation from ./opencascade/Poly_CoherentTriangulation.hxx
    klass = m.attr("Poly_CoherentTriangulation");


    // nested enums

    static_cast<py::class_<Poly_CoherentTriangulation ,opencascade::handle<Poly_CoherentTriangulation>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<NCollection_BaseAllocator> & >()  , py::arg("theAlloc")=static_cast<const opencascade::handle<NCollection_BaseAllocator> &>(0L) )
        .def(py::init< const opencascade::handle<Poly_Triangulation> &,const opencascade::handle<NCollection_BaseAllocator> & >()  , py::arg("theTriangulation"),  py::arg("theAlloc")=static_cast<const opencascade::handle<NCollection_BaseAllocator> &>(0L) )
    // custom constructors
    // methods
        .def("GetTriangulation",
             (opencascade::handle<Poly_Triangulation> (Poly_CoherentTriangulation::*)() const) static_cast<opencascade::handle<Poly_Triangulation> (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::GetTriangulation),
             R"#(Create an instance of Poly_Triangulation from this object.)#" 
          )
        .def("GetFreeNodes",
             (Standard_Boolean (Poly_CoherentTriangulation::*)( NCollection_List<Standard_Integer> &  ) const) static_cast<Standard_Boolean (Poly_CoherentTriangulation::*)( NCollection_List<Standard_Integer> &  ) const>(&Poly_CoherentTriangulation::GetFreeNodes),
             R"#(Create a list of free nodes. These nodes may appear as a result of any custom mesh decimation or RemoveDegenerated() call. This analysis is necessary if you support additional data structures based on the triangulation (e.g., edges on the surface boundary).)#"  , py::arg("lstNodes")
          )
        .def("MaxNode",
             (Standard_Integer (Poly_CoherentTriangulation::*)() const) static_cast<Standard_Integer (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::MaxNode),
             R"#(Query the index of the last node in the triangulation)#" 
          )
        .def("MaxTriangle",
             (Standard_Integer (Poly_CoherentTriangulation::*)() const) static_cast<Standard_Integer (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::MaxTriangle),
             R"#(Query the index of the last triangle in the triangulation)#" 
          )
        .def("SetDeflection",
             (void (Poly_CoherentTriangulation::*)( const Standard_Real  ) ) static_cast<void (Poly_CoherentTriangulation::*)( const Standard_Real  ) >(&Poly_CoherentTriangulation::SetDeflection),
             R"#(Set the Deflection value as the parameter of the given triangulation.)#"  , py::arg("theDefl")
          )
        .def("Deflection",
             (Standard_Real (Poly_CoherentTriangulation::*)() const) static_cast<Standard_Real (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::Deflection),
             R"#(Query the Deflection parameter (default value 0. -- if never initialized))#" 
          )
        .def("SetNode",
             (Standard_Integer (Poly_CoherentTriangulation::*)( const gp_XYZ & ,  const Standard_Integer  ) ) static_cast<Standard_Integer (Poly_CoherentTriangulation::*)( const gp_XYZ & ,  const Standard_Integer  ) >(&Poly_CoherentTriangulation::SetNode),
             R"#(Initialize a node)#"  , py::arg("thePnt"),  py::arg("iN")=static_cast<const Standard_Integer>(- 1)
          )
        .def("Node",
             (const Poly_CoherentNode & (Poly_CoherentTriangulation::*)( const Standard_Integer  ) const) static_cast<const Poly_CoherentNode & (Poly_CoherentTriangulation::*)( const Standard_Integer  ) const>(&Poly_CoherentTriangulation::Node),
             R"#(Get the node at the given index 'i'.)#"  , py::arg("i")
          )
        .def("ChangeNode",
             (Poly_CoherentNode & (Poly_CoherentTriangulation::*)( const Standard_Integer  ) ) static_cast<Poly_CoherentNode & (Poly_CoherentTriangulation::*)( const Standard_Integer  ) >(&Poly_CoherentTriangulation::ChangeNode),
             R"#(Get the node at the given index 'i'.)#"  , py::arg("i")
          )
        .def("NNodes",
             (Standard_Integer (Poly_CoherentTriangulation::*)() const) static_cast<Standard_Integer (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::NNodes),
             R"#(Query the total number of active nodes (i.e. nodes used by 1 or more triangles))#" 
          )
        .def("Triangle",
             (const Poly_CoherentTriangle & (Poly_CoherentTriangulation::*)( const Standard_Integer  ) const) static_cast<const Poly_CoherentTriangle & (Poly_CoherentTriangulation::*)( const Standard_Integer  ) const>(&Poly_CoherentTriangulation::Triangle),
             R"#(Get the triangle at the given index 'i'.)#"  , py::arg("i")
          )
        .def("NTriangles",
             (Standard_Integer (Poly_CoherentTriangulation::*)() const) static_cast<Standard_Integer (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::NTriangles),
             R"#(Query the total number of active triangles (i.e. triangles that refer nodes, non-empty ones))#" 
          )
        .def("NLinks",
             (Standard_Integer (Poly_CoherentTriangulation::*)() const) static_cast<Standard_Integer (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::NLinks),
             R"#(Query the total number of active Links.)#" 
          )
        .def("RemoveTriangle",
             (Standard_Boolean (Poly_CoherentTriangulation::*)( Poly_CoherentTriangle &  ) ) static_cast<Standard_Boolean (Poly_CoherentTriangulation::*)( Poly_CoherentTriangle &  ) >(&Poly_CoherentTriangulation::RemoveTriangle),
             R"#(Removal of a single triangle from the triangulation.)#"  , py::arg("theTr")
          )
        .def("RemoveLink",
             (void (Poly_CoherentTriangulation::*)( Poly_CoherentLink &  ) ) static_cast<void (Poly_CoherentTriangulation::*)( Poly_CoherentLink &  ) >(&Poly_CoherentTriangulation::RemoveLink),
             R"#(Removal of a single link from the triangulation.)#"  , py::arg("theLink")
          )
        .def("AddTriangle",
             (Poly_CoherentTriangle * (Poly_CoherentTriangulation::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<Poly_CoherentTriangle * (Poly_CoherentTriangulation::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) >(&Poly_CoherentTriangulation::AddTriangle),
             R"#(Add a triangle to the triangulation.)#"  , py::arg("iNode0"),  py::arg("iNode1"),  py::arg("iNode2")
          )
        .def("ReplaceNodes",
             (Standard_Boolean (Poly_CoherentTriangulation::*)( Poly_CoherentTriangle & ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (Poly_CoherentTriangulation::*)( Poly_CoherentTriangle & ,  const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) >(&Poly_CoherentTriangulation::ReplaceNodes),
             R"#(Replace nodes in the given triangle.)#"  , py::arg("theTriangle"),  py::arg("iNode0"),  py::arg("iNode1"),  py::arg("iNode2")
          )
        .def("AddLink",
             (Poly_CoherentLink * (Poly_CoherentTriangulation::*)( const Poly_CoherentTriangle & ,  const Standard_Integer  ) ) static_cast<Poly_CoherentLink * (Poly_CoherentTriangulation::*)( const Poly_CoherentTriangle & ,  const Standard_Integer  ) >(&Poly_CoherentTriangulation::AddLink),
             R"#(Add a single link to triangulation, based on a triangle and its side index. This method does not check for coincidence with already present links.)#"  , py::arg("theTri"),  py::arg("theConn")
          )
        .def("ComputeLinks",
             (Standard_Integer (Poly_CoherentTriangulation::*)() ) static_cast<Standard_Integer (Poly_CoherentTriangulation::*)() >(&Poly_CoherentTriangulation::ComputeLinks),
             R"#((Re)Calculate all links in this Triangulation.)#" 
          )
        .def("ClearLinks",
             (void (Poly_CoherentTriangulation::*)() ) static_cast<void (Poly_CoherentTriangulation::*)() >(&Poly_CoherentTriangulation::ClearLinks),
             R"#(Clear all Links data from the Triangulation data.)#" 
          )
        .def("Clone",
             (opencascade::handle<Poly_CoherentTriangulation> (Poly_CoherentTriangulation::*)( const opencascade::handle<NCollection_BaseAllocator> &  ) const) static_cast<opencascade::handle<Poly_CoherentTriangulation> (Poly_CoherentTriangulation::*)( const opencascade::handle<NCollection_BaseAllocator> &  ) const>(&Poly_CoherentTriangulation::Clone),
             R"#(Create a copy of this Triangulation, using the given allocator.)#"  , py::arg("theAlloc")
          )
        .def("Dump",
             (void (Poly_CoherentTriangulation::*)( std::ostream &  ) const) static_cast<void (Poly_CoherentTriangulation::*)( std::ostream &  ) const>(&Poly_CoherentTriangulation::Dump),
             R"#(Debugging output.)#"  , py::arg("arg")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_CoherentTriangulation::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_CoherentTriangulation::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Allocator",
             (const opencascade::handle<NCollection_BaseAllocator> & (Poly_CoherentTriangulation::*)() const) static_cast<const opencascade::handle<NCollection_BaseAllocator> & (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::Allocator),
             R"#(Query the allocator of elements, this allocator can be used for other objects)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_CoherentTriangulation::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_CoherentTriangulation::*)() const>(&Poly_CoherentTriangulation::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Poly_Connect from ./opencascade/Poly_Connect.hxx
    klass = m.attr("Poly_Connect");


    // nested enums

    static_cast<py::class_<Poly_Connect , shared_ptr<Poly_Connect>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Poly_Triangulation> & >()  , py::arg("theTriangulation") )
    // custom constructors
    // methods
        .def("Load",
             (void (Poly_Connect::*)( const opencascade::handle<Poly_Triangulation> &  ) ) static_cast<void (Poly_Connect::*)( const opencascade::handle<Poly_Triangulation> &  ) >(&Poly_Connect::Load),
             R"#(Initialize the algorithm to explore the adjacency data of nodes or triangles for the triangulation theTriangulation.)#"  , py::arg("theTriangulation")
          )
        .def("Triangle",
             (Standard_Integer (Poly_Connect::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (Poly_Connect::*)( const Standard_Integer  ) const>(&Poly_Connect::Triangle),
             R"#(Returns the index of a triangle containing the node at index N in the nodes table specific to the triangulation analyzed by this tool)#"  , py::arg("N")
          )
        .def("Initialize",
             (void (Poly_Connect::*)( const Standard_Integer  ) ) static_cast<void (Poly_Connect::*)( const Standard_Integer  ) >(&Poly_Connect::Initialize),
             R"#(Initializes an iterator to search for all the triangles containing the node referenced at index N in the nodes table, for the triangulation analyzed by this tool. The iterator is managed by the following functions: - More, which checks if there are still elements in the iterator - Next, which positions the iterator on the next element - Value, which returns the current element. The use of such an iterator provides direct access to the triangles around a particular node, i.e. it avoids iterating on all the component triangles of a triangulation. Example Poly_Connect C(Tr); for (C.Initialize(n1);C.More();C.Next()) { t = C.Value(); })#"  , py::arg("N")
          )
        .def("More",
             (Standard_Boolean (Poly_Connect::*)() const) static_cast<Standard_Boolean (Poly_Connect::*)() const>(&Poly_Connect::More),
             R"#(Returns true if there is another element in the iterator defined with the function Initialize (i.e. if there is another triangle containing the given node).)#" 
          )
        .def("Next",
             (void (Poly_Connect::*)() ) static_cast<void (Poly_Connect::*)() >(&Poly_Connect::Next),
             R"#(Advances the iterator defined with the function Initialize to access the next triangle. Note: There is no action if the iterator is empty (i.e. if the function More returns false).-)#" 
          )
        .def("Value",
             (Standard_Integer (Poly_Connect::*)() const) static_cast<Standard_Integer (Poly_Connect::*)() const>(&Poly_Connect::Value),
             R"#(Returns the index of the current triangle to which the iterator, defined with the function Initialize, points. This is an index in the triangles table specific to the triangulation analyzed by this tool)#" 
          )
    // methods using call by reference i.s.o. return
        .def("Triangles",
             []( Poly_Connect &self , const Standard_Integer T ){
                 Standard_Integer  t1;
                Standard_Integer  t2;
                Standard_Integer  t3;

                 self.Triangles(T,t1,t2,t3);
                 
                 return std::make_tuple(t1,t2,t3); },
             R"#(Returns in t1, t2 and t3, the indices of the 3 triangles adjacent to the triangle at index T in the triangles table specific to the triangulation analyzed by this tool. Warning Null indices are returned when there are fewer than 3 adjacent triangles.)#"  , py::arg("T")
          )
        .def("Nodes",
             []( Poly_Connect &self , const Standard_Integer T ){
                 Standard_Integer  n1;
                Standard_Integer  n2;
                Standard_Integer  n3;

                 self.Nodes(T,n1,n2,n3);
                 
                 return std::make_tuple(n1,n2,n3); },
             R"#(Returns, in n1, n2 and n3, the indices of the 3 nodes adjacent to the triangle referenced at index T in the triangles table specific to the triangulation analyzed by this tool. Warning Null indices are returned when there are fewer than 3 adjacent nodes.)#"  , py::arg("T")
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Triangulation",
             (const opencascade::handle<Poly_Triangulation> & (Poly_Connect::*)() const) static_cast<const opencascade::handle<Poly_Triangulation> & (Poly_Connect::*)() const>(&Poly_Connect::Triangulation),
             R"#(Returns the triangulation analyzed by this tool.)#"
             
         )
;

    // Class Poly_HArray1OfTriangle from ./opencascade/Poly_HArray1OfTriangle.hxx
    klass = m.attr("Poly_HArray1OfTriangle");


    // nested enums

    static_cast<py::class_<Poly_HArray1OfTriangle ,opencascade::handle<Poly_HArray1OfTriangle>  , Poly_Array1OfTriangle , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Integer,const Standard_Integer >()  , py::arg("theLower"),  py::arg("theUpper") )
        .def(py::init< const Standard_Integer,const Standard_Integer, const Poly_Triangle & >()  , py::arg("theLower"),  py::arg("theUpper"),  py::arg("theValue") )
        .def(py::init<  const Poly_Triangle &,const Standard_Integer,const Standard_Integer,const bool >()  , py::arg("theBegin"),  py::arg("theLower"),  py::arg("theUpper"),  py::arg("arg") )
        .def(py::init<  const NCollection_Array1<Poly_Triangle> & >()  , py::arg("theOther") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_HArray1OfTriangle::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_HArray1OfTriangle::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Array1",
             (const Poly_Array1OfTriangle & (Poly_HArray1OfTriangle::*)() const) static_cast<const Poly_Array1OfTriangle & (Poly_HArray1OfTriangle::*)() const>(&Poly_HArray1OfTriangle::Array1),
             R"#(None)#"
             
         )
       .def("ChangeArray1",
             (Poly_Array1OfTriangle & (Poly_HArray1OfTriangle::*)() ) static_cast<Poly_Array1OfTriangle & (Poly_HArray1OfTriangle::*)() >(&Poly_HArray1OfTriangle::ChangeArray1),
             R"#(None)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_HArray1OfTriangle::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_HArray1OfTriangle::*)() const>(&Poly_HArray1OfTriangle::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Poly_MergeNodesTool from ./opencascade/Poly_MergeNodesTool.hxx
    klass = m.attr("Poly_MergeNodesTool");


    // nested enums

    static_cast<py::class_<Poly_MergeNodesTool ,opencascade::handle<Poly_MergeNodesTool>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const double,const double,const int >()  , py::arg("theSmoothAngle"),  py::arg("theMergeTolerance")=static_cast<const double>(0.0),  py::arg("theNbFacets")=static_cast<const int>(- 1) )
    // custom constructors
    // methods
        .def("MergeTolerance",
             (double (Poly_MergeNodesTool::*)() const) static_cast<double (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::MergeTolerance),
             R"#(Return merge tolerance; 0.0 by default (only 3D points with exactly matching coordinates are merged).)#" 
          )
        .def("SetMergeTolerance",
             (void (Poly_MergeNodesTool::*)( double  ) ) static_cast<void (Poly_MergeNodesTool::*)( double  ) >(&Poly_MergeNodesTool::SetMergeTolerance),
             R"#(Set merge tolerance.)#"  , py::arg("theTolerance")
          )
        .def("MergeAngle",
             (double (Poly_MergeNodesTool::*)() const) static_cast<double (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::MergeAngle),
             R"#(Return merge angle in radians; 0.0 by default (normals with non-exact directions are not merged).)#" 
          )
        .def("SetMergeAngle",
             (void (Poly_MergeNodesTool::*)( double  ) ) static_cast<void (Poly_MergeNodesTool::*)( double  ) >(&Poly_MergeNodesTool::SetMergeAngle),
             R"#(Set merge angle.)#"  , py::arg("theAngleRad")
          )
        .def("ToMergeOpposite",
             (bool (Poly_MergeNodesTool::*)() const) static_cast<bool (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::ToMergeOpposite),
             R"#(Return TRUE if nodes with opposite normals should be merged; FALSE by default.)#" 
          )
        .def("SetMergeOpposite",
             (void (Poly_MergeNodesTool::*)( bool  ) ) static_cast<void (Poly_MergeNodesTool::*)( bool  ) >(&Poly_MergeNodesTool::SetMergeOpposite),
             R"#(Set if nodes with opposite normals should be merged.)#"  , py::arg("theToMerge")
          )
        .def("SetUnitFactor",
             (void (Poly_MergeNodesTool::*)( double  ) ) static_cast<void (Poly_MergeNodesTool::*)( double  ) >(&Poly_MergeNodesTool::SetUnitFactor),
             R"#(Setup unit factor.)#"  , py::arg("theUnitFactor")
          )
        .def("ToDropDegenerative",
             (bool (Poly_MergeNodesTool::*)() const) static_cast<bool (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::ToDropDegenerative),
             R"#(Return TRUE if degenerate elements should be discarded; TRUE by default.)#" 
          )
        .def("SetDropDegenerative",
             (void (Poly_MergeNodesTool::*)( bool  ) ) static_cast<void (Poly_MergeNodesTool::*)( bool  ) >(&Poly_MergeNodesTool::SetDropDegenerative),
             R"#(Set if degenerate elements should be discarded.)#"  , py::arg("theToDrop")
          )
        .def("ToMergeElems",
             (bool (Poly_MergeNodesTool::*)() const) static_cast<bool (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::ToMergeElems),
             R"#(Return TRUE if equal elements should be filtered; FALSE by default.)#" 
          )
        .def("SetMergeElems",
             (void (Poly_MergeNodesTool::*)( bool  ) ) static_cast<void (Poly_MergeNodesTool::*)( bool  ) >(&Poly_MergeNodesTool::SetMergeElems),
             R"#(Set if equal elements should be filtered.)#"  , py::arg("theToMerge")
          )
        .def("computeTriNormal",
             (NCollection_Vec3<float> (Poly_MergeNodesTool::*)() const) static_cast<NCollection_Vec3<float> (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::computeTriNormal),
             R"#(Compute normal for the mesh element.)#" 
          )
        .def("AddTriangulation",
             (void (Poly_MergeNodesTool::*)( const opencascade::handle<Poly_Triangulation> & ,  const gp_Trsf & ,  const Standard_Boolean  ) ) static_cast<void (Poly_MergeNodesTool::*)( const opencascade::handle<Poly_Triangulation> & ,  const gp_Trsf & ,  const Standard_Boolean  ) >(&Poly_MergeNodesTool::AddTriangulation),
             R"#(Add another triangulation to created one.)#"  , py::arg("theTris"),  py::arg("theTrsf")=static_cast<const gp_Trsf &>(gp_Trsf ( )),  py::arg("theToReverse")=static_cast<const Standard_Boolean>(false)
          )
        .def("Result",
             (opencascade::handle<Poly_Triangulation> (Poly_MergeNodesTool::*)() ) static_cast<opencascade::handle<Poly_Triangulation> (Poly_MergeNodesTool::*)() >(&Poly_MergeNodesTool::Result),
             R"#(Prepare and return result triangulation (temporary data will be truncated to result size).)#" 
          )
        .def("AddTriangle",
             (void (Poly_MergeNodesTool::*)( const gp_XYZ[3]  ) ) static_cast<void (Poly_MergeNodesTool::*)( const gp_XYZ[3]  ) >(&Poly_MergeNodesTool::AddTriangle),
             R"#(Add new triangle.)#"  , py::arg("theElemNodes")
          )
        .def("AddQuad",
             (void (Poly_MergeNodesTool::*)( const gp_XYZ[4]  ) ) static_cast<void (Poly_MergeNodesTool::*)( const gp_XYZ[4]  ) >(&Poly_MergeNodesTool::AddQuad),
             R"#(Add new quad.)#"  , py::arg("theElemNodes")
          )
        .def("AddElement",
             (void (Poly_MergeNodesTool::*)( const gp_XYZ * ,  int  ) ) static_cast<void (Poly_MergeNodesTool::*)( const gp_XYZ * ,  int  ) >(&Poly_MergeNodesTool::AddElement),
             R"#(Add new triangle or quad.)#"  , py::arg("theElemNodes"),  py::arg("theNbNodes")
          )
        .def("ChangeElementNode",
             (gp_XYZ & (Poly_MergeNodesTool::*)( int  ) ) static_cast<gp_XYZ & (Poly_MergeNodesTool::*)( int  ) >(&Poly_MergeNodesTool::ChangeElementNode),
             R"#(Change node coordinates of element to be pushed.)#"  , py::arg("theIndex")
          )
        .def("PushLastElement",
             (void (Poly_MergeNodesTool::*)( int  ) ) static_cast<void (Poly_MergeNodesTool::*)( int  ) >(&Poly_MergeNodesTool::PushLastElement),
             R"#(Add new triangle or quad with nodes specified by ChangeElementNode().)#"  , py::arg("theNbNodes")
          )
        .def("PushLastTriangle",
             (void (Poly_MergeNodesTool::*)() ) static_cast<void (Poly_MergeNodesTool::*)() >(&Poly_MergeNodesTool::PushLastTriangle),
             R"#(Add new triangle with nodes specified by ChangeElementNode().)#" 
          )
        .def("PushLastQuad",
             (void (Poly_MergeNodesTool::*)() ) static_cast<void (Poly_MergeNodesTool::*)() >(&Poly_MergeNodesTool::PushLastQuad),
             R"#(Add new quad with nodes specified by ChangeElementNode().)#" 
          )
        .def("ElementNodeIndex",
             (Standard_Integer (Poly_MergeNodesTool::*)( int  ) const) static_cast<Standard_Integer (Poly_MergeNodesTool::*)( int  ) const>(&Poly_MergeNodesTool::ElementNodeIndex),
             R"#(Return current element node index defined by PushLastElement().)#"  , py::arg("theIndex")
          )
        .def("NbNodes",
             (int (Poly_MergeNodesTool::*)() const) static_cast<int (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::NbNodes),
             R"#(Return number of nodes.)#" 
          )
        .def("NbElements",
             (int (Poly_MergeNodesTool::*)() const) static_cast<int (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::NbElements),
             R"#(Return number of elements.)#" 
          )
        .def("NbDegenerativeElems",
             (int (Poly_MergeNodesTool::*)() const) static_cast<int (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::NbDegenerativeElems),
             R"#(Return number of discarded degenerate elements.)#" 
          )
        .def("NbMergedElems",
             (int (Poly_MergeNodesTool::*)() const) static_cast<int (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::NbMergedElems),
             R"#(Return number of merged equal elements.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_MergeNodesTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_MergeNodesTool::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("MergeNodes_s",
                    (opencascade::handle<Poly_Triangulation> (*)( const opencascade::handle<Poly_Triangulation> & ,  const gp_Trsf & ,  const Standard_Boolean ,  const double ,  const double ,  const bool  ) ) static_cast<opencascade::handle<Poly_Triangulation> (*)( const opencascade::handle<Poly_Triangulation> & ,  const gp_Trsf & ,  const Standard_Boolean ,  const double ,  const double ,  const bool  ) >(&Poly_MergeNodesTool::MergeNodes),
                    R"#(Merge nodes of existing mesh and return the new mesh.)#"  , py::arg("theTris"),  py::arg("theTrsf"),  py::arg("theToReverse"),  py::arg("theSmoothAngle"),  py::arg("theMergeTolerance")=static_cast<const double>(0.0),  py::arg("theToForce")=static_cast<const bool>(true)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_MergeNodesTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_MergeNodesTool::*)() const>(&Poly_MergeNodesTool::DynamicType),
             R"#(None)#"
             
         )
       .def("ChangeOutput",
             (opencascade::handle<Poly_Triangulation> & (Poly_MergeNodesTool::*)() ) static_cast<opencascade::handle<Poly_Triangulation> & (Poly_MergeNodesTool::*)() >(&Poly_MergeNodesTool::ChangeOutput),
             R"#(Setup output triangulation for modifications. When set to NULL, the tool could be used as a merge map for filling in external mesh structure.)#"
             
         )
;

    // Class Poly_Polygon2D from ./opencascade/Poly_Polygon2D.hxx
    klass = m.attr("Poly_Polygon2D");


    // nested enums

    static_cast<py::class_<Poly_Polygon2D ,opencascade::handle<Poly_Polygon2D>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const Standard_Integer >()  , py::arg("theNbNodes") )
        .def(py::init<  const NCollection_Array1<gp_Pnt2d> & >()  , py::arg("Nodes") )
    // custom constructors
    // methods
        .def("Deflection",
             (Standard_Real (Poly_Polygon2D::*)() const) static_cast<Standard_Real (Poly_Polygon2D::*)() const>(&Poly_Polygon2D::Deflection),
             R"#(Returns the deflection of this polygon. Deflection is used in cases where the polygon is an approximate representation of a curve. Deflection represents the maximum distance permitted between any point on the curve and the corresponding point on the polygon. By default the deflection value is equal to 0. An algorithm using this 2D polygon with a deflection value equal to 0 considers that it is working with a true polygon and not with an approximate representation of a curve. The Deflection function is used to modify the deflection value of this polygon. The deflection value can be used by any algorithm working with 2D polygons. For example: - An algorithm may use a unique deflection value for all its polygons. In this case it is not necessary to use the Deflection function. - Or an algorithm may want to attach a different deflection to each polygon. In this case, the Deflection function is used to set a value on each polygon, and later to fetch the value.)#" 
          )
        .def("Deflection",
             (void (Poly_Polygon2D::*)( const Standard_Real  ) ) static_cast<void (Poly_Polygon2D::*)( const Standard_Real  ) >(&Poly_Polygon2D::Deflection),
             R"#(Sets the deflection of this polygon.)#"  , py::arg("theDefl")
          )
        .def("NbNodes",
             (Standard_Integer (Poly_Polygon2D::*)() const) static_cast<Standard_Integer (Poly_Polygon2D::*)() const>(&Poly_Polygon2D::NbNodes),
             R"#(Returns the number of nodes in this polygon. Note: If the polygon is closed, the point of closure is repeated at the end of its table of nodes. Thus, on a closed triangle, the function NbNodes returns 4.)#" 
          )
        .def("DumpJson",
             (void (Poly_Polygon2D::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Poly_Polygon2D::*)( std::ostream & ,  Standard_Integer  ) const>(&Poly_Polygon2D::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_Polygon2D::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_Polygon2D::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Nodes",
             (const TColgp_Array1OfPnt2d & (Poly_Polygon2D::*)() const) static_cast<const TColgp_Array1OfPnt2d & (Poly_Polygon2D::*)() const>(&Poly_Polygon2D::Nodes),
             R"#(Returns the table of nodes for this polygon.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeNodes",
             (TColgp_Array1OfPnt2d & (Poly_Polygon2D::*)() ) static_cast<TColgp_Array1OfPnt2d & (Poly_Polygon2D::*)() >(&Poly_Polygon2D::ChangeNodes),
             R"#(Returns the table of nodes for this polygon.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_Polygon2D::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_Polygon2D::*)() const>(&Poly_Polygon2D::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Poly_Polygon3D from ./opencascade/Poly_Polygon3D.hxx
    klass = m.attr("Poly_Polygon3D");


    // nested enums

    static_cast<py::class_<Poly_Polygon3D ,opencascade::handle<Poly_Polygon3D>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const Standard_Integer,const Standard_Boolean >()  , py::arg("theNbNodes"),  py::arg("theHasParams") )
        .def(py::init<  const NCollection_Array1<gp_Pnt> & >()  , py::arg("Nodes") )
        .def(py::init<  const NCollection_Array1<gp_Pnt> &, const NCollection_Array1<Standard_Real> & >()  , py::arg("Nodes"),  py::arg("Parameters") )
    // custom constructors
    // methods
        .def("Copy",
             (opencascade::handle<Poly_Polygon3D> (Poly_Polygon3D::*)() const) static_cast<opencascade::handle<Poly_Polygon3D> (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::Copy),
             R"#(Creates a copy of current polygon)#" 
          )
        .def("Deflection",
             (Standard_Real (Poly_Polygon3D::*)() const) static_cast<Standard_Real (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::Deflection),
             R"#(Returns the deflection of this polygon)#" 
          )
        .def("Deflection",
             (void (Poly_Polygon3D::*)( const Standard_Real  ) ) static_cast<void (Poly_Polygon3D::*)( const Standard_Real  ) >(&Poly_Polygon3D::Deflection),
             R"#(Sets the deflection of this polygon. See more on deflection in Poly_Polygon2D)#"  , py::arg("theDefl")
          )
        .def("NbNodes",
             (Standard_Integer (Poly_Polygon3D::*)() const) static_cast<Standard_Integer (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::NbNodes),
             R"#(Returns the number of nodes in this polygon. Note: If the polygon is closed, the point of closure is repeated at the end of its table of nodes. Thus, on a closed triangle the function NbNodes returns 4.)#" 
          )
        .def("HasParameters",
             (Standard_Boolean (Poly_Polygon3D::*)() const) static_cast<Standard_Boolean (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::HasParameters),
             R"#(Returns the table of the parameters associated with each node in this polygon. HasParameters function checks if parameters are associated with the nodes of this polygon.)#" 
          )
        .def("DumpJson",
             (void (Poly_Polygon3D::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Poly_Polygon3D::*)( std::ostream & ,  Standard_Integer  ) const>(&Poly_Polygon3D::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_Polygon3D::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_Polygon3D::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Nodes",
             (const TColgp_Array1OfPnt & (Poly_Polygon3D::*)() const) static_cast<const TColgp_Array1OfPnt & (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::Nodes),
             R"#(Returns the table of nodes for this polygon.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeNodes",
             (TColgp_Array1OfPnt & (Poly_Polygon3D::*)() ) static_cast<TColgp_Array1OfPnt & (Poly_Polygon3D::*)() >(&Poly_Polygon3D::ChangeNodes),
             R"#(Returns the table of nodes for this polygon.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Parameters",
             (const TColStd_Array1OfReal & (Poly_Polygon3D::*)() const) static_cast<const TColStd_Array1OfReal & (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::Parameters),
             R"#(Returns true if parameters are associated with the nodes in this polygon.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeParameters",
             (TColStd_Array1OfReal & (Poly_Polygon3D::*)() const) static_cast<TColStd_Array1OfReal & (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::ChangeParameters),
             R"#(Returns the table of the parameters associated with each node in this polygon. ChangeParameters function returns the array as shared. Therefore if the table is selected by reference you can, by simply modifying it, directly modify the data structure of this polygon.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_Polygon3D::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_Polygon3D::*)() const>(&Poly_Polygon3D::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Poly_PolygonOnTriangulation from ./opencascade/Poly_PolygonOnTriangulation.hxx
    klass = m.attr("Poly_PolygonOnTriangulation");


    // nested enums

    static_cast<py::class_<Poly_PolygonOnTriangulation ,opencascade::handle<Poly_PolygonOnTriangulation>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const Standard_Integer,const Standard_Boolean >()  , py::arg("theNbNodes"),  py::arg("theHasParams") )
        .def(py::init<  const NCollection_Array1<Standard_Integer> & >()  , py::arg("Nodes") )
        .def(py::init<  const NCollection_Array1<Standard_Integer> &, const NCollection_Array1<Standard_Real> & >()  , py::arg("Nodes"),  py::arg("Parameters") )
    // custom constructors
    // methods
        .def("Copy",
             (opencascade::handle<Poly_PolygonOnTriangulation> (Poly_PolygonOnTriangulation::*)() const) static_cast<opencascade::handle<Poly_PolygonOnTriangulation> (Poly_PolygonOnTriangulation::*)() const>(&Poly_PolygonOnTriangulation::Copy),
             R"#(Creates a copy of current polygon)#" 
          )
        .def("Deflection",
             (Standard_Real (Poly_PolygonOnTriangulation::*)() const) static_cast<Standard_Real (Poly_PolygonOnTriangulation::*)() const>(&Poly_PolygonOnTriangulation::Deflection),
             R"#(Returns the deflection of this polygon)#" 
          )
        .def("Deflection",
             (void (Poly_PolygonOnTriangulation::*)( const Standard_Real  ) ) static_cast<void (Poly_PolygonOnTriangulation::*)( const Standard_Real  ) >(&Poly_PolygonOnTriangulation::Deflection),
             R"#(Sets the deflection of this polygon. See more on deflection in Poly_Polygones2D.)#"  , py::arg("theDefl")
          )
        .def("NbNodes",
             (Standard_Integer (Poly_PolygonOnTriangulation::*)() const) static_cast<Standard_Integer (Poly_PolygonOnTriangulation::*)() const>(&Poly_PolygonOnTriangulation::NbNodes),
             R"#(Returns the number of nodes for this polygon. Note: If the polygon is closed, the point of closure is repeated at the end of its table of nodes. Thus, on a closed triangle, the function NbNodes returns 4.)#" 
          )
        .def("Node",
             (Standard_Integer (Poly_PolygonOnTriangulation::*)( Standard_Integer  ) const) static_cast<Standard_Integer (Poly_PolygonOnTriangulation::*)( Standard_Integer  ) const>(&Poly_PolygonOnTriangulation::Node),
             R"#(Returns node at the given index.)#"  , py::arg("theIndex")
          )
        .def("SetNode",
             (void (Poly_PolygonOnTriangulation::*)( Standard_Integer ,  Standard_Integer  ) ) static_cast<void (Poly_PolygonOnTriangulation::*)( Standard_Integer ,  Standard_Integer  ) >(&Poly_PolygonOnTriangulation::SetNode),
             R"#(Sets node at the given index.)#"  , py::arg("theIndex"),  py::arg("theNode")
          )
        .def("HasParameters",
             (Standard_Boolean (Poly_PolygonOnTriangulation::*)() const) static_cast<Standard_Boolean (Poly_PolygonOnTriangulation::*)() const>(&Poly_PolygonOnTriangulation::HasParameters),
             R"#(Returns true if parameters are associated with the nodes in this polygon.)#" 
          )
        .def("Parameter",
             (Standard_Real (Poly_PolygonOnTriangulation::*)( Standard_Integer  ) const) static_cast<Standard_Real (Poly_PolygonOnTriangulation::*)( Standard_Integer  ) const>(&Poly_PolygonOnTriangulation::Parameter),
             R"#(Returns parameter at the given index.)#"  , py::arg("theIndex")
          )
        .def("SetParameter",
             (void (Poly_PolygonOnTriangulation::*)( Standard_Integer ,  Standard_Real  ) ) static_cast<void (Poly_PolygonOnTriangulation::*)( Standard_Integer ,  Standard_Real  ) >(&Poly_PolygonOnTriangulation::SetParameter),
             R"#(Sets parameter at the given index.)#"  , py::arg("theIndex"),  py::arg("theValue")
          )
        .def("SetParameters",
             (void (Poly_PolygonOnTriangulation::*)( const opencascade::handle<TColStd_HArray1OfReal> &  ) ) static_cast<void (Poly_PolygonOnTriangulation::*)( const opencascade::handle<TColStd_HArray1OfReal> &  ) >(&Poly_PolygonOnTriangulation::SetParameters),
             R"#(Sets the table of the parameters associated with each node in this polygon. Raises exception if array size doesn't much number of polygon nodes.)#"  , py::arg("theParameters")
          )
        .def("DumpJson",
             (void (Poly_PolygonOnTriangulation::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Poly_PolygonOnTriangulation::*)( std::ostream & ,  Standard_Integer  ) const>(&Poly_PolygonOnTriangulation::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_PolygonOnTriangulation::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_PolygonOnTriangulation::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_PolygonOnTriangulation::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_PolygonOnTriangulation::*)() const>(&Poly_PolygonOnTriangulation::DynamicType),
             R"#(None)#"
             
         )
       .def("Nodes",
             (const TColStd_Array1OfInteger & (Poly_PolygonOnTriangulation::*)() const) static_cast<const TColStd_Array1OfInteger & (Poly_PolygonOnTriangulation::*)() const>(&Poly_PolygonOnTriangulation::Nodes),
             R"#(Returns the table of nodes for this polygon. A node value is an index in the table of nodes specific to an existing triangulation of a shape.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Parameters",
             (const opencascade::handle<TColStd_HArray1OfReal> & (Poly_PolygonOnTriangulation::*)() const) static_cast<const opencascade::handle<TColStd_HArray1OfReal> & (Poly_PolygonOnTriangulation::*)() const>(&Poly_PolygonOnTriangulation::Parameters),
             R"#(Returns the table of the parameters associated with each node in this polygon. Warning! Use the function HasParameters to check if parameters are associated with the nodes in this polygon.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeNodes",
             (TColStd_Array1OfInteger & (Poly_PolygonOnTriangulation::*)() ) static_cast<TColStd_Array1OfInteger & (Poly_PolygonOnTriangulation::*)() >(&Poly_PolygonOnTriangulation::ChangeNodes),
             R"#(None)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeParameters",
             (TColStd_Array1OfReal & (Poly_PolygonOnTriangulation::*)() ) static_cast<TColStd_Array1OfReal & (Poly_PolygonOnTriangulation::*)() >(&Poly_PolygonOnTriangulation::ChangeParameters),
             R"#(None)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Poly_Triangle from ./opencascade/Poly_Triangle.hxx
    klass = m.attr("Poly_Triangle");


    // nested enums

    static_cast<py::class_<Poly_Triangle , shared_ptr<Poly_Triangle>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Integer,const Standard_Integer,const Standard_Integer >()  , py::arg("theN1"),  py::arg("theN2"),  py::arg("theN3") )
    // custom constructors
    // methods
        .def("Set",
             (void (Poly_Triangle::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) ) static_cast<void (Poly_Triangle::*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Integer  ) >(&Poly_Triangle::Set),
             R"#(Sets the value of the three nodes of this triangle.)#"  , py::arg("theN1"),  py::arg("theN2"),  py::arg("theN3")
          )
        .def("Set",
             (void (Poly_Triangle::*)( const Standard_Integer ,  const Standard_Integer  ) ) static_cast<void (Poly_Triangle::*)( const Standard_Integer ,  const Standard_Integer  ) >(&Poly_Triangle::Set),
             R"#(Sets the value of node with specified index of this triangle. Raises Standard_OutOfRange if index is not in 1,2,3)#"  , py::arg("theIndex"),  py::arg("theNode")
          )
        .def("Value",
             (Standard_Integer (Poly_Triangle::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (Poly_Triangle::*)( const Standard_Integer  ) const>(&Poly_Triangle::Value),
             R"#(Get the node of given Index. Raises OutOfRange from Standard if Index is not in 1,2,3)#"  , py::arg("theIndex")
          )
        .def("ChangeValue",
             (Standard_Integer & (Poly_Triangle::*)( const Standard_Integer  ) ) static_cast<Standard_Integer & (Poly_Triangle::*)( const Standard_Integer  ) >(&Poly_Triangle::ChangeValue),
             R"#(Get the node of given Index. Raises OutOfRange if Index is not in 1,2,3)#"  , py::arg("theIndex")
          )
    // methods using call by reference i.s.o. return
        .def("Get",
             []( Poly_Triangle &self   ){
                 Standard_Integer  theN1;
                Standard_Integer  theN2;
                Standard_Integer  theN3;

                 self.Get(theN1,theN2,theN3);
                 
                 return std::make_tuple(theN1,theN2,theN3); },
             R"#(Returns the node indices of this triangle.)#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
        .def("__call__",
             (Standard_Integer (Poly_Triangle::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (Poly_Triangle::*)( const Standard_Integer  ) const>(&Poly_Triangle::operator()),
             py::is_operator(),
             R"#(None)#"  , py::arg("Index")
          )
        .def("__call__",
             (Standard_Integer & (Poly_Triangle::*)( const Standard_Integer  ) ) static_cast<Standard_Integer & (Poly_Triangle::*)( const Standard_Integer  ) >(&Poly_Triangle::operator()),
             py::is_operator(),
             R"#(None)#"  , py::arg("Index")
          )
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Poly_Triangulation from ./opencascade/Poly_Triangulation.hxx
    klass = m.attr("Poly_Triangulation");


    // nested enums

    static_cast<py::class_<Poly_Triangulation ,opencascade::handle<Poly_Triangulation>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Integer,const Standard_Integer,const Standard_Boolean,const Standard_Boolean >()  , py::arg("theNbNodes"),  py::arg("theNbTriangles"),  py::arg("theHasUVNodes"),  py::arg("theHasNormals")=static_cast<const Standard_Boolean>(false) )
        .def(py::init<  const NCollection_Array1<gp_Pnt> &, const NCollection_Array1<Poly_Triangle> & >()  , py::arg("Nodes"),  py::arg("Triangles") )
        .def(py::init<  const NCollection_Array1<gp_Pnt> &, const NCollection_Array1<gp_Pnt2d> &, const NCollection_Array1<Poly_Triangle> & >()  , py::arg("Nodes"),  py::arg("UVNodes"),  py::arg("Triangles") )
        .def(py::init< const opencascade::handle<Poly_Triangulation> & >()  , py::arg("theTriangulation") )
    // custom constructors
    // methods
        .def("Copy",
             (opencascade::handle<Poly_Triangulation> (Poly_Triangulation::*)() const) static_cast<opencascade::handle<Poly_Triangulation> (Poly_Triangulation::*)() const>(&Poly_Triangulation::Copy),
             R"#(Creates full copy of current triangulation)#" 
          )
        .def("Deflection",
             (Standard_Real (Poly_Triangulation::*)() const) static_cast<Standard_Real (Poly_Triangulation::*)() const>(&Poly_Triangulation::Deflection),
             R"#(Returns the deflection of this triangulation.)#" 
          )
        .def("Deflection",
             (void (Poly_Triangulation::*)( const Standard_Real  ) ) static_cast<void (Poly_Triangulation::*)( const Standard_Real  ) >(&Poly_Triangulation::Deflection),
             R"#(Sets the deflection of this triangulation to theDeflection. See more on deflection in Polygon2D)#"  , py::arg("theDeflection")
          )
        .def("Parameters",
             (void (Poly_Triangulation::*)( const opencascade::handle<Poly_TriangulationParameters> &  ) ) static_cast<void (Poly_Triangulation::*)( const opencascade::handle<Poly_TriangulationParameters> &  ) >(&Poly_Triangulation::Parameters),
             R"#(Updates initial set of parameters used to generate this triangulation.)#"  , py::arg("theParams")
          )
        .def("Clear",
             (void (Poly_Triangulation::*)() ) static_cast<void (Poly_Triangulation::*)() >(&Poly_Triangulation::Clear),
             R"#(Clears internal arrays of nodes and all attributes.)#" 
          )
        .def("HasGeometry",
             (Standard_Boolean (Poly_Triangulation::*)() const) static_cast<Standard_Boolean (Poly_Triangulation::*)() const>(&Poly_Triangulation::HasGeometry),
             R"#(Returns TRUE if triangulation has some geometry.)#" 
          )
        .def("NbNodes",
             (Standard_Integer (Poly_Triangulation::*)() const) static_cast<Standard_Integer (Poly_Triangulation::*)() const>(&Poly_Triangulation::NbNodes),
             R"#(Returns the number of nodes for this triangulation.)#" 
          )
        .def("NbTriangles",
             (Standard_Integer (Poly_Triangulation::*)() const) static_cast<Standard_Integer (Poly_Triangulation::*)() const>(&Poly_Triangulation::NbTriangles),
             R"#(Returns the number of triangles for this triangulation.)#" 
          )
        .def("HasUVNodes",
             (Standard_Boolean (Poly_Triangulation::*)() const) static_cast<Standard_Boolean (Poly_Triangulation::*)() const>(&Poly_Triangulation::HasUVNodes),
             R"#(Returns Standard_True if 2D nodes are associated with 3D nodes for this triangulation.)#" 
          )
        .def("HasNormals",
             (Standard_Boolean (Poly_Triangulation::*)() const) static_cast<Standard_Boolean (Poly_Triangulation::*)() const>(&Poly_Triangulation::HasNormals),
             R"#(Returns Standard_True if nodal normals are defined.)#" 
          )
        .def("Node",
             (gp_Pnt (Poly_Triangulation::*)( Standard_Integer  ) const) static_cast<gp_Pnt (Poly_Triangulation::*)( Standard_Integer  ) const>(&Poly_Triangulation::Node),
             R"#(Returns a node at the given index.)#"  , py::arg("theIndex")
          )
        .def("SetNode",
             (void (Poly_Triangulation::*)( Standard_Integer ,  const gp_Pnt &  ) ) static_cast<void (Poly_Triangulation::*)( Standard_Integer ,  const gp_Pnt &  ) >(&Poly_Triangulation::SetNode),
             R"#(Sets a node coordinates.)#"  , py::arg("theIndex"),  py::arg("thePnt")
          )
        .def("UVNode",
             (gp_Pnt2d (Poly_Triangulation::*)( Standard_Integer  ) const) static_cast<gp_Pnt2d (Poly_Triangulation::*)( Standard_Integer  ) const>(&Poly_Triangulation::UVNode),
             R"#(Returns UV-node at the given index.)#"  , py::arg("theIndex")
          )
        .def("SetUVNode",
             (void (Poly_Triangulation::*)( Standard_Integer ,  const gp_Pnt2d &  ) ) static_cast<void (Poly_Triangulation::*)( Standard_Integer ,  const gp_Pnt2d &  ) >(&Poly_Triangulation::SetUVNode),
             R"#(Sets an UV-node coordinates.)#"  , py::arg("theIndex"),  py::arg("thePnt")
          )
        .def("Triangle",
             (const Poly_Triangle & (Poly_Triangulation::*)( Standard_Integer  ) const) static_cast<const Poly_Triangle & (Poly_Triangulation::*)( Standard_Integer  ) const>(&Poly_Triangulation::Triangle),
             R"#(Returns triangle at the given index.)#"  , py::arg("theIndex")
          )
        .def("SetTriangle",
             (void (Poly_Triangulation::*)( Standard_Integer ,  const Poly_Triangle &  ) ) static_cast<void (Poly_Triangulation::*)( Standard_Integer ,  const Poly_Triangle &  ) >(&Poly_Triangulation::SetTriangle),
             R"#(Sets a triangle.)#"  , py::arg("theIndex"),  py::arg("theTriangle")
          )
        .def("Normal",
             (gp_Dir (Poly_Triangulation::*)( Standard_Integer  ) const) static_cast<gp_Dir (Poly_Triangulation::*)( Standard_Integer  ) const>(&Poly_Triangulation::Normal),
             R"#(Returns normal at the given index.)#"  , py::arg("theIndex")
          )
        .def("Normal",
             (void (Poly_Triangulation::*)( Standard_Integer ,  NCollection_Vec3<Standard_ShortReal> &  ) const) static_cast<void (Poly_Triangulation::*)( Standard_Integer ,  NCollection_Vec3<Standard_ShortReal> &  ) const>(&Poly_Triangulation::Normal),
             R"#(Returns normal at the given index.)#"  , py::arg("theIndex"),  py::arg("theVec3")
          )
        .def("SetNormal",
             (void (Poly_Triangulation::*)( const Standard_Integer ,   const NCollection_Vec3<Standard_ShortReal> &  ) ) static_cast<void (Poly_Triangulation::*)( const Standard_Integer ,   const NCollection_Vec3<Standard_ShortReal> &  ) >(&Poly_Triangulation::SetNormal),
             R"#(Changes normal at the given index.)#"  , py::arg("theIndex"),  py::arg("theNormal")
          )
        .def("SetNormal",
             (void (Poly_Triangulation::*)( const Standard_Integer ,  const gp_Dir &  ) ) static_cast<void (Poly_Triangulation::*)( const Standard_Integer ,  const gp_Dir &  ) >(&Poly_Triangulation::SetNormal),
             R"#(Changes normal at the given index.)#"  , py::arg("theIndex"),  py::arg("theNormal")
          )
        .def("MeshPurpose",
             (Poly_MeshPurpose (Poly_Triangulation::*)() const) static_cast<Poly_MeshPurpose (Poly_Triangulation::*)() const>(&Poly_Triangulation::MeshPurpose),
             R"#(Returns mesh purpose bits.)#" 
          )
        .def("SetMeshPurpose",
             (void (Poly_Triangulation::*)( const Poly_MeshPurpose  ) ) static_cast<void (Poly_Triangulation::*)( const Poly_MeshPurpose  ) >(&Poly_Triangulation::SetMeshPurpose),
             R"#(Sets mesh purpose bits.)#"  , py::arg("thePurpose")
          )
        .def("SetCachedMinMax",
             (void (Poly_Triangulation::*)( const Bnd_Box &  ) ) static_cast<void (Poly_Triangulation::*)( const Bnd_Box &  ) >(&Poly_Triangulation::SetCachedMinMax),
             R"#(Sets a cached min - max range of this triangulation. The bounding box should exactly match actual range of triangulation data without a gap or transformation, or otherwise undefined behavior will be observed. Passing a VOID range invalidates the cache.)#"  , py::arg("theBox")
          )
        .def("HasCachedMinMax",
             (Standard_Boolean (Poly_Triangulation::*)() const) static_cast<Standard_Boolean (Poly_Triangulation::*)() const>(&Poly_Triangulation::HasCachedMinMax),
             R"#(Returns TRUE if there is some cached min - max range of this triangulation.)#" 
          )
        .def("UpdateCachedMinMax",
             (void (Poly_Triangulation::*)() ) static_cast<void (Poly_Triangulation::*)() >(&Poly_Triangulation::UpdateCachedMinMax),
             R"#(Updates cached min - max range of this triangulation with bounding box of nodal data.)#" 
          )
        .def("MinMax",
             (Standard_Boolean (Poly_Triangulation::*)( Bnd_Box & ,  const gp_Trsf & ,  const bool  ) const) static_cast<Standard_Boolean (Poly_Triangulation::*)( Bnd_Box & ,  const gp_Trsf & ,  const bool  ) const>(&Poly_Triangulation::MinMax),
             R"#(Extends the passed box with bounding box of this triangulation. Uses cached min - max range when available and: - input transformation theTrsf has no rotation part; - theIsAccurate is set to FALSE; - no triangulation data available (e.g. it is deferred and not loaded).)#"  , py::arg("theBox"),  py::arg("theTrsf"),  py::arg("theIsAccurate")=static_cast<const bool>(false)
          )
        .def("DumpJson",
             (void (Poly_Triangulation::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Poly_Triangulation::*)( std::ostream & ,  Standard_Integer  ) const>(&Poly_Triangulation::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("IsDoublePrecision",
             (bool (Poly_Triangulation::*)() const) static_cast<bool (Poly_Triangulation::*)() const>(&Poly_Triangulation::IsDoublePrecision),
             R"#(Returns TRUE if node positions are defined with double precision; TRUE by default.)#" 
          )
        .def("SetDoublePrecision",
             (void (Poly_Triangulation::*)( bool  ) ) static_cast<void (Poly_Triangulation::*)( bool  ) >(&Poly_Triangulation::SetDoublePrecision),
             R"#(Set if node positions should be defined with double or single precision for 3D and UV nodes. Raises exception if data was already allocated.)#"  , py::arg("theIsDouble")
          )
        .def("ResizeNodes",
             (void (Poly_Triangulation::*)( Standard_Integer ,  Standard_Boolean  ) ) static_cast<void (Poly_Triangulation::*)( Standard_Integer ,  Standard_Boolean  ) >(&Poly_Triangulation::ResizeNodes),
             R"#(Method resizing internal arrays of nodes (synchronously for all attributes).)#"  , py::arg("theNbNodes"),  py::arg("theToCopyOld")
          )
        .def("ResizeTriangles",
             (void (Poly_Triangulation::*)( Standard_Integer ,  Standard_Boolean  ) ) static_cast<void (Poly_Triangulation::*)( Standard_Integer ,  Standard_Boolean  ) >(&Poly_Triangulation::ResizeTriangles),
             R"#(Method resizing an internal array of triangles.)#"  , py::arg("theNbTriangles"),  py::arg("theToCopyOld")
          )
        .def("AddUVNodes",
             (void (Poly_Triangulation::*)() ) static_cast<void (Poly_Triangulation::*)() >(&Poly_Triangulation::AddUVNodes),
             R"#(If an array for UV coordinates is not allocated yet, do it now.)#" 
          )
        .def("RemoveUVNodes",
             (void (Poly_Triangulation::*)() ) static_cast<void (Poly_Triangulation::*)() >(&Poly_Triangulation::RemoveUVNodes),
             R"#(Deallocates the UV nodes array.)#" 
          )
        .def("AddNormals",
             (void (Poly_Triangulation::*)() ) static_cast<void (Poly_Triangulation::*)() >(&Poly_Triangulation::AddNormals),
             R"#(If an array for normals is not allocated yet, do it now.)#" 
          )
        .def("RemoveNormals",
             (void (Poly_Triangulation::*)() ) static_cast<void (Poly_Triangulation::*)() >(&Poly_Triangulation::RemoveNormals),
             R"#(Deallocates the normals array.)#" 
          )
        .def("ComputeNormals",
             (void (Poly_Triangulation::*)() ) static_cast<void (Poly_Triangulation::*)() >(&Poly_Triangulation::ComputeNormals),
             R"#(Compute smooth normals by averaging triangle normals.)#" 
          )
        .def("MapNodeArray",
             (opencascade::handle<TColgp_HArray1OfPnt> (Poly_Triangulation::*)() const) static_cast<opencascade::handle<TColgp_HArray1OfPnt> (Poly_Triangulation::*)() const>(&Poly_Triangulation::MapNodeArray),
             R"#(Returns the table of 3D points for read-only access or NULL if nodes array is undefined. Poly_Triangulation::Node() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.)#" 
          )
        .def("MapTriangleArray",
             (opencascade::handle<Poly_HArray1OfTriangle> (Poly_Triangulation::*)() const) static_cast<opencascade::handle<Poly_HArray1OfTriangle> (Poly_Triangulation::*)() const>(&Poly_Triangulation::MapTriangleArray),
             R"#(Returns the triangle array for read-only access or NULL if triangle array is undefined. Poly_Triangulation::Triangle() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.)#" 
          )
        .def("MapUVNodeArray",
             (opencascade::handle<TColgp_HArray1OfPnt2d> (Poly_Triangulation::*)() const) static_cast<opencascade::handle<TColgp_HArray1OfPnt2d> (Poly_Triangulation::*)() const>(&Poly_Triangulation::MapUVNodeArray),
             R"#(Returns the table of 2D nodes for read-only access or NULL if UV nodes array is undefined. Poly_Triangulation::UVNode() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.)#" 
          )
        .def("MapNormalArray",
             (opencascade::handle<TShort_HArray1OfShortReal> (Poly_Triangulation::*)() const) static_cast<opencascade::handle<TShort_HArray1OfShortReal> (Poly_Triangulation::*)() const>(&Poly_Triangulation::MapNormalArray),
             R"#(Returns the table of per-vertex normals for read-only access or NULL if normals array is undefined. Poly_Triangulation::Normal() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.)#" 
          )
        .def("SetNormals",
             (void (Poly_Triangulation::*)( const opencascade::handle<TShort_HArray1OfShortReal> &  ) ) static_cast<void (Poly_Triangulation::*)( const opencascade::handle<TShort_HArray1OfShortReal> &  ) >(&Poly_Triangulation::SetNormals),
             R"#(None)#"  , py::arg("theNormals")
          )
        .def("ChangeTriangle",
             (Poly_Triangle & (Poly_Triangulation::*)( const Standard_Integer  ) ) static_cast<Poly_Triangle & (Poly_Triangulation::*)( const Standard_Integer  ) >(&Poly_Triangulation::ChangeTriangle),
             R"#(None)#"  , py::arg("theIndex")
          )
        .def("NbDeferredNodes",
             (Standard_Integer (Poly_Triangulation::*)() const) static_cast<Standard_Integer (Poly_Triangulation::*)() const>(&Poly_Triangulation::NbDeferredNodes),
             R"#(Returns number of deferred nodes that can be loaded using LoadDeferredData(). Note: this is estimated values, which might be different from actually loaded values. Always check triangulation size of actually loaded data in code to avoid out-of-range issues.)#" 
          )
        .def("NbDeferredTriangles",
             (Standard_Integer (Poly_Triangulation::*)() const) static_cast<Standard_Integer (Poly_Triangulation::*)() const>(&Poly_Triangulation::NbDeferredTriangles),
             R"#(Returns number of deferred triangles that can be loaded using LoadDeferredData(). Note: this is estimated values, which might be different from actually loaded values Always check triangulation size of actually loaded data in code to avoid out-of-range issues.)#" 
          )
        .def("HasDeferredData",
             (Standard_Boolean (Poly_Triangulation::*)() const) static_cast<Standard_Boolean (Poly_Triangulation::*)() const>(&Poly_Triangulation::HasDeferredData),
             R"#(Returns TRUE if there is some triangulation data that can be loaded using LoadDeferredData().)#" 
          )
        .def("LoadDeferredData",
             (Standard_Boolean (Poly_Triangulation::*)( const opencascade::handle<OSD_FileSystem> &  ) ) static_cast<Standard_Boolean (Poly_Triangulation::*)( const opencascade::handle<OSD_FileSystem> &  ) >(&Poly_Triangulation::LoadDeferredData),
             R"#(Loads triangulation data into itself from some deferred storage using specified shared input file system.)#"  , py::arg("theFileSystem")=static_cast<const opencascade::handle<OSD_FileSystem> &>(Handle ( OSD_FileSystem ) ( ))
          )
        .def("DetachedLoadDeferredData",
             (opencascade::handle<Poly_Triangulation> (Poly_Triangulation::*)( const opencascade::handle<OSD_FileSystem> &  ) const) static_cast<opencascade::handle<Poly_Triangulation> (Poly_Triangulation::*)( const opencascade::handle<OSD_FileSystem> &  ) const>(&Poly_Triangulation::DetachedLoadDeferredData),
             R"#(Loads triangulation data into new Poly_Triangulation object from some deferred storage using specified shared input file system.)#"  , py::arg("theFileSystem")=static_cast<const opencascade::handle<OSD_FileSystem> &>(Handle ( OSD_FileSystem ) ( ))
          )
        .def("UnloadDeferredData",
             (Standard_Boolean (Poly_Triangulation::*)() ) static_cast<Standard_Boolean (Poly_Triangulation::*)() >(&Poly_Triangulation::UnloadDeferredData),
             R"#(Releases triangulation data if it has connected deferred storage.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_Triangulation::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_Triangulation::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_Triangulation::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_Triangulation::*)() const>(&Poly_Triangulation::DynamicType),
             R"#(None)#"
             
         )
       .def("Parameters",
             (const opencascade::handle<Poly_TriangulationParameters> & (Poly_Triangulation::*)() const) static_cast<const opencascade::handle<Poly_TriangulationParameters> & (Poly_Triangulation::*)() const>(&Poly_Triangulation::Parameters),
             R"#(Returns initial set of parameters used to generate this triangulation.)#"
             
         )
       .def("CachedMinMax",
             (const Bnd_Box & (Poly_Triangulation::*)() const) static_cast<const Bnd_Box & (Poly_Triangulation::*)() const>(&Poly_Triangulation::CachedMinMax),
             R"#(Returns cached min - max range of triangulation data, which is VOID by default (e.g, no cached information).)#"
             
         )
       .def("InternalTriangles",
             (Poly_Array1OfTriangle & (Poly_Triangulation::*)() ) static_cast<Poly_Array1OfTriangle & (Poly_Triangulation::*)() >(&Poly_Triangulation::InternalTriangles),
             R"#(Returns an internal array of triangles. Triangle()/SetTriangle() should be used instead in portable code.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("InternalNodes",
             (Poly_ArrayOfNodes & (Poly_Triangulation::*)() ) static_cast<Poly_ArrayOfNodes & (Poly_Triangulation::*)() >(&Poly_Triangulation::InternalNodes),
             R"#(Returns an internal array of nodes. Node()/SetNode() should be used instead in portable code.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("InternalUVNodes",
             (Poly_ArrayOfUVNodes & (Poly_Triangulation::*)() ) static_cast<Poly_ArrayOfUVNodes & (Poly_Triangulation::*)() >(&Poly_Triangulation::InternalUVNodes),
             R"#(Returns an internal array of UV nodes. UBNode()/SetUVNode() should be used instead in portable code.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("InternalNormals",
             (NCollection_Array1<gp_Vec3f> & (Poly_Triangulation::*)() ) static_cast<NCollection_Array1<gp_Vec3f> & (Poly_Triangulation::*)() >(&Poly_Triangulation::InternalNormals),
             R"#(Return an internal array of normals. Normal()/SetNormal() should be used instead in portable code.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("Triangles",
             (const Poly_Array1OfTriangle & (Poly_Triangulation::*)() const) static_cast<const Poly_Array1OfTriangle & (Poly_Triangulation::*)() const>(&Poly_Triangulation::Triangles),
             R"#(None)#"
             
         )
       .def("ChangeTriangles",
             (Poly_Array1OfTriangle & (Poly_Triangulation::*)() ) static_cast<Poly_Array1OfTriangle & (Poly_Triangulation::*)() >(&Poly_Triangulation::ChangeTriangles),
             R"#(None)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Poly_TriangulationParameters from ./opencascade/Poly_TriangulationParameters.hxx
    klass = m.attr("Poly_TriangulationParameters");


    // nested enums

    static_cast<py::class_<Poly_TriangulationParameters ,opencascade::handle<Poly_TriangulationParameters>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Real >()  , py::arg("theDeflection")=static_cast<const Standard_Real>(- 1.),  py::arg("theAngle")=static_cast<const Standard_Real>(- 1.),  py::arg("theMinSize")=static_cast<const Standard_Real>(- 1.) )
    // custom constructors
    // methods
        .def("HasDeflection",
             (Standard_Boolean (Poly_TriangulationParameters::*)() const) static_cast<Standard_Boolean (Poly_TriangulationParameters::*)() const>(&Poly_TriangulationParameters::HasDeflection),
             R"#(Returns true if linear deflection is defined.)#" 
          )
        .def("HasAngle",
             (Standard_Boolean (Poly_TriangulationParameters::*)() const) static_cast<Standard_Boolean (Poly_TriangulationParameters::*)() const>(&Poly_TriangulationParameters::HasAngle),
             R"#(Returns true if angular deflection is defined.)#" 
          )
        .def("HasMinSize",
             (Standard_Boolean (Poly_TriangulationParameters::*)() const) static_cast<Standard_Boolean (Poly_TriangulationParameters::*)() const>(&Poly_TriangulationParameters::HasMinSize),
             R"#(Returns true if minimum size is defined.)#" 
          )
        .def("Deflection",
             (Standard_Real (Poly_TriangulationParameters::*)() const) static_cast<Standard_Real (Poly_TriangulationParameters::*)() const>(&Poly_TriangulationParameters::Deflection),
             R"#(Returns linear deflection or -1 if undefined.)#" 
          )
        .def("Angle",
             (Standard_Real (Poly_TriangulationParameters::*)() const) static_cast<Standard_Real (Poly_TriangulationParameters::*)() const>(&Poly_TriangulationParameters::Angle),
             R"#(Returns angular deflection or -1 if undefined.)#" 
          )
        .def("MinSize",
             (Standard_Real (Poly_TriangulationParameters::*)() const) static_cast<Standard_Real (Poly_TriangulationParameters::*)() const>(&Poly_TriangulationParameters::MinSize),
             R"#(Returns minimum size or -1 if undefined.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Poly_TriangulationParameters::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Poly_TriangulationParameters::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Poly_TriangulationParameters::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Poly_TriangulationParameters::*)() const>(&Poly_TriangulationParameters::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Poly_MakeLoops2D from ./opencascade/Poly_MakeLoops.hxx
    klass = m.attr("Poly_MakeLoops2D");


    // nested enums

    static_cast<py::class_<Poly_MakeLoops2D , shared_ptr<Poly_MakeLoops2D>  >>(klass)
    // constructors
        .def(py::init< const Standard_Boolean,const Poly_MakeLoops2D::Helper *,const opencascade::handle<NCollection_BaseAllocator> & >()  , py::arg("theLeftWay"),  py::arg("theHelper"),  py::arg("theAlloc") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Poly_MakeLoops3D from ./opencascade/Poly_MakeLoops.hxx
    klass = m.attr("Poly_MakeLoops3D");


    // nested enums

    static_cast<py::class_<Poly_MakeLoops3D , shared_ptr<Poly_MakeLoops3D>  >>(klass)
    // constructors
        .def(py::init< const Poly_MakeLoops3D::Helper *,const opencascade::handle<NCollection_BaseAllocator> & >()  , py::arg("theHelper"),  py::arg("theAlloc") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/Poly.hxx
// ./opencascade/Poly_Array1OfTriangle.hxx
// ./opencascade/Poly_ArrayOfNodes.hxx
// ./opencascade/Poly_ArrayOfUVNodes.hxx
// ./opencascade/Poly_CoherentLink.hxx
// ./opencascade/Poly_CoherentNode.hxx
// ./opencascade/Poly_CoherentTriPtr.hxx
// ./opencascade/Poly_CoherentTriangle.hxx
// ./opencascade/Poly_CoherentTriangulation.hxx
// ./opencascade/Poly_Connect.hxx
// ./opencascade/Poly_HArray1OfTriangle.hxx
// ./opencascade/Poly_ListOfTriangulation.hxx
// ./opencascade/Poly_MakeLoops.hxx
// ./opencascade/Poly_MergeNodesTool.hxx
// ./opencascade/Poly_MeshPurpose.hxx
// ./opencascade/Poly_Polygon2D.hxx
// ./opencascade/Poly_Polygon3D.hxx
// ./opencascade/Poly_PolygonOnTriangulation.hxx
// ./opencascade/Poly_Triangle.hxx
// ./opencascade/Poly_Triangulation.hxx
// ./opencascade/Poly_TriangulationParameters.hxx

// Additional functions

// operators

// register typdefs
    register_template_NCollection_Array1<Poly_Triangle>(m,"Poly_Array1OfTriangle");
    register_template_NCollection_List<opencascade::handle<Poly_Triangulation>>(m,"Poly_ListOfTriangulation");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
